/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import org.gradle.api.Buildable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultResolvedArtifact
implements ResolvedArtifact,
Buildable,
ResolvableArtifact {
    private final ModuleVersionIdentifier owner;
    private final IvyArtifactName artifact;
    private final ComponentArtifactIdentifier artifactId;
    private final TaskDependency buildDependencies;
    private volatile Factory<File> artifactSource;
    private volatile File file;
    private volatile Throwable failure;

    public DefaultResolvedArtifact(ModuleVersionIdentifier owner, IvyArtifactName artifact, ComponentArtifactIdentifier artifactId, TaskDependency buildDependencies, Factory<File> artifactSource) {
        this.owner = owner;
        this.artifact = artifact;
        this.artifactId = artifactId;
        this.buildDependencies = buildDependencies;
        this.artifactSource = artifactSource;
    }

    public DefaultResolvedArtifact(ModuleVersionIdentifier owner, IvyArtifactName artifact, ComponentArtifactIdentifier artifactId, TaskDependency buildDependencies, File artifactFile) {
        this.owner = owner;
        this.artifact = artifact;
        this.artifactId = artifactId;
        this.buildDependencies = buildDependencies;
        this.file = artifactFile;
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.buildDependencies;
    }

    @Override
    public ResolvedModuleVersion getModuleVersion() {
        return new DefaultResolvedModuleVersion(this.owner);
    }

    @Override
    public ComponentArtifactIdentifier getId() {
        return this.artifactId;
    }

    public String toString() {
        return this.artifactId.getDisplayName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultResolvedArtifact other = (DefaultResolvedArtifact)obj;
        return other.owner.equals(this.owner) && other.artifactId.equals(this.artifactId);
    }

    public int hashCode() {
        return this.owner.hashCode() ^ this.artifactId.hashCode();
    }

    @Override
    public String getName() {
        return this.artifact.getName();
    }

    @Override
    public String getType() {
        return this.artifact.getType();
    }

    @Override
    public String getExtension() {
        return this.artifact.getExtension();
    }

    @Override
    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    @Override
    public ResolvedArtifact toPublicView() {
        return this;
    }

    @Override
    public boolean isResolveSynchronously() {
        if (this.artifactId instanceof LocalComponentArtifactMetadata) {
            return true;
        }
        return this.file != null || this.failure != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getFile() {
        File f = this.file;
        if (f == null) {
            DefaultResolvedArtifact defaultResolvedArtifact = this;
            synchronized (defaultResolvedArtifact) {
                f = this.file;
                if (f == null) {
                    Throwable err = this.failure;
                    if (err != null) {
                        throw UncheckedException.throwAsUncheckedException(err);
                    }
                    try {
                        this.file = f = this.artifactSource.create();
                    }
                    catch (Throwable e) {
                        this.failure = err = e;
                        throw UncheckedException.throwAsUncheckedException(err);
                    }
                    finally {
                        this.artifactSource = null;
                    }
                }
            }
        }
        return f;
    }
}

