/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.Module;

public class DefaultModuleVersionIdentifier
implements ModuleVersionIdentifier {
    private final ModuleIdentifier id;
    private final String version;
    private final int hashCode;

    public DefaultModuleVersionIdentifier(String group, String name, String version) {
        assert (group != null) : "group cannot be null";
        assert (name != null) : "name cannot be null";
        assert (version != null) : "version cannot be null";
        this.id = DefaultModuleIdentifier.newId(group, name);
        this.version = version;
        this.hashCode = 31 * this.id.hashCode() ^ version.hashCode();
    }

    public DefaultModuleVersionIdentifier(ModuleIdentifier id, String version) {
        assert (version != null) : "version cannot be null";
        this.id = id;
        this.version = version;
        this.hashCode = 31 * id.hashCode() ^ version.hashCode();
    }

    @Override
    public String getGroup() {
        return this.id.getGroup();
    }

    @Override
    public String getName() {
        return this.id.getName();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String toString() {
        String group = this.id.getGroup();
        String module = this.id.getName();
        return group + ":" + module + ":" + this.version;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultModuleVersionIdentifier other = (DefaultModuleVersionIdentifier)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        return this.version.equals(other.version);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public ModuleIdentifier getModule() {
        return this.id;
    }

    public static ModuleVersionIdentifier newId(Module module) {
        return new DefaultModuleVersionIdentifier(module.getGroup(), module.getName(), module.getVersion());
    }

    public static ModuleVersionIdentifier newId(String group, String name, String version) {
        return new DefaultModuleVersionIdentifier(group, name, version);
    }

    public static ModuleVersionIdentifier newId(ModuleComponentIdentifier componentId) {
        return new DefaultModuleVersionIdentifier(componentId.getGroup(), componentId.getModule(), componentId.getVersion());
    }
}

