/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.inject.Inject;
import org.gradle.api.Transformer;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.service.ServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyInjectingInstantiator
implements Instantiator {
    private final ServiceRegistry services;
    private final CrossBuildInMemoryCache<Class<?>, CachedConstructor> constructorCache;
    private final ClassGenerator classGenerator;

    public DependencyInjectingInstantiator(ServiceRegistry services, CrossBuildInMemoryCache<Class<?>, CachedConstructor> constructorCache) {
        this.classGenerator = new ClassGenerator(){

            @Override
            public <T> Class<? extends T> generate(Class<T> type) {
                return type;
            }
        };
        this.services = services;
        this.constructorCache = constructorCache;
    }

    public DependencyInjectingInstantiator(ClassGenerator classGenerator, ServiceRegistry services, CrossBuildInMemoryCache<Class<?>, CachedConstructor> constructorCache) {
        this.classGenerator = classGenerator;
        this.services = services;
        this.constructorCache = constructorCache;
    }

    @Override
    public <T> T newInstance(final Class<? extends T> type, Object ... parameters) {
        try {
            CachedConstructor cached = this.constructorCache.get(type, new Transformer<CachedConstructor, Class<?>>(){

                @Override
                public CachedConstructor transform(Class<?> aClass) {
                    try {
                        DependencyInjectingInstantiator.validateType(type);
                        Class implClass = DependencyInjectingInstantiator.this.classGenerator.generate(type);
                        Constructor constructor = DependencyInjectingInstantiator.selectConstructor(type, implClass);
                        constructor.setAccessible(true);
                        return CachedConstructor.of(constructor);
                    }
                    catch (Throwable e) {
                        return CachedConstructor.of(e);
                    }
                }
            });
            if (cached.error != null) {
                throw cached.error;
            }
            Constructor constructor = cached.constructor;
            Object[] resolvedParameters = this.convertParameters(type, constructor, parameters);
            try {
                Object instance = constructor.newInstance(resolvedParameters);
                if (instance instanceof WithServiceRegistry) {
                    ((WithServiceRegistry)instance).setServices(this.services);
                }
                return type.cast(instance);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable t) {
            throw new ObjectInstantiationException(type, t);
        }
    }

    private <T> Object[] convertParameters(Class<T> type, Constructor<?> constructor, Object[] parameters) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length < parameters.length) {
            throw new IllegalArgumentException(String.format("Too many parameters provided for constructor for class %s. Expected %s, received %s.", type.getName(), parameterTypes.length, parameters.length));
        }
        Type[] genericTypes = constructor.getGenericParameterTypes();
        Object[] resolvedParameters = new Object[parameterTypes.length];
        int pos = 0;
        for (int i = 0; i < resolvedParameters.length; ++i) {
            Object currentParameter;
            Class<?> targetType = parameterTypes[i];
            if (targetType.isPrimitive()) {
                targetType = JavaReflectionUtil.getWrapperTypeForPrimitiveType(targetType);
            }
            Type serviceType = genericTypes[i];
            if (pos < parameters.length && targetType.isInstance(parameters[pos])) {
                currentParameter = parameters[pos];
                ++pos;
            } else {
                currentParameter = this.services.find(serviceType);
            }
            if (currentParameter == null) {
                StringBuilder builder = new StringBuilder(String.format("Unable to determine %s argument #%s:", type.getName(), i + 1));
                if (pos < parameters.length) {
                    builder.append(String.format(" value %s not assignable to type %s", parameters[pos], parameterTypes[i]));
                } else {
                    builder.append(String.format(" missing parameter value of type %s", parameterTypes[i]));
                }
                builder.append(String.format(", or no service of type %s", serviceType));
                throw new IllegalArgumentException(builder.toString());
            }
            resolvedParameters[i] = currentParameter;
        }
        if (pos != parameters.length) {
            throw new IllegalArgumentException(String.format("Unexpected parameter provided for constructor for class %s.", type.getName()));
        }
        return resolvedParameters;
    }

    private static boolean isPublicOrPackageScoped(Class<?> type, Constructor<?> constructor) {
        if (DependencyInjectingInstantiator.isPackagePrivate(type.getModifiers())) {
            return !Modifier.isPrivate(constructor.getModifiers()) && !Modifier.isProtected(constructor.getModifiers());
        }
        return Modifier.isPublic(constructor.getModifiers());
    }

    private static boolean isPackagePrivate(int modifiers) {
        return !Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPublic(modifiers);
    }

    private static <T> void validateType(Class<T> type) {
        if (type.isInterface() || type.isAnnotation() || type.isEnum()) {
            throw new IllegalArgumentException(String.format("Type %s is not a class.", type.getName()));
        }
        if (type.getEnclosingClass() != null && !Modifier.isStatic(type.getModifiers())) {
            throw new IllegalArgumentException(String.format("Class %s is a non-static inner class.", type.getName()));
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalArgumentException(String.format("Class %s is an abstract class.", type.getName()));
        }
    }

    private static Constructor<?> selectConstructor(Class<?> type, Class<?> implType) {
        Constructor<?>[] constructors = implType.getDeclaredConstructors();
        if (constructors.length == 1) {
            Constructor<?> constructor = constructors[0];
            if (constructor.getParameterTypes().length == 0 && DependencyInjectingInstantiator.isPublicOrPackageScoped(implType, constructor)) {
                return constructor;
            }
            if (constructor.getAnnotation(Inject.class) != null) {
                return constructor;
            }
            if (constructor.getParameterTypes().length == 0) {
                throw new IllegalArgumentException(String.format("The constructor for class %s should be public or package protected or annotated with @Inject.", type.getName()));
            }
            throw new IllegalArgumentException(String.format("The constructor for class %s should be annotated with @Inject.", type.getName()));
        }
        ArrayList injectConstructors = new ArrayList();
        for (Constructor<?> constructor : constructors) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            injectConstructors.add(constructor);
        }
        if (injectConstructors.isEmpty()) {
            throw new IllegalArgumentException(String.format("Class %s has no constructor that is annotated with @Inject.", type.getName()));
        }
        if (injectConstructors.size() > 1) {
            throw new IllegalArgumentException(String.format("Class %s has multiple constructors that are annotated with @Inject.", type.getName()));
        }
        return (Constructor)injectConstructors.get(0);
    }

    public static interface WithServiceRegistry {
        public void setServices(ServiceRegistry var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CachedConstructor {
        private final Constructor<?> constructor;
        private final Throwable error;

        private CachedConstructor(Constructor<?> constructor, Throwable error) {
            this.constructor = constructor;
            this.error = error;
        }

        public static CachedConstructor of(Constructor<?> ctor) {
            return new CachedConstructor(ctor, null);
        }

        public static CachedConstructor of(Throwable err) {
            return new CachedConstructor(null, err);
        }
    }
}

