/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaProperty;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.internal.AbstractClassGenerator;
import org.gradle.api.internal.ConventionAwareHelper;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.DependencyInjectingInstantiator;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.GeneratedSubclass;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.ThreadGlobalInstantiator;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.ClassWriter;
import org.gradle.internal.impldep.org.objectweb.asm.Label;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Type;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.PropertyAccess;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.model.internal.asm.AsmClassGenerator;
import org.gradle.model.internal.asm.AsmClassGeneratorUtils;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmBackedClassGenerator
extends AbstractClassGenerator {
    @Override
    protected <T> AbstractClassGenerator.ClassBuilder<T> start(Class<T> type, AbstractClassGenerator.ClassMetaData classMetaData) {
        return new ClassBuilderImpl(type, classMetaData);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MixInExtensibleDynamicObject
    extends ExtensibleDynamicObject {
        public MixInExtensibleDynamicObject(Object decoratedObject, Class<?> publicType, @Nullable DynamicObject selfProvidedDynamicObject) {
            super(decoratedObject, MixInExtensibleDynamicObject.wrap(decoratedObject, publicType, selfProvidedDynamicObject), ThreadGlobalInstantiator.getOrCreate());
        }

        private static AbstractDynamicObject wrap(Object delegateObject, Class<?> publicType, DynamicObject dynamicObject) {
            if (dynamicObject != null) {
                return (AbstractDynamicObject)dynamicObject;
            }
            return new BeanDynamicObject(delegateObject, publicType);
        }
    }

    private static interface MethodCodeBody {
        public void add(MethodVisitor var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassBuilderImpl<T>
    implements AbstractClassGenerator.ClassBuilder<T> {
        public static final int PV_FINAL_STATIC = 4122;
        private static final Set<? extends Class<?>> PRIMITIVE_TYPES = ImmutableSet.of(Byte.TYPE, Boolean.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, (Object[])new Class[]{Float.TYPE, Double.TYPE});
        private static final String DYNAMIC_OBJECT_HELPER_FIELD = "__dyn_obj__";
        private static final String MAPPING_FIELD = "__mapping__";
        private static final String META_CLASS_FIELD = "__meta_class__";
        private static final String CONVENTION_MAPPING_FIELD_DESCRIPTOR = Type.getDescriptor(ConventionMapping.class);
        private static final String META_CLASS_TYPE_DESCRIPTOR = Type.getDescriptor(MetaClass.class);
        private static final Type META_CLASS_TYPE = Type.getType(MetaClass.class);
        private static final Type GENERATED_SUBCLASS_TYPE = Type.getType(GeneratedSubclass.class);
        private static final Type CONVENTION_AWARE_TYPE = Type.getType(IConventionAware.class);
        private static final Type CONVENTION_AWARE_HELPER_TYPE = Type.getType(ConventionAwareHelper.class);
        private static final Type DYNAMIC_OBJECT_AWARE_TYPE = Type.getType(DynamicObjectAware.class);
        private static final Type EXTENSION_AWARE_TYPE = Type.getType(ExtensionAware.class);
        private static final Type HAS_CONVENTION_TYPE = Type.getType(HasConvention.class);
        private static final Type DYNAMIC_OBJECT_TYPE = Type.getType(DynamicObject.class);
        private static final Type CONVENTION_MAPPING_TYPE = Type.getType(ConventionMapping.class);
        private static final Type GROOVY_OBJECT_TYPE = Type.getType(GroovyObject.class);
        private static final Type CONVENTION_TYPE = Type.getType(Convention.class);
        private static final Type ABSTRACT_DYNAMIC_OBJECT_TYPE = Type.getType(AbstractDynamicObject.class);
        private static final Type EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE = Type.getType(MixInExtensibleDynamicObject.class);
        private static final Type NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE = Type.getType(BeanDynamicObject.class);
        private static final String JAVA_REFLECT_TYPE_DESCRIPTOR = Type.getDescriptor(java.lang.reflect.Type.class);
        private static final Type CONFIGURE_UTIL_TYPE = Type.getType(ConfigureUtil.class);
        private static final Type CLOSURE_TYPE = Type.getType(Closure.class);
        private static final Type SERVICE_REGISTRY_TYPE = Type.getType(ServiceRegistry.class);
        private static final String SERVICE_REGISTRY_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)SERVICE_REGISTRY_TYPE, (Type[])new Type[0]);
        private static final Type JAVA_LANG_REFLECT_TYPE = Type.getType(java.lang.reflect.Type.class);
        private static final Type OBJECT_TYPE = Type.getType(Object.class);
        private static final Type CLASS_TYPE = Type.getType(Class.class);
        private static final Type METHOD_TYPE = Type.getType(Method.class);
        private static final Type STRING_TYPE = Type.getType(String.class);
        private static final Type CLASS_ARRAY_TYPE = Type.getType(Class[].class);
        private static final Type GROOVY_SYSTEM_TYPE = Type.getType(GroovySystem.class);
        private static final Type META_CLASS_REGISTRY_TYPE = Type.getType(MetaClassRegistry.class);
        private static final Type BOOLEAN_TYPE = Type.getType(Boolean.TYPE);
        private static final Type OBJECT_ARRAY_TYPE = Type.getType(Object[].class);
        private static final Type ACTION_TYPE = Type.getType(Action.class);
        private static final Type WITH_SERVICE_REGISTRY = Type.getType(DependencyInjectingInstantiator.WithServiceRegistry.class);
        private static final Type PROPERTY_INTERNAL_TYPE = Type.getType(PropertyInternal.class);
        private static final String RETURN_VOID_FROM_OBJECT = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{OBJECT_TYPE});
        private static final String RETURN_VOID_FROM_OBJECT_CLASS_DYNAMIC_OBJECT = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{OBJECT_TYPE, CLASS_TYPE, DYNAMIC_OBJECT_TYPE});
        private static final String RETURN_CLASS = Type.getMethodDescriptor((Type)CLASS_TYPE, (Type[])new Type[0]);
        private static final String RETURN_VOID_FROM_CONVENTION_AWARE_CONVENTION = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{CONVENTION_AWARE_TYPE, CONVENTION_TYPE});
        private static final String RETURN_CONVENTION = Type.getMethodDescriptor((Type)CONVENTION_TYPE, (Type[])new Type[0]);
        private static final String RETURN_DYNAMIC_OBJECT = Type.getMethodDescriptor((Type)DYNAMIC_OBJECT_TYPE, (Type[])new Type[0]);
        private static final String RETURN_META_CLASS_FROM_CLASS = Type.getMethodDescriptor((Type)Type.getType(MetaClass.class), (Type[])new Type[]{CLASS_TYPE});
        private static final String RETURN_BOOLEAN_FROM_STRING = Type.getMethodDescriptor((Type)BOOLEAN_TYPE, (Type[])new Type[]{STRING_TYPE});
        private static final String RETURN_META_CLASS_REGISTRY = Type.getMethodDescriptor((Type)Type.getType(MetaClassRegistry.class), (Type[])new Type[0]);
        private static final String GET_DECLARED_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)METHOD_TYPE, (Type[])new Type[]{STRING_TYPE, CLASS_ARRAY_TYPE});
        private static final String GET_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{JAVA_LANG_REFLECT_TYPE});
        private static final String[] EMPTY_STRINGS = new String[0];
        private static final Type[] EMPTY_TYPES = new Type[0];
        private static final String SERVICES_FIELD = "_services";
        private final ClassWriter visitor;
        private final Class<T> type;
        private final Type generatedType;
        private final Type superclassType;
        private final Map<java.lang.reflect.Type, ReturnTypeEntry> genericReturnTypeConstantsIndex = Maps.newHashMap();
        private final AsmClassGenerator classGenerator;
        private boolean hasMappingField;
        private final boolean conventionAware;
        private final boolean extensible;
        private final boolean providesOwnDynamicObject;

        private ClassBuilderImpl(Class<T> type, AbstractClassGenerator.ClassMetaData classMetaData) {
            this.type = type;
            this.classGenerator = new AsmClassGenerator(type, "_Decorated");
            this.visitor = this.classGenerator.getVisitor();
            this.generatedType = this.classGenerator.getGeneratedType();
            this.superclassType = Type.getType(type);
            this.extensible = classMetaData.isExtensible();
            this.conventionAware = classMetaData.isConventionAware();
            this.providesOwnDynamicObject = classMetaData.providesDynamicObjectImplementation();
        }

        @Override
        public void startClass(boolean shouldImplementWithServices) {
            ArrayList<String> interfaceTypes = new ArrayList<String>();
            interfaceTypes.add(GENERATED_SUBCLASS_TYPE.getInternalName());
            if (this.conventionAware && this.extensible) {
                interfaceTypes.add(CONVENTION_AWARE_TYPE.getInternalName());
            }
            if (this.extensible) {
                interfaceTypes.add(EXTENSION_AWARE_TYPE.getInternalName());
                interfaceTypes.add(HAS_CONVENTION_TYPE.getInternalName());
            }
            if (shouldImplementWithServices) {
                interfaceTypes.add(WITH_SERVICE_REGISTRY.getInternalName());
            }
            interfaceTypes.add(DYNAMIC_OBJECT_AWARE_TYPE.getInternalName());
            interfaceTypes.add(GROOVY_OBJECT_TYPE.getInternalName());
            this.includeNotInheritedAnnotations();
            this.visitor.visit(49, 4097, this.generatedType.getInternalName(), null, this.superclassType.getInternalName(), interfaceTypes.toArray(EMPTY_STRINGS));
        }

        @Override
        public void addConstructor(Constructor<?> constructor) throws Exception {
            ArrayList<Type> paramTypes = new ArrayList<Type>();
            for (Class<?> paramType : constructor.getParameterTypes()) {
                paramTypes.add(Type.getType(paramType));
            }
            String methodDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])paramTypes.toArray(EMPTY_TYPES));
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, "<init>", methodDescriptor, AsmClassGeneratorUtils.signature(constructor), EMPTY_STRINGS);
            for (Annotation annotation : constructor.getDeclaredAnnotations()) {
                if (annotation.annotationType().getAnnotation(Inherited.class) != null) continue;
                Retention retention = annotation.annotationType().getAnnotation(Retention.class);
                AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotation(Type.getType(annotation.annotationType()).getDescriptor(), retention != null && retention.value() == RetentionPolicy.RUNTIME);
                annotationVisitor.visitEnd();
            }
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                methodVisitor.visitVarInsn(Type.getType(constructor.getParameterTypes()[i]).getOpcode(21), i + 1);
            }
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), "<init>", methodDescriptor, false);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void mixInDynamicAware() throws Exception {
            String fieldSignature = ABSTRACT_DYNAMIC_OBJECT_TYPE.getDescriptor();
            this.visitor.visitField(2, DYNAMIC_OBJECT_HELPER_FIELD, fieldSignature, null, null);
            final Method getAsDynamicObject = DynamicObjectAware.class.getDeclaredMethod("getAsDynamicObject", new Class[0]);
            if (this.extensible) {
                this.addGetter(HasConvention.class.getDeclaredMethod("getConvention", new Class[0]), new MethodCodeBody(){

                    public void add(MethodVisitor visitor) throws Exception {
                        visitor.visitVarInsn(25, 0);
                        visitor.visitMethodInsn(182, ClassBuilderImpl.this.generatedType.getInternalName(), "getAsDynamicObject", Type.getMethodDescriptor((Method)getAsDynamicObject), false);
                        visitor.visitTypeInsn(192, EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName());
                        visitor.visitMethodInsn(182, EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName(), "getConvention", RETURN_CONVENTION, false);
                    }
                });
                this.addGetter(ExtensionAware.class.getDeclaredMethod("getExtensions", new Class[0]), new MethodCodeBody(){

                    public void add(MethodVisitor visitor) throws Exception {
                        visitor.visitVarInsn(25, 0);
                        visitor.visitMethodInsn(182, ClassBuilderImpl.this.generatedType.getInternalName(), "getConvention", RETURN_CONVENTION, false);
                    }
                });
            }
            this.addLazyGetter(getAsDynamicObject, DYNAMIC_OBJECT_HELPER_FIELD, ABSTRACT_DYNAMIC_OBJECT_TYPE, new MethodCodeBody(){

                public void add(MethodVisitor visitor) {
                    ClassBuilderImpl.this.generateCreateDynamicObject(visitor);
                }
            });
        }

        private void generateCreateDynamicObject(MethodVisitor visitor) {
            if (this.extensible) {
                visitor.visitTypeInsn(187, EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName());
                visitor.visitInsn(89);
                visitor.visitVarInsn(25, 0);
                visitor.visitVarInsn(25, 0);
                visitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getClass", RETURN_CLASS, false);
                visitor.visitMethodInsn(182, CLASS_TYPE.getInternalName(), "getSuperclass", RETURN_CLASS, false);
                if (this.providesOwnDynamicObject) {
                    visitor.visitVarInsn(25, 0);
                    visitor.visitMethodInsn(183, Type.getType(this.type).getInternalName(), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT, false);
                } else {
                    visitor.visitInsn(1);
                }
                visitor.visitMethodInsn(183, EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName(), "<init>", RETURN_VOID_FROM_OBJECT_CLASS_DYNAMIC_OBJECT, false);
            } else {
                visitor.visitTypeInsn(187, NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName());
                visitor.visitInsn(89);
                visitor.visitVarInsn(25, 0);
                visitor.visitMethodInsn(183, NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName(), "<init>", RETURN_VOID_FROM_OBJECT, false);
            }
        }

        @Override
        public void mixInConventionAware() throws Exception {
            if (!this.extensible) {
                return;
            }
            this.visitor.visitField(2, MAPPING_FIELD, CONVENTION_MAPPING_FIELD_DESCRIPTOR, null, null);
            this.hasMappingField = true;
            MethodCodeBody initConventionAwareHelper = new MethodCodeBody(){

                public void add(MethodVisitor visitor) throws Exception {
                    visitor.visitTypeInsn(187, CONVENTION_AWARE_HELPER_TYPE.getInternalName());
                    visitor.visitInsn(89);
                    visitor.visitVarInsn(25, 0);
                    visitor.visitVarInsn(25, 0);
                    visitor.visitMethodInsn(182, ClassBuilderImpl.this.generatedType.getInternalName(), "getConvention", RETURN_CONVENTION, false);
                    visitor.visitMethodInsn(183, CONVENTION_AWARE_HELPER_TYPE.getInternalName(), "<init>", RETURN_VOID_FROM_CONVENTION_AWARE_CONVENTION, false);
                }
            };
            this.addLazyGetter(IConventionAware.class.getDeclaredMethod("getConventionMapping", new Class[0]), MAPPING_FIELD, CONVENTION_MAPPING_TYPE, initConventionAwareHelper);
        }

        @Override
        public void mixInGroovyObject() throws Exception {
            this.visitor.visitField(2, META_CLASS_FIELD, META_CLASS_TYPE_DESCRIPTOR, null, null);
            MethodCodeBody initMetaClass = new MethodCodeBody(){

                public void add(MethodVisitor visitor) throws Exception {
                    visitor.visitMethodInsn(184, GROOVY_SYSTEM_TYPE.getInternalName(), "getMetaClassRegistry", RETURN_META_CLASS_REGISTRY, false);
                    visitor.visitVarInsn(25, 0);
                    visitor.visitMethodInsn(182, OBJECT_TYPE.getInternalName(), "getClass", RETURN_CLASS, false);
                    visitor.visitMethodInsn(185, META_CLASS_REGISTRY_TYPE.getInternalName(), "getMetaClass", RETURN_META_CLASS_FROM_CLASS, true);
                }
            };
            this.addLazyGetter(GroovyObject.class.getDeclaredMethod("getMetaClass", new Class[0]), META_CLASS_FIELD, META_CLASS_TYPE, initMetaClass);
            this.addSetter(GroovyObject.class.getDeclaredMethod("setMetaClass", MetaClass.class), new MethodCodeBody(){

                public void add(MethodVisitor visitor) throws Exception {
                    visitor.visitVarInsn(25, 0);
                    visitor.visitVarInsn(25, 1);
                    visitor.visitFieldInsn(181, ClassBuilderImpl.this.generatedType.getInternalName(), ClassBuilderImpl.META_CLASS_FIELD, META_CLASS_TYPE_DESCRIPTOR);
                }
            });
        }

        private void addSetter(Method method, MethodCodeBody body) throws Exception {
            String methodDescriptor = Type.getMethodDescriptor((Method)method);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, method.getName(), methodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            body.add(methodVisitor);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addPropertySetters(AbstractClassGenerator.PropertyMetaData property, Method getter) throws Exception {
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, MetaProperty.getSetterName((String)property.getName()), RETURN_VOID_FROM_OBJECT, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), getter.getName(), Type.getMethodDescriptor((Method)getter), false);
            methodVisitor.visitTypeInsn(192, PROPERTY_INTERNAL_TYPE.getInternalName());
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(185, PROPERTY_INTERNAL_TYPE.getInternalName(), "setFromAnyValue", RETURN_VOID_FROM_OBJECT, true);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void addLazyGetter(Method method, final String fieldName, final Type fieldType, final MethodCodeBody initializer) throws Exception {
            String methodDescriptor = Type.getMethodDescriptor((Method)method);
            String methodName = method.getName();
            this.addGetter(methodName, methodDescriptor, new MethodCodeBody(){

                public void add(MethodVisitor visitor) throws Exception {
                    visitor.visitVarInsn(25, 0);
                    visitor.visitFieldInsn(180, ClassBuilderImpl.this.generatedType.getInternalName(), fieldName, fieldType.getDescriptor());
                    visitor.visitVarInsn(58, 1);
                    visitor.visitVarInsn(25, 1);
                    Label returnValue = new Label();
                    visitor.visitJumpInsn(199, returnValue);
                    initializer.add(visitor);
                    visitor.visitVarInsn(58, 1);
                    visitor.visitVarInsn(25, 0);
                    visitor.visitVarInsn(25, 1);
                    visitor.visitFieldInsn(181, ClassBuilderImpl.this.generatedType.getInternalName(), fieldName, fieldType.getDescriptor());
                    visitor.visitLabel(returnValue);
                    visitor.visitVarInsn(25, 1);
                }
            });
        }

        private void addGetter(Method method, MethodCodeBody body) throws Exception {
            String methodDescriptor = Type.getMethodDescriptor((Method)method);
            String methodName = method.getName();
            this.addGetter(methodName, methodDescriptor, body);
        }

        private void addGetter(String methodName, String methodDescriptor, MethodCodeBody body) throws Exception {
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, methodName, methodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            body.add(methodVisitor);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addDynamicMethods() throws Exception {
            this.addGetter(GroovyObject.class.getDeclaredMethod("getProperty", String.class), new MethodCodeBody(){

                public void add(MethodVisitor methodVisitor) throws Exception {
                    methodVisitor.visitVarInsn(25, 0);
                    String getAsDynamicObjectDesc = Type.getMethodDescriptor((Method)DynamicObjectAware.class.getDeclaredMethod("getAsDynamicObject", new Class[0]));
                    methodVisitor.visitMethodInsn(182, ClassBuilderImpl.this.generatedType.getInternalName(), "getAsDynamicObject", getAsDynamicObjectDesc, false);
                    methodVisitor.visitVarInsn(25, 1);
                    String getPropertyDesc = Type.getMethodDescriptor((Method)DynamicObject.class.getDeclaredMethod("getProperty", String.class));
                    methodVisitor.visitMethodInsn(185, DYNAMIC_OBJECT_TYPE.getInternalName(), "getProperty", getPropertyDesc, true);
                }
            });
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, "hasProperty", RETURN_BOOLEAN_FROM_STRING, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            String getAsDynamicObjectDesc = Type.getMethodDescriptor((Method)DynamicObjectAware.class.getDeclaredMethod("getAsDynamicObject", new Class[0]));
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getAsDynamicObject", getAsDynamicObjectDesc, false);
            methodVisitor.visitVarInsn(25, 1);
            String getPropertyDesc = Type.getMethodDescriptor((Method)PropertyAccess.class.getDeclaredMethod("hasProperty", String.class));
            methodVisitor.visitMethodInsn(185, DYNAMIC_OBJECT_TYPE.getInternalName(), "hasProperty", getPropertyDesc, true);
            methodVisitor.visitInsn(172);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            this.addSetter(GroovyObject.class.getDeclaredMethod("setProperty", String.class, Object.class), new MethodCodeBody(){

                public void add(MethodVisitor methodVisitor) throws Exception {
                    methodVisitor.visitVarInsn(25, 0);
                    String getAsDynamicObjectDesc = Type.getMethodDescriptor((Method)DynamicObjectAware.class.getDeclaredMethod("getAsDynamicObject", new Class[0]));
                    methodVisitor.visitMethodInsn(182, ClassBuilderImpl.this.generatedType.getInternalName(), "getAsDynamicObject", getAsDynamicObjectDesc, false);
                    methodVisitor.visitVarInsn(25, 1);
                    methodVisitor.visitVarInsn(25, 2);
                    String setPropertyDesc = Type.getMethodDescriptor((Method)DynamicObject.class.getDeclaredMethod("setProperty", String.class, Object.class));
                    methodVisitor.visitMethodInsn(185, DYNAMIC_OBJECT_TYPE.getInternalName(), "setProperty", setPropertyDesc, true);
                }
            });
            this.addGetter(GroovyObject.class.getDeclaredMethod("invokeMethod", String.class, Object.class), new MethodCodeBody(){

                public void add(MethodVisitor methodVisitor) throws Exception {
                    String invokeMethodDesc = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{STRING_TYPE, OBJECT_ARRAY_TYPE});
                    methodVisitor.visitVarInsn(25, 0);
                    String getAsDynamicObjectDesc = Type.getMethodDescriptor((Method)DynamicObjectAware.class.getDeclaredMethod("getAsDynamicObject", new Class[0]));
                    methodVisitor.visitMethodInsn(182, ClassBuilderImpl.this.generatedType.getInternalName(), "getAsDynamicObject", getAsDynamicObjectDesc, false);
                    methodVisitor.visitVarInsn(25, 1);
                    methodVisitor.visitVarInsn(25, 2);
                    methodVisitor.visitTypeInsn(193, OBJECT_ARRAY_TYPE.getDescriptor());
                    Label end = new Label();
                    Label notArray = new Label();
                    methodVisitor.visitJumpInsn(153, notArray);
                    methodVisitor.visitVarInsn(25, 2);
                    methodVisitor.visitTypeInsn(192, OBJECT_ARRAY_TYPE.getDescriptor());
                    methodVisitor.visitJumpInsn(167, end);
                    methodVisitor.visitLabel(notArray);
                    methodVisitor.visitInsn(4);
                    methodVisitor.visitTypeInsn(189, OBJECT_TYPE.getInternalName());
                    methodVisitor.visitInsn(89);
                    methodVisitor.visitInsn(3);
                    methodVisitor.visitVarInsn(25, 2);
                    methodVisitor.visitInsn(83);
                    methodVisitor.visitLabel(end);
                    methodVisitor.visitMethodInsn(185, DYNAMIC_OBJECT_TYPE.getInternalName(), "invokeMethod", invokeMethodDesc, true);
                }
            });
        }

        @Override
        public void addInjectorProperty(AbstractClassGenerator.PropertyMetaData property) {
            String flagName = this.propFieldName(property);
            this.visitor.visitField(2, flagName, Type.getDescriptor(property.getType()), null, null);
        }

        private void generateServicesField() {
            this.visitor.visitField(4098, SERVICES_FIELD, SERVICE_REGISTRY_TYPE.getDescriptor(), null, null);
        }

        private void generateGetServices() {
            MethodVisitor mv = this.visitor.visitMethod(4097, "getServices", SERVICE_REGISTRY_METHOD_DESCRIPTOR, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.generatedType.getInternalName(), SERVICES_FIELD, SERVICE_REGISTRY_TYPE.getDescriptor());
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void generateSetServices() {
            MethodVisitor mv = this.visitor.visitMethod(4097, "setServices", "(" + SERVICE_REGISTRY_TYPE.getDescriptor() + ")V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, this.generatedType.getInternalName(), SERVICES_FIELD, SERVICE_REGISTRY_TYPE.getDescriptor());
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetaData property, Method getter) throws Exception {
            String getterName = getter.getName();
            Type returnType = Type.getType(getter.getReturnType());
            String methodDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])new Type[0]);
            Type serviceType = Type.getType(property.getType());
            String propFieldName = this.propFieldName(property);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, getterName, methodDescriptor, AsmClassGeneratorUtils.signature(getter), EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), propFieldName, serviceType.getDescriptor());
            Label alreadyLoaded = new Label();
            methodVisitor.visitJumpInsn(199, alreadyLoaded);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getServices", SERVICE_REGISTRY_METHOD_DESCRIPTOR, false);
            java.lang.reflect.Type genericReturnType = getter.getGenericReturnType();
            if (genericReturnType instanceof Class) {
                methodVisitor.visitLdcInsn((Object)Type.getType((Class)((Class)genericReturnType)));
            } else {
                String constantFieldName = this.getConstantNameForGenericReturnType(genericReturnType, getterName);
                methodVisitor.visitFieldInsn(178, this.generatedType.getInternalName(), constantFieldName, JAVA_REFLECT_TYPE_DESCRIPTOR);
            }
            methodVisitor.visitMethodInsn(185, SERVICE_REGISTRY_TYPE.getInternalName(), "get", GET_METHOD_DESCRIPTOR, true);
            methodVisitor.visitTypeInsn(192, serviceType.getInternalName());
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), propFieldName, serviceType.getDescriptor());
            methodVisitor.visitLabel(alreadyLoaded);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), propFieldName, serviceType.getDescriptor());
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private String getConstantNameForGenericReturnType(java.lang.reflect.Type genericReturnType, String getterName) {
            ReturnTypeEntry entry = this.genericReturnTypeConstantsIndex.get(genericReturnType);
            if (entry == null) {
                String fieldName = "_GENERIC_RETURN_TYPE_" + this.genericReturnTypeConstantsIndex.size();
                entry = new ReturnTypeEntry(fieldName, getterName);
                this.genericReturnTypeConstantsIndex.put(genericReturnType, entry);
            }
            return entry.fieldName;
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetaData property, Method setter) throws Exception {
            String methodDescriptor = Type.getMethodDescriptor((Method)setter);
            Type serviceType = Type.getType(property.getType());
            String propFieldName = this.propFieldName(property);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, setter.getName(), methodDescriptor, AsmClassGeneratorUtils.signature(setter), EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), propFieldName, serviceType.getDescriptor());
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addConventionProperty(AbstractClassGenerator.PropertyMetaData property) throws Exception {
            String flagName = this.propFieldName(property);
            this.visitor.visitField(2, flagName, Type.BOOLEAN_TYPE.getDescriptor(), null, null);
        }

        private String propFieldName(AbstractClassGenerator.PropertyMetaData property) {
            return "__" + property.getName() + "__";
        }

        @Override
        public void applyConventionMappingToGetter(AbstractClassGenerator.PropertyMetaData property, Method getter) throws Exception {
            String flagName = this.propFieldName(property);
            String getterName = getter.getName();
            Type returnType = Type.getType(getter.getReturnType());
            String methodDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])new Type[0]);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, getterName, methodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            if (this.hasMappingField) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), MAPPING_FIELD, CONVENTION_MAPPING_FIELD_DESCRIPTOR);
                Label useConvention = new Label();
                methodVisitor.visitJumpInsn(199, useConvention);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), getterName, methodDescriptor, false);
                methodVisitor.visitInsn(returnType.getOpcode(172));
                methodVisitor.visitLabel(useConvention);
            }
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(185, CONVENTION_AWARE_TYPE.getInternalName(), "getConventionMapping", Type.getMethodDescriptor((Type)CONVENTION_MAPPING_TYPE, (Type[])new Type[0]), true);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), getterName, methodDescriptor, false);
            Type boxedType = null;
            if (getter.getReturnType().isPrimitive()) {
                boxedType = Type.getType(JavaReflectionUtil.getWrapperTypeForPrimitiveType(getter.getReturnType()));
                String valueOfMethodDescriptor = Type.getMethodDescriptor((Type)boxedType, (Type[])new Type[]{returnType});
                methodVisitor.visitMethodInsn(184, boxedType.getInternalName(), "valueOf", valueOfMethodDescriptor, false);
            }
            methodVisitor.visitLdcInsn((Object)property.getName());
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), flagName, Type.BOOLEAN_TYPE.getDescriptor());
            String getConventionValueDesc = Type.getMethodDescriptor((Method)ConventionMapping.class.getMethod("getConventionValue", Object.class, String.class, Boolean.TYPE));
            methodVisitor.visitMethodInsn(185, CONVENTION_MAPPING_TYPE.getInternalName(), "getConventionValue", getConventionValueDesc, true);
            if (getter.getReturnType().isPrimitive()) {
                methodVisitor.visitTypeInsn(192, boxedType.getInternalName());
                String valueMethodDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])new Type[0]);
                methodVisitor.visitMethodInsn(182, boxedType.getInternalName(), getter.getReturnType().getName() + "Value", valueMethodDescriptor, false);
            } else {
                methodVisitor.visitTypeInsn(192, getter.getReturnType().isArray() ? "[" + returnType.getElementType().getDescriptor() : returnType.getInternalName());
            }
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void applyConventionMappingToSetter(AbstractClassGenerator.PropertyMetaData property, Method setter) throws Exception {
            Type paramType = Type.getType(setter.getParameterTypes()[0]);
            Type returnType = Type.getType(setter.getReturnType());
            String setterDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])new Type[]{paramType});
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, setter.getName(), setterDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(paramType.getOpcode(21), 1);
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), setter.getName(), setterDescriptor, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitLdcInsn((Object)true);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), this.propFieldName(property), Type.BOOLEAN_TYPE.getDescriptor());
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addSetMethod(AbstractClassGenerator.PropertyMetaData property, Method setter) throws Exception {
            Type paramType = Type.getType(setter.getParameterTypes()[0]);
            Type returnType = Type.getType(setter.getReturnType());
            String setterDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])new Type[]{paramType});
            String setMethodDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{paramType});
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, property.getName(), setMethodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(paramType.getOpcode(21), 1);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), setter.getName(), setterDescriptor, false);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void applyConventionMappingToSetMethod(AbstractClassGenerator.PropertyMetaData property, Method method) throws Exception {
            Type paramType = Type.getType(method.getParameterTypes()[0]);
            Type returnType = Type.getType(method.getReturnType());
            String methodDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])new Type[]{paramType});
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, method.getName(), methodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(paramType.getOpcode(21), 1);
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), method.getName(), methodDescriptor, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitLdcInsn((Object)true);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), this.propFieldName(property), Type.BOOLEAN_TYPE.getDescriptor());
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addActionMethod(Method method) throws Exception {
            Type returnType = Type.getType(method.getReturnType());
            Type[] originalParameterTypes = CollectionUtils.collectArray(method.getParameterTypes(), Type.class, new Transformer<Type, Class>(){

                @Override
                public Type transform(Class clazz) {
                    return Type.getType((Class)clazz);
                }
            });
            int numParams = originalParameterTypes.length;
            Type[] closurisedParameterTypes = new Type[numParams];
            System.arraycopy(originalParameterTypes, 0, closurisedParameterTypes, 0, numParams);
            closurisedParameterTypes[numParams - 1] = CLOSURE_TYPE;
            String methodDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])closurisedParameterTypes);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, method.getName(), methodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            for (int stackVar = 1; stackVar < numParams; ++stackVar) {
                methodVisitor.visitVarInsn(closurisedParameterTypes[stackVar - 1].getOpcode(21), stackVar);
            }
            methodVisitor.visitVarInsn(25, numParams);
            methodDescriptor = Type.getMethodDescriptor((Type)ACTION_TYPE, (Type[])new Type[]{CLOSURE_TYPE});
            methodVisitor.visitMethodInsn(184, CONFIGURE_UTIL_TYPE.getInternalName(), "configureUsing", methodDescriptor, false);
            methodDescriptor = Type.getMethodDescriptor((Type)Type.getType(method.getReturnType()), (Type[])originalParameterTypes);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), method.getName(), methodDescriptor, false);
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void generateServiceRegistrySupportMethods() throws Exception {
            this.generateServicesField();
            this.generateGetServices();
            this.generateSetServices();
        }

        private void includeNotInheritedAnnotations() {
            for (Annotation annotation : this.type.getDeclaredAnnotations()) {
                if (annotation.annotationType().getAnnotation(Inherited.class) != null) continue;
                Retention retention = annotation.annotationType().getAnnotation(Retention.class);
                boolean visible = retention != null && retention.value() == RetentionPolicy.RUNTIME;
                AnnotationVisitor annotationVisitor = this.visitor.visitAnnotation(Type.getType(annotation.annotationType()).getDescriptor(), visible);
                this.visitAnnotationValues(annotation, annotationVisitor);
                annotationVisitor.visitEnd();
            }
        }

        private void visitAnnotationValues(Annotation annotation, AnnotationVisitor annotationVisitor) {
            for (Method method : annotation.annotationType().getDeclaredMethods()) {
                String name = method.getName();
                Class<?> returnType = method.getReturnType();
                if (returnType.isEnum()) {
                    annotationVisitor.visitEnum(name, Type.getType(returnType).getDescriptor(), this.getAnnotationParameterValue(annotation, method).toString());
                    continue;
                }
                if (returnType.isArray() && !PRIMITIVE_TYPES.contains(returnType.getComponentType())) {
                    AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
                    Object[] elements = (Object[])this.getAnnotationParameterValue(annotation, method);
                    this.visitArrayElements(arrayVisitor, returnType.getComponentType(), elements);
                    arrayVisitor.visitEnd();
                    continue;
                }
                if (returnType.equals(Class.class)) {
                    Class clazz = (Class)this.getAnnotationParameterValue(annotation, method);
                    annotationVisitor.visit(name, (Object)Type.getType((Class)clazz));
                    continue;
                }
                if (returnType.isAnnotation()) {
                    Annotation nestedAnnotation = (Annotation)this.getAnnotationParameterValue(annotation, method);
                    AnnotationVisitor nestedAnnotationVisitor = annotationVisitor.visitAnnotation(name, Type.getType(returnType).getDescriptor());
                    this.visitAnnotationValues(nestedAnnotation, nestedAnnotationVisitor);
                    nestedAnnotationVisitor.visitEnd();
                    continue;
                }
                annotationVisitor.visit(name, this.getAnnotationParameterValue(annotation, method));
            }
        }

        private void visitArrayElements(AnnotationVisitor arrayVisitor, Class arrayElementType, Object[] arrayElements) {
            if (arrayElementType.isEnum()) {
                String enumDescriptor = Type.getType((Class)arrayElementType).getDescriptor();
                for (Object value : arrayElements) {
                    arrayVisitor.visitEnum(null, enumDescriptor, value.toString());
                }
            } else if (arrayElementType.equals(Class.class)) {
                for (Object value : arrayElements) {
                    Class clazz = (Class)value;
                    arrayVisitor.visit(null, (Object)Type.getType((Class)clazz));
                }
            } else if (arrayElementType.isAnnotation()) {
                for (Object annotation : arrayElements) {
                    AnnotationVisitor nestedAnnotationVisitor = arrayVisitor.visitAnnotation(null, Type.getType((Class)arrayElementType).getDescriptor());
                    this.visitAnnotationValues((Annotation)annotation, nestedAnnotationVisitor);
                    nestedAnnotationVisitor.visitEnd();
                }
            } else {
                for (Object value : arrayElements) {
                    arrayVisitor.visit(null, value);
                }
            }
        }

        private Object getAnnotationParameterValue(Annotation annotation, Method method) {
            try {
                return method.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
            catch (InvocationTargetException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        @Override
        public Class<? extends T> generate() {
            this.writeGenericReturnTypeFields();
            this.visitor.visitEnd();
            return this.classGenerator.define().asSubclass(this.type);
        }

        private void writeGenericReturnTypeFields() {
            if (!this.genericReturnTypeConstantsIndex.isEmpty()) {
                MethodVisitor mv = this.visitor.visitMethod(8, "<clinit>", "()V", null, null);
                mv.visitCode();
                for (Map.Entry<java.lang.reflect.Type, ReturnTypeEntry> entry : this.genericReturnTypeConstantsIndex.entrySet()) {
                    ReturnTypeEntry returnType = entry.getValue();
                    this.visitor.visitField(4122, returnType.fieldName, JAVA_REFLECT_TYPE_DESCRIPTOR, null, null);
                    this.writeGenericReturnTypeFieldInitializer(mv, returnType);
                }
                mv.visitInsn(177);
                mv.visitMaxs(1, 1);
                mv.visitEnd();
            }
        }

        private void writeGenericReturnTypeFieldInitializer(MethodVisitor mv, ReturnTypeEntry returnType) {
            mv.visitLdcInsn((Object)this.generatedType);
            mv.visitLdcInsn((Object)returnType.getterName);
            mv.visitInsn(3);
            mv.visitTypeInsn(189, CLASS_TYPE.getInternalName());
            mv.visitMethodInsn(182, CLASS_TYPE.getInternalName(), "getDeclaredMethod", GET_DECLARED_METHOD_DESCRIPTOR, false);
            mv.visitMethodInsn(182, METHOD_TYPE.getInternalName(), "getGenericReturnType", Type.getMethodDescriptor((Type)JAVA_LANG_REFLECT_TYPE, (Type[])new Type[0]), false);
            mv.visitFieldInsn(179, this.generatedType.getInternalName(), returnType.fieldName, JAVA_REFLECT_TYPE_DESCRIPTOR);
        }

        private static final class ReturnTypeEntry {
            private final String fieldName;
            private final String getterName;

            private ReturnTypeEntry(String fieldName, String getterName) {
                this.fieldName = fieldName;
                this.getterName = getterName;
            }
        }
    }
}

