/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.file;

import java.io.File;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativePath
implements Serializable,
Comparable<RelativePath>,
CharSequence {
    public static final RelativePath EMPTY_ROOT = new RelativePath(false, new String[0]);
    private static final StringInterner PATH_SEGMENT_STRING_INTERNER = new StringInterner();
    private static final String FILE_PATH_SEPARATORS = File.separatorChar != '/' ? "/" + File.separator : File.separator;
    private final boolean endsWithFile;
    private final String[] segments;

    public RelativePath(boolean endsWithFile, String ... segments) {
        this(endsWithFile, (RelativePath)null, segments);
    }

    private RelativePath(boolean endsWithFile, RelativePath parentPath, String ... childSegments) {
        int targetOffsetForChildSegments;
        this.endsWithFile = endsWithFile;
        if (parentPath != null) {
            String[] sourceSegments = parentPath.getSegments();
            this.segments = new String[sourceSegments.length + childSegments.length];
            RelativePath.copySegments(this.segments, sourceSegments, sourceSegments.length);
            targetOffsetForChildSegments = sourceSegments.length;
        } else {
            this.segments = new String[childSegments.length];
            targetOffsetForChildSegments = 0;
        }
        RelativePath.copyAndInternSegments(this.segments, targetOffsetForChildSegments, childSegments);
    }

    private static void copySegments(String[] target, String[] source) {
        RelativePath.copySegments(target, source, target.length);
    }

    private static void copySegments(String[] target, String[] source, int length) {
        System.arraycopy(source, 0, target, 0, length);
    }

    private static void copyAndInternSegments(String[] target, int targetOffset, String[] source) {
        for (int i = 0; i < source.length; ++i) {
            target[targetOffset + i] = RelativePath.internPathSegment(source[i]);
        }
    }

    private static String internPathSegment(String sample) {
        return PATH_SEGMENT_STRING_INTERNER.intern(sample);
    }

    public String[] getSegments() {
        return this.segments;
    }

    public ListIterator<String> segmentIterator() {
        ArrayList<String> content = new ArrayList<String>(Arrays.asList(this.segments));
        return content.listIterator();
    }

    public boolean isFile() {
        return this.endsWithFile;
    }

    public String getPathString() {
        if (this.segments.length == 0) {
            return "";
        }
        StringBuilder path = new StringBuilder(256);
        int len = this.segments.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                path.append('/');
            }
            path.append(this.segments[i]);
        }
        return path.toString();
    }

    @Override
    public int length() {
        if (this.segments.length == 0) {
            return 0;
        }
        int length = this.segments.length - 1;
        for (String segment : this.segments) {
            length += segment.length();
        }
        return length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        int remaining = index;
        for (int nextSegment = 0; nextSegment < this.segments.length; ++nextSegment) {
            String segment = this.segments[nextSegment];
            int length = segment.length();
            if (remaining < length) {
                return segment.charAt(remaining);
            }
            if (remaining == length) {
                return '/';
            }
            remaining -= length + 1;
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return CharBuffer.wrap(this, start, end);
    }

    public File getFile(File baseDir) {
        return new File(baseDir, this.getPathString());
    }

    public String getLastName() {
        if (this.segments.length > 0) {
            return this.segments[this.segments.length - 1];
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelativePath that = (RelativePath)o;
        if (this.endsWithFile != that.endsWithFile) {
            return false;
        }
        return Arrays.equals(this.segments, that.segments);
    }

    public int hashCode() {
        int result = this.endsWithFile ? 1 : 0;
        result = 31 * result + Arrays.hashCode(this.segments);
        return result;
    }

    @Override
    public String toString() {
        return this.getPathString();
    }

    public RelativePath getParent() {
        switch (this.segments.length) {
            case 0: {
                return null;
            }
            case 1: {
                return EMPTY_ROOT;
            }
        }
        String[] parentSegments = new String[this.segments.length - 1];
        RelativePath.copySegments(parentSegments, this.segments);
        return new RelativePath(false, parentSegments);
    }

    public static RelativePath parse(boolean isFile, String path) {
        return RelativePath.parse(isFile, null, path);
    }

    public static RelativePath parse(boolean isFile, RelativePath parent, String path) {
        String[] names = StringUtils.split((String)path, (String)FILE_PATH_SEPARATORS);
        return new RelativePath(isFile, parent, names);
    }

    public RelativePath replaceLastName(String name) {
        String[] newSegments = new String[this.segments.length];
        RelativePath.copySegments(newSegments, this.segments, this.segments.length - 1);
        newSegments[this.segments.length - 1] = RelativePath.internPathSegment(name);
        return new RelativePath(this.endsWithFile, newSegments);
    }

    public RelativePath append(RelativePath other) {
        return new RelativePath(other.endsWithFile, this, other.segments);
    }

    public RelativePath plus(RelativePath other) {
        return this.append(other);
    }

    public RelativePath append(boolean endsWithFile, String ... segments) {
        return new RelativePath(endsWithFile, this, segments);
    }

    public RelativePath prepend(String ... segments) {
        return new RelativePath(false, segments).append(this);
    }

    @Override
    public int compareTo(RelativePath o) {
        int len1 = this.segments.length;
        int len2 = o.segments.length;
        if (len1 != len2) {
            return len1 - len2;
        }
        int lim = Math.min(len1, len2);
        String[] v1 = this.segments;
        String[] v2 = o.segments;
        for (int k = 0; k < lim; ++k) {
            int compareResult;
            String c1 = v1[k];
            String c2 = v2[k];
            int n = compareResult = c1 == c2 ? 0 : c1.compareTo(c2);
            if (compareResult == 0) continue;
            return compareResult;
        }
        return 0;
    }
}

