/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureStorage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.net.URI;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.capture.org.objectweb.asm.ClassReader;
import org.jetbrains.capture.org.objectweb.asm.ClassVisitor;
import org.jetbrains.capture.org.objectweb.asm.ClassWriter;
import org.jetbrains.capture.org.objectweb.asm.FieldVisitor;
import org.jetbrains.capture.org.objectweb.asm.Label;
import org.jetbrains.capture.org.objectweb.asm.MethodVisitor;
import org.jetbrains.capture.org.objectweb.asm.Type;

public class CaptureAgent {
    private static Instrumentation ourInstrumentation;
    private static boolean DEBUG;
    private static Map<String, List<InstrumentPoint>> myCapturePoints;
    private static final Map<String, List<InstrumentPoint>> myInsertPoints;
    static final KeyProvider THIS_KEY_PROVIDER;

    public static void premain(String args, Instrumentation instrumentation) {
        if (System.getProperty("intellij.debug.agent") != null) {
            System.err.println("Capture agent: more than one agent is not allowed, skipping");
            return;
        }
        System.setProperty("intellij.debug.agent", "true");
        ourInstrumentation = instrumentation;
        try {
            CaptureAgent.readSettings(args);
            instrumentation.addTransformer(new CaptureTransformer());
            CaptureAgent.setupJboss();
            if (DEBUG) {
                System.out.println("Capture agent: ready");
            }
        }
        catch (Throwable e) {
            System.out.println("Capture agent: unknown exception");
            e.printStackTrace();
        }
    }

    private static void setupJboss() {
        String modulesKey = "jboss.modules.system.pkgs";
        String property = System.getProperty(modulesKey, "");
        if (!property.isEmpty()) {
            property = property + ",";
        }
        property = property + "com.intellij.rt";
        System.setProperty(modulesKey, property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readSettings(String uri) {
        File file;
        Properties properties = new Properties();
        try {
            InputStreamReader reader = null;
            try {
                file = new File(new URI(uri));
                reader = new FileReader(file);
                properties.load(reader);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Capture agent: unable to read settings");
            e.printStackTrace();
            return;
        }
        DEBUG = Boolean.parseBoolean(properties.getProperty("debug", "false"));
        if (DEBUG) {
            CaptureStorage.setDebug((boolean)true);
        }
        if (Boolean.parseBoolean(properties.getProperty("disabled", "false"))) {
            CaptureStorage.setEnabled((boolean)false);
        }
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            if (propName.startsWith("capture")) {
                CaptureAgent.addPoint(true, properties.getProperty(propName));
                continue;
            }
            if (!propName.startsWith("insert")) continue;
            CaptureAgent.addPoint(false, properties.getProperty(propName));
        }
        if (Boolean.parseBoolean(properties.getProperty("deleteSettings", "true"))) {
            file.delete();
        }
    }

    private static <T> List<T> getNotNull(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    public static void setCapturePoints(Object[][] capturePoints) throws UnmodifiableClassException {
        HashSet<String> classNames = new HashSet<String>(myCapturePoints.keySet());
        HashMap<String, List<InstrumentPoint>> points = new HashMap<String, List<InstrumentPoint>>();
        for (Object[] capturePoint : capturePoints) {
            String className = (String)capturePoint[0];
            classNames.add(className);
            ArrayList currentPoints = (ArrayList)points.get(className);
            if (currentPoints != null) continue;
            currentPoints = new ArrayList();
            points.put(className, currentPoints);
        }
        myCapturePoints = points;
        ArrayList classes = new ArrayList(capturePoints.length);
        for (String name : classNames) {
            try {
                classes.add(Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        ourInstrumentation.retransformClasses(classes.toArray(new Class[0]));
    }

    private static void addPoint(boolean capture, String line) {
        String[] split = line.split(" ");
        KeyProvider keyProvider = CaptureAgent.createKeyProvider(Arrays.copyOfRange(split, 3, split.length));
        CaptureAgent.addCapturePoint(capture, split[0], split[1], split[2], keyProvider);
    }

    private static void addCapturePoint(boolean capture, String className, String methodName, String methodDesc, KeyProvider keyProvider) {
        Map<String, List<InstrumentPoint>> map = capture ? myCapturePoints : myInsertPoints;
        List<InstrumentPoint> points = map.get(className);
        if (points == null) {
            points = new ArrayList<InstrumentPoint>(1);
            map.put(className, points);
        }
        points.add(new InstrumentPoint(className, methodName, methodDesc, keyProvider));
    }

    private static KeyProvider createKeyProvider(String[] line) {
        if ("this".equals(line[0])) {
            return THIS_KEY_PROVIDER;
        }
        if (CaptureAgent.isNumber(line[0])) {
            try {
                return new ParamKeyProvider(Integer.parseInt(line[0]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new FieldKeyProvider(line[0], line[1]);
    }

    private static boolean isNumber(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        DEBUG = false;
        myCapturePoints = new HashMap<String, List<InstrumentPoint>>();
        myInsertPoints = new HashMap<String, List<InstrumentPoint>>();
        THIS_KEY_PROVIDER = new KeyProvider(){

            @Override
            public void loadKey(MethodVisitor mv, boolean isStatic, Type[] argumentTypes, String methodDisplayName, CaptureInstrumentor instrumentor) {
                if (isStatic) {
                    throw new IllegalStateException("This is not available in a static method " + methodDisplayName);
                }
                mv.visitVarInsn(25, 0);
            }
        };
    }

    private static class ParamKeyProvider
    implements KeyProvider {
        private final int myIdx;

        public ParamKeyProvider(int idx) {
            this.myIdx = idx;
        }

        @Override
        public void loadKey(MethodVisitor mv, boolean isStatic, Type[] argumentTypes, String methodDisplayName, CaptureInstrumentor instrumentor) {
            int index;
            int n = index = isStatic ? 0 : 1;
            if (this.myIdx >= argumentTypes.length) {
                throw new IllegalStateException("Argument with id " + this.myIdx + " is not available, method " + methodDisplayName + " has only " + argumentTypes.length);
            }
            int sort = argumentTypes[this.myIdx].getSort();
            if (sort != 10 && sort != 9) {
                throw new IllegalStateException("Argument with id " + this.myIdx + " in method " + methodDisplayName + " must be an object");
            }
            for (int i = 0; i < this.myIdx; ++i) {
                index += argumentTypes[i].getSize();
            }
            mv.visitVarInsn(25, index);
        }
    }

    private static class FieldKeyProvider
    implements KeyProvider {
        private final String myClassName;
        private final String myFieldName;

        public FieldKeyProvider(String className, String fieldName) {
            this.myClassName = className;
            this.myFieldName = fieldName;
        }

        @Override
        public void loadKey(MethodVisitor mv, boolean isStatic, Type[] argumentTypes, String methodDisplayName, CaptureInstrumentor instrumentor) {
            String desc = (String)instrumentor.myFields.get(this.myFieldName);
            if (desc == null) {
                throw new IllegalStateException("Field " + this.myFieldName + " was not found");
            }
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.myClassName, this.myFieldName, desc);
        }
    }

    private static interface KeyProvider {
        public void loadKey(MethodVisitor var1, boolean var2, Type[] var3, String var4, CaptureInstrumentor var5);
    }

    private static class InstrumentPoint {
        static final String ANY = "*";
        final String myClassName;
        final String myMethodName;
        final String myMethodDesc;
        final KeyProvider myKeyProvider;

        public InstrumentPoint(String className, String methodName, String methodDesc, KeyProvider keyProvider) {
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myMethodDesc = methodDesc;
            this.myKeyProvider = keyProvider;
        }

        boolean matchesMethod(String name, String desc) {
            if (!this.myMethodName.equals(name)) {
                return false;
            }
            return this.myMethodDesc.equals(ANY) || this.myMethodDesc.equals(desc);
        }
    }

    private static class CaptureInstrumentor
    extends ClassVisitor {
        private final List<InstrumentPoint> myCapturePoints;
        private final List<InstrumentPoint> myInsertPoints;
        private final Map<String, String> myFields = new HashMap<String, String>();
        private String mySuperName;

        public CaptureInstrumentor(int api, ClassVisitor cv, List<InstrumentPoint> capturePoints, List<InstrumentPoint> insertPoints) {
            super(api, cv);
            this.myCapturePoints = capturePoints;
            this.myInsertPoints = insertPoints;
        }

        private static String getNewName(String name) {
            return name + "$$$capture";
        }

        private static String getMethodDisplayName(String className, String methodName, String desc) {
            return className + "." + methodName + desc;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.mySuperName = superName;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.myFields.put(name, desc);
            return super.visitField(access, name, desc, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(final int access, String name, final String desc, String signature, String[] exceptions) {
            if ((access & 0x40) == 0) {
                for (final InstrumentPoint capturePoint : this.myCapturePoints) {
                    if (!capturePoint.matchesMethod(name, desc)) continue;
                    final String methodDisplayName = CaptureInstrumentor.getMethodDisplayName(capturePoint.myClassName, name, desc);
                    if (DEBUG) {
                        System.out.println("Capture agent: instrumented capture point at " + methodDisplayName);
                    }
                    if ("<init>".equals(name) && capturePoint.myKeyProvider == THIS_KEY_PROVIDER) {
                        return new MethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions)){
                            boolean captured;
                            {
                                super(x0, x1);
                                this.captured = false;
                            }

                            @Override
                            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                                super.visitMethodInsn(opcode, owner, name, desc, itf);
                                if (opcode == 183 && !this.captured && owner.equals(CaptureInstrumentor.this.mySuperName) && name.equals("<init>")) {
                                    CaptureInstrumentor.this.capture(this.mv, capturePoint.myKeyProvider, (access & 8) != 0, Type.getMethodType(desc).getArgumentTypes(), methodDisplayName);
                                    this.captured = true;
                                }
                            }
                        };
                    }
                    return new MethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions)){

                        @Override
                        public void visitCode() {
                            CaptureInstrumentor.this.capture(this.mv, capturePoint.myKeyProvider, (access & 8) != 0, Type.getMethodType(desc).getArgumentTypes(), methodDisplayName);
                            super.visitCode();
                        }
                    };
                }
                for (InstrumentPoint insertPoint : this.myInsertPoints) {
                    if (!insertPoint.matchesMethod(name, desc)) continue;
                    String methodDisplayName = CaptureInstrumentor.getMethodDisplayName(insertPoint.myClassName, name, desc);
                    if (DEBUG) {
                        System.out.println("Capture agent: instrumented insert point at " + methodDisplayName);
                    }
                    this.generateWrapper(access, name, desc, signature, exceptions, insertPoint, methodDisplayName);
                    return super.visitMethod(access, CaptureInstrumentor.getNewName(name), desc, signature, exceptions);
                }
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        private void generateWrapper(int access, String name, String desc, String signature, String[] exceptions, InstrumentPoint insertPoint, String methodDisplayName) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            Label start = new Label();
            mv.visitLabel(start);
            boolean isStatic = (access & 8) != 0;
            Type[] argumentTypes = Type.getMethodType(desc).getArgumentTypes();
            this.insertEnter(mv, insertPoint.myKeyProvider, isStatic, argumentTypes, methodDisplayName);
            mv.visitVarInsn(25, 0);
            int index = isStatic ? 0 : 1;
            for (Type t : argumentTypes) {
                mv.visitVarInsn(t.getOpcode(21), index);
                index += t.getSize();
            }
            mv.visitMethodInsn(isStatic ? 184 : 183, insertPoint.myClassName, CaptureInstrumentor.getNewName(insertPoint.myMethodName), desc, false);
            Label end = new Label();
            mv.visitLabel(end);
            this.insertExit(mv, insertPoint.myKeyProvider, isStatic, argumentTypes, methodDisplayName);
            mv.visitInsn(Type.getReturnType(desc).getOpcode(172));
            Label catchLabel = new Label();
            mv.visitLabel(catchLabel);
            mv.visitTryCatchBlock(start, end, catchLabel, null);
            this.insertExit(mv, insertPoint.myKeyProvider, isStatic, argumentTypes, methodDisplayName);
            mv.visitInsn(191);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void capture(MethodVisitor mv, KeyProvider keyProvider, boolean isStatic, Type[] argumentTypes, String methodDisplayName) {
            this.storageCall(mv, keyProvider, isStatic, argumentTypes, "capture", methodDisplayName);
        }

        private void insertEnter(MethodVisitor mv, KeyProvider keyProvider, boolean isStatic, Type[] argumentTypes, String methodDisplayName) {
            this.storageCall(mv, keyProvider, isStatic, argumentTypes, "insertEnter", methodDisplayName);
        }

        private void insertExit(MethodVisitor mv, KeyProvider keyProvider, boolean isStatic, Type[] argumentTypes, String methodDisplayName) {
            this.storageCall(mv, keyProvider, isStatic, argumentTypes, "insertExit", methodDisplayName);
        }

        private void storageCall(MethodVisitor mv, KeyProvider keyProvider, boolean isStatic, Type[] argumentTypes, String storageMethodName, String methodDisplayName) {
            keyProvider.loadKey(mv, isStatic, argumentTypes, methodDisplayName, this);
            mv.visitMethodInsn(184, CaptureStorage.class.getName().replaceAll("\\.", "/"), storageMethodName, "(Ljava/lang/Object;)V", false);
        }
    }

    private static class CaptureTransformer
    implements ClassFileTransformer {
        private CaptureTransformer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            if (className != null) {
                List capturePoints = CaptureAgent.getNotNull((List)myCapturePoints.get(className));
                List insertPoints = CaptureAgent.getNotNull((List)myInsertPoints.get(className));
                if (!capturePoints.isEmpty() || !insertPoints.isEmpty()) {
                    try {
                        ClassReader reader = new ClassReader(classfileBuffer);
                        ClassWriter writer = new ClassWriter(reader, 2);
                        reader.accept(new CaptureInstrumentor(393216, writer, capturePoints, insertPoints), 0);
                        byte[] bytes = writer.toByteArray();
                        if (DEBUG) {
                            try {
                                FileOutputStream stream = new FileOutputStream("instrumented_" + className.replaceAll("/", "_") + ".class");
                                try {
                                    stream.write(bytes);
                                }
                                finally {
                                    stream.close();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        return bytes;
                    }
                    catch (Exception e) {
                        System.out.println("Capture agent: failed to instrument " + className);
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }
    }
}

