/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.psi;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamApiUtil {
    private StreamApiUtil() {
    }

    public static boolean isStreamCall(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            StreamApiUtil.$$$reportNull$$$0(0);
        }
        return StreamApiUtil.isIntermediateStreamCall(expression) || StreamApiUtil.isProducerStreamCall(expression) || StreamApiUtil.isTerminationStreamCall(expression);
    }

    public static boolean isProducerStreamCall(@NotNull PsiMethodCallExpression expression) {
        PsiMethod method;
        if (expression == null) {
            StreamApiUtil.$$$reportNull$$$0(1);
        }
        return (method = expression.resolveMethod()) != null && method.hasModifierProperty("static") || StreamApiUtil.checkStreamCall(expression, false, true);
    }

    private static boolean isIntermediateStreamCall(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            StreamApiUtil.$$$reportNull$$$0(2);
        }
        return StreamApiUtil.checkStreamCall(expression, true, true);
    }

    public static boolean isTerminationStreamCall(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            StreamApiUtil.$$$reportNull$$$0(3);
        }
        return StreamApiUtil.checkStreamCall(expression, true, false);
    }

    private static boolean checkStreamCall(@NotNull PsiMethodCallExpression expression, boolean mustParentBeStream, boolean mustResultBeStream) {
        PsiElement methodClass;
        PsiMethod method;
        if (expression == null) {
            StreamApiUtil.$$$reportNull$$$0(4);
        }
        if ((method = expression.resolveMethod()) != null && mustResultBeStream == StreamApiUtil.isStreamType(expression.getType()) && (methodClass = method.getParent()) instanceof PsiClass) {
            return mustParentBeStream == StreamApiUtil.isStreamType((PsiClass)methodClass);
        }
        return false;
    }

    @Contract(value="null -> false")
    private static boolean isStreamType(@Nullable PsiType psiType) {
        return InheritanceUtil.isInheritor((PsiType)psiType, (String)"java.util.stream.BaseStream");
    }

    @Contract(value="null -> false")
    private static boolean isStreamType(@Nullable PsiClass psiClass) {
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.stream.BaseStream");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expression";
        objectArray2[1] = "com/intellij/debugger/streams/psi/StreamApiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isStreamCall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isProducerStreamCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isIntermediateStreamCall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isTerminationStreamCall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStreamCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

