/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuiteListener;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.coverage.SrcFileAnnotator;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewSuiteListener;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageDataManagerImpl
extends CoverageDataManager {
    private static final String REPLACE_ACTIVE_SUITES = "&Replace active suites";
    private static final String ADD_TO_ACTIVE_SUITES = "&Add to active suites";
    private static final String DO_NOT_APPLY_COLLECTED_COVERAGE = "Do not apply &collected coverage";
    private final List<CoverageSuiteListener> myListeners;
    private static final Logger LOG = Logger.getInstance(CoverageDataManagerImpl.class);
    @NonNls
    private static final String SUITE = "SUITE";
    private final Project myProject;
    private final Set<CoverageSuite> myCoverageSuites;
    private boolean myIsProjectClosing;
    private final Object myLock;
    private boolean mySubCoverageIsActive;
    private CoverageSuitesBundle myCurrentSuitesBundle;
    private final Object ANNOTATORS_LOCK;
    private final Map<Editor, SrcFileAnnotator> myAnnotators;

    @Override
    public CoverageSuitesBundle getCurrentSuitesBundle() {
        return this.myCurrentSuitesBundle;
    }

    public CoverageDataManagerImpl(@NotNull Project project) {
        if (project == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myCoverageSuites = new HashSet<CoverageSuite>();
        this.myIsProjectClosing = false;
        this.myLock = new Object();
        this.ANNOTATORS_LOCK = new Object();
        this.myAnnotators = new HashMap<Editor, SrcFileAnnotator>();
        this.myProject = project;
        project.getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                CoverageDataManagerImpl.this.chooseSuitesBundle(CoverageDataManagerImpl.this.myCurrentSuitesBundle);
            }
        });
        CoverageViewSuiteListener coverageViewListener = this.createCoverageViewListener();
        if (coverageViewListener != null) {
            this.addSuiteListener(coverageViewListener, (Disposable)this.myProject);
        }
    }

    @Nullable
    protected CoverageViewSuiteListener createCoverageViewListener() {
        return new CoverageViewSuiteListener(this, this.myProject);
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("CoverageDataManager" == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(1);
        }
        return "CoverageDataManager";
    }

    public void readExternal(Element element) throws InvalidDataException {
        for (Element suiteElement : element.getChildren(SUITE)) {
            CoverageRunner coverageRunner = BaseCoverageSuite.readRunnerAttribute(suiteElement);
            if (coverageRunner == null) {
                CoverageFileProvider fileProvider = BaseCoverageSuite.readDataFileProviderAttribute(suiteElement);
                if (!fileProvider.isValid()) continue;
                continue;
            }
            CoverageSuite suite = null;
            for (CoverageEngine engine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
                if (!coverageRunner.acceptsCoverageEngine(engine) || (suite = engine.createEmptyCoverageSuite(coverageRunner)) == null) continue;
                if (!(suite instanceof BaseCoverageSuite)) break;
                ((BaseCoverageSuite)suite).setProject(this.myProject);
                break;
            }
            if (suite == null) continue;
            try {
                suite.readExternal(suiteElement);
                this.myCoverageSuites.add(suite);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (CoverageSuite coverageSuite : this.myCoverageSuites) {
            Element suiteElement = new Element(SUITE);
            element.addContent(suiteElement);
            coverageSuite.writeExternal(suiteElement);
        }
    }

    @Override
    public CoverageSuite addCoverageSuite(String name, CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMergeWith, CoverageRunner coverageRunner, boolean collectLineInfo, boolean tracingEnabled) {
        CoverageSuite suite = this.createCoverageSuite(coverageRunner, name, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, collectLineInfo, tracingEnabled);
        if (suiteToMergeWith == null || !name.equals(suiteToMergeWith)) {
            this.removeCoverageSuite(suite);
        }
        this.myCoverageSuites.remove(suite);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public CoverageSuite addExternalCoverageSuite(String selectedFileName, long timeStamp, CoverageRunner coverageRunner, CoverageFileProvider fileProvider) {
        CoverageSuite suite = this.createCoverageSuite(coverageRunner, selectedFileName, fileProvider, ArrayUtil.EMPTY_STRING_ARRAY, timeStamp, null, false, false);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public CoverageSuite addCoverageSuite(CoverageEnabledConfiguration config) {
        String name = config.getName() + " Coverage Results";
        String covFilePath = config.getCoverageFilePath();
        assert (covFilePath != null);
        CoverageRunner coverageRunner = config.getCoverageRunner();
        LOG.assertTrue(coverageRunner != null, (Object)("Coverage runner id = " + config.getRunnerId()));
        DefaultCoverageFileProvider fileProvider = new DefaultCoverageFileProvider(new File(covFilePath));
        CoverageSuite suite = this.createCoverageSuite(config, name, coverageRunner, fileProvider);
        this.removeCoverageSuite(suite);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public void removeCoverageSuite(CoverageSuite suite) {
        String fileName = suite.getCoverageDataFileName();
        boolean deleteTraces = suite.isTracingEnabled();
        if (!FileUtil.isAncestor((String)PathManager.getSystemPath(), (String)fileName, (boolean)false)) {
            String message = "Would you like to delete file '" + fileName + "' ";
            if (deleteTraces) {
                message = message + "and traces directory '" + FileUtil.getNameWithoutExtension((File)new File(fileName)) + "' ";
            }
            if (Messages.showYesNoDialog((Project)this.myProject, (String)(message = message + "on disk?"), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) == 0) {
                this.deleteCachedCoverage(fileName, deleteTraces);
            }
        } else {
            this.deleteCachedCoverage(fileName, deleteTraces);
        }
        this.myCoverageSuites.remove(suite);
        if (this.myCurrentSuitesBundle != null && this.myCurrentSuitesBundle.contains(suite)) {
            Object[] suites = this.myCurrentSuitesBundle.getSuites();
            this.chooseSuitesBundle((suites = (CoverageSuite[])ArrayUtil.remove((Object[])suites, (Object)suite)).length > 0 ? new CoverageSuitesBundle((CoverageSuite[])suites) : null);
        }
    }

    private void deleteCachedCoverage(String coverageDataFileName, boolean deleteTraces) {
        FileUtil.delete((File)new File(coverageDataFileName));
        if (deleteTraces) {
            FileUtil.delete((File)this.getTracesDirectory(coverageDataFileName));
        }
    }

    @Override
    @NotNull
    public CoverageSuite[] getSuites() {
        CoverageSuite[] coverageSuiteArray = this.myCoverageSuites.toArray(new CoverageSuite[0]);
        if (coverageSuiteArray == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(2);
        }
        return coverageSuiteArray;
    }

    @Override
    public void chooseSuitesBundle(CoverageSuitesBundle suite) {
        if (this.myCurrentSuitesBundle == suite && suite == null) {
            return;
        }
        LOG.assertTrue(!this.myProject.isDefault());
        this.fireBeforeSuiteChosen();
        this.mySubCoverageIsActive = false;
        if (this.myCurrentSuitesBundle != null) {
            this.myCurrentSuitesBundle.getCoverageEngine().getCoverageAnnotator(this.myProject).onSuiteChosen(suite);
        }
        this.myCurrentSuitesBundle = suite;
        this.disposeAnnotators();
        if (suite == null) {
            this.triggerPresentationUpdate();
            return;
        }
        for (CoverageSuite coverageSuite : this.myCurrentSuitesBundle.getSuites()) {
            boolean suiteFileExists = coverageSuite.getCoverageDataFileProvider().ensureFileExists();
            if (suiteFileExists) continue;
            this.chooseSuitesBundle(null);
            return;
        }
        this.renewCoverageData(suite);
        this.fireAfterSuiteChosen();
    }

    @Override
    public void coverageGathered(@NotNull CoverageSuite suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (suite == null) {
                CoverageDataManagerImpl.$$$reportNull$$$0(12);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myCurrentSuitesBundle != null) {
                int answer;
                String[] stringArray;
                String message = CodeInsightBundle.message((String)"display.coverage.prompt", (Object[])new Object[]{suite.getPresentableName()});
                final CoverageOptionsProvider coverageOptionsProvider = CoverageOptionsProvider.getInstance(this.myProject);
                DialogWrapper.DoNotAskOption doNotAskOption = new DialogWrapper.DoNotAskOption(){

                    public boolean isToBeShown() {
                        return coverageOptionsProvider.getOptionToReplace() == 3;
                    }

                    public void setToBeShown(boolean value, int exitCode) {
                        coverageOptionsProvider.setOptionsToReplace(value ? 3 : exitCode);
                    }

                    public boolean canBeHidden() {
                        return true;
                    }

                    public boolean shouldSaveOptionsOnCancel() {
                        return true;
                    }

                    @NotNull
                    public String getDoNotShowMessage() {
                        String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                        if (string == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageDataManagerImpl$2", "getDoNotShowMessage"));
                    }
                };
                if (this.myCurrentSuitesBundle.getCoverageEngine() == suite.getCoverageEngine()) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = REPLACE_ACTIVE_SUITES;
                    stringArray2[1] = ADD_TO_ACTIVE_SUITES;
                    stringArray = stringArray2;
                    stringArray2[2] = DO_NOT_APPLY_COLLECTED_COVERAGE;
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = REPLACE_ACTIVE_SUITES;
                    stringArray = stringArray3;
                    stringArray3[1] = DO_NOT_APPLY_COLLECTED_COVERAGE;
                }
                String[] options = stringArray;
                int n = answer = doNotAskOption.isToBeShown() ? Messages.showDialog((String)message, (String)CodeInsightBundle.message((String)"code.coverage", (Object[])new Object[0]), (String[])options, (int)1, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption) : coverageOptionsProvider.getOptionToReplace();
                if (answer == 0) {
                    this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
                } else if (answer == 1) {
                    this.chooseSuitesBundle(new CoverageSuitesBundle((CoverageSuite[])ArrayUtil.append((Object[])this.myCurrentSuitesBundle.getSuites(), (Object)suite)));
                }
            } else {
                this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
            }
        });
    }

    @Override
    public void triggerPresentationUpdate() {
        this.renewInformationInEditors();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            ProjectView.getInstance((Project)this.myProject).refresh();
            CoverageViewManager.getInstance(this.myProject).setReady(true);
        });
    }

    @Override
    public void attachToProcess(@NotNull ProcessHandler handler, final @NotNull RunConfigurationBase configuration, final RunnerSettings runnerSettings) {
        if (handler == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(5);
        }
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                CoverageDataManagerImpl.this.processGatheredCoverage(configuration, runnerSettings);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/coverage/CoverageDataManagerImpl$3", "processTerminated"));
            }
        });
    }

    @Override
    public void processGatheredCoverage(@NotNull RunConfigurationBase configuration, RunnerSettings runnerSettings) {
        if (configuration == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(6);
        }
        if (runnerSettings instanceof CoverageRunnerData) {
            CoverageDataManagerImpl.processGatheredCoverage(configuration);
        }
    }

    public static void processGatheredCoverage(RunConfigurationBase configuration) {
        Project project = configuration.getProject();
        if (project.isDisposed()) {
            return;
        }
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(project);
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate(configuration);
        CoverageSuite coverageSuite = coverageEnabledConfiguration.getCurrentCoverageSuite();
        if (coverageSuite != null) {
            ((BaseCoverageSuite)coverageSuite).setConfiguration(configuration);
            coverageDataManager.coverageGathered(coverageSuite);
        }
    }

    protected void renewCoverageData(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(7);
        }
        if (this.myCurrentSuitesBundle != null) {
            this.myCurrentSuitesBundle.getCoverageEngine().getCoverageAnnotator(this.myProject).renewCoverageData(suite, this);
        }
    }

    private void renewInformationInEditors() {
        VirtualFile[] openFiles;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        for (VirtualFile openFile : openFiles = fileEditorManager.getOpenFiles()) {
            FileEditor[] allEditors = fileEditorManager.getAllEditors(openFile);
            this.applyInformationToEditor(allEditors, openFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyInformationToEditor(FileEditor[] editors, VirtualFile file) {
        PsiFile psiFile = (PsiFile)this.doInReadActionIfProjectOpen(() -> PsiManager.getInstance((Project)this.myProject).findFile(file));
        if (psiFile != null && this.myCurrentSuitesBundle != null && psiFile.isPhysical()) {
            SrcFileAnnotator annotator;
            Object object;
            Editor textEditor;
            CoverageEngine engine = this.myCurrentSuitesBundle.getCoverageEngine();
            if (!engine.coverageEditorHighlightingApplicableTo(psiFile)) {
                return;
            }
            for (FileEditor editor : editors) {
                if (!(editor instanceof TextEditor)) continue;
                textEditor = ((TextEditor)editor).getEditor();
                object = this.ANNOTATORS_LOCK;
                synchronized (object) {
                    annotator = this.myAnnotators.remove(textEditor);
                }
                if (annotator == null) break;
                Disposer.dispose((Disposable)annotator);
                break;
            }
            for (FileEditor editor : editors) {
                if (!(editor instanceof TextEditor)) continue;
                textEditor = ((TextEditor)editor).getEditor();
                annotator = this.getAnnotator(textEditor);
                if (annotator == null) {
                    annotator = new SrcFileAnnotator(psiFile, textEditor);
                    object = this.ANNOTATORS_LOCK;
                    synchronized (object) {
                        this.myAnnotators.put(textEditor, annotator);
                    }
                }
                if (this.myCurrentSuitesBundle == null || !engine.acceptedByFilters(psiFile, this.myCurrentSuitesBundle)) continue;
                annotator.showCoverageInformation(this.myCurrentSuitesBundle);
            }
        }
    }

    public void projectOpened() {
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new CoverageEditorFactoryListener(), (Disposable)this.myProject);
        this.myProject.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectClosing(Project project) {
                if (project != CoverageDataManagerImpl.this.myProject) {
                    return;
                }
                Object object = CoverageDataManagerImpl.this.myLock;
                synchronized (object) {
                    CoverageDataManagerImpl.this.myIsProjectClosing = true;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doInReadActionIfProjectOpen(Computable<T> computation) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIsProjectClosing) {
                return null;
            }
        }
        return (T)ApplicationManager.getApplication().runReadAction(computation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectSubCoverage(@NotNull CoverageSuitesBundle suite, List<String> testNames) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(8);
        }
        suite.restoreCoverageData();
        ProjectData data = suite.getCoverageData();
        if (data == null) {
            return;
        }
        this.mySubCoverageIsActive = true;
        HashMap executionTrace = new HashMap();
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            String fileName = coverageSuite.getCoverageDataFileName();
            File tracesDir = this.getTracesDirectory(fileName);
            for (String testName : testNames) {
                File file = new File(tracesDir, FileUtil.sanitizeFileName((String)testName) + ".tr");
                if (!file.exists()) continue;
                FilterInputStream in = null;
                try {
                    in = new DataInputStream(new FileInputStream(file));
                    int traceSize = ((DataInputStream)in).readInt();
                    for (int i = 0; i < traceSize; ++i) {
                        String className = ((DataInputStream)in).readUTF();
                        int linesSize = ((DataInputStream)in).readInt();
                        HashSet<Integer> lines = (HashSet<Integer>)executionTrace.get(className);
                        if (lines == null) {
                            lines = new HashSet<Integer>();
                            executionTrace.put(className, lines);
                        }
                        for (int l = 0; l < linesSize; ++l) {
                            lines.add(((DataInputStream)in).readInt());
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
        ProjectData projectData = new ProjectData();
        for (String className : executionTrace.keySet()) {
            ClassData loadedClassData = projectData.getClassData(className);
            if (loadedClassData == null) {
                loadedClassData = projectData.getOrCreateClassData(className);
            }
            Set lineNumbers = (Set)executionTrace.get(className);
            ClassData oldData = data.getClassData(className);
            LOG.assertTrue(oldData != null, (Object)("missed className: \"" + className + "\""));
            Object[] oldLines = oldData.getLines();
            LOG.assertTrue(oldLines != null);
            int maxNumber = oldLines.length;
            for (Integer lineNumber : lineNumbers) {
                if (lineNumber < maxNumber) continue;
                maxNumber = lineNumber + 1;
            }
            LineData[] lines = new LineData[maxNumber];
            for (Integer line : lineNumbers) {
                LineData oldLineData;
                int lineIdx = line - 1;
                String methodSig = null;
                if (lineIdx < oldData.getLines().length && (oldLineData = oldData.getLineData(lineIdx)) != null) {
                    methodSig = oldLineData.getMethodSignature();
                }
                LineData lineData = new LineData(lineIdx, methodSig);
                if (methodSig != null) {
                    loadedClassData.registerMethodSignature(lineData);
                }
                lineData.setStatus((byte)2);
                lines[lineIdx] = lineData;
            }
            loadedClassData.setLines(lines);
        }
        suite.setCoverageData(projectData);
        this.renewCoverageData(suite);
    }

    private File getTracesDirectory(String fileName) {
        return new File(new File(fileName).getParentFile(), FileUtil.getNameWithoutExtension((File)new File(fileName)));
    }

    @Override
    public void restoreMergedCoverage(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(9);
        }
        this.mySubCoverageIsActive = false;
        suite.restoreCoverageData();
        this.renewCoverageData(suite);
    }

    @Override
    public void addSuiteListener(final CoverageSuiteListener listener, Disposable parentDisposable) {
        this.myListeners.add(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                CoverageDataManagerImpl.this.myListeners.remove(listener);
            }
        });
    }

    public void fireBeforeSuiteChosen() {
        for (CoverageSuiteListener listener : this.myListeners) {
            listener.beforeSuiteChosen();
        }
    }

    public void fireAfterSuiteChosen() {
        for (CoverageSuiteListener listener : this.myListeners) {
            listener.afterSuiteChosen();
        }
    }

    @Override
    public boolean isSubCoverageActive() {
        return this.mySubCoverageIsActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SrcFileAnnotator getAnnotator(Editor editor) {
        Object object = this.ANNOTATORS_LOCK;
        synchronized (object) {
            return this.myAnnotators.get(editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAnnotators() {
        Object object = this.ANNOTATORS_LOCK;
        synchronized (object) {
            for (SrcFileAnnotator annotator : this.myAnnotators.values()) {
                if (annotator == null) continue;
                Disposer.dispose((Disposable)annotator);
            }
            this.myAnnotators.clear();
        }
    }

    @NotNull
    private CoverageSuite createCoverageSuite(CoverageEnabledConfiguration config, String name, CoverageRunner coverageRunner, DefaultCoverageFileProvider fileProvider) {
        CoverageEngine engine;
        CoverageSuite suite = null;
        CoverageEngine[] coverageEngineArray = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int n = coverageEngineArray.length;
        for (int i = 0; !(i >= n || coverageRunner.acceptsCoverageEngine(engine = coverageEngineArray[i]) && engine.isApplicableTo(config.getConfiguration()) && (suite = engine.createCoverageSuite(coverageRunner, name, fileProvider, config)) != null); ++i) {
        }
        LOG.assertTrue(suite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        CoverageSuite coverageSuite = suite;
        if (coverageSuite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(10);
        }
        return coverageSuite;
    }

    @NotNull
    private CoverageSuite createCoverageSuite(CoverageRunner coverageRunner, String name, CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMergeWith, boolean collectLineInfo, boolean tracingEnabled) {
        CoverageEngine engine;
        CoverageSuite suite = null;
        CoverageEngine[] coverageEngineArray = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int n = coverageEngineArray.length;
        for (int i = 0; !(i >= n || coverageRunner.acceptsCoverageEngine(engine = coverageEngineArray[i]) && (suite = engine.createCoverageSuite(coverageRunner, name, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, collectLineInfo, tracingEnabled, false, this.myProject)) != null); ++i) {
        }
        LOG.assertTrue(suite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        CoverageSuite coverageSuite = suite;
        if (coverageSuite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(11);
        }
        return coverageSuite;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageDataManagerImpl";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuites";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCoverageSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "coverageGathered";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processGatheredCoverage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "renewCoverageData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectSubCoverage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "restoreMergedCoverage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$coverageGathered$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CoverageEditorFactoryListener
    implements EditorFactoryListener {
        private final Alarm myAlarm;
        private final Map<Editor, Runnable> myCurrentEditors;

        private CoverageEditorFactoryListener() {
            this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)CoverageDataManagerImpl.this.myProject);
            this.myCurrentEditors = new HashMap<Editor, Runnable>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                CoverageEditorFactoryListener.$$$reportNull$$$0(0);
            }
            Object object = CoverageDataManagerImpl.this.myLock;
            synchronized (object) {
                if (CoverageDataManagerImpl.this.myIsProjectClosing) {
                    return;
                }
            }
            Editor editor = event.getEditor();
            if (editor.getProject() != CoverageDataManagerImpl.this.myProject) {
                return;
            }
            PsiFile psiFile = (PsiFile)ReadAction.compute(() -> {
                if (CoverageDataManagerImpl.this.myProject.isDisposed()) {
                    return null;
                }
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)CoverageDataManagerImpl.this.myProject);
                Document document = editor.getDocument();
                return documentManager.getPsiFile(document);
            });
            if (psiFile != null && CoverageDataManagerImpl.this.myCurrentSuitesBundle != null && psiFile.isPhysical()) {
                CoverageEngine engine = CoverageDataManagerImpl.this.myCurrentSuitesBundle.getCoverageEngine();
                if (!engine.coverageEditorHighlightingApplicableTo(psiFile)) {
                    return;
                }
                SrcFileAnnotator annotator = CoverageDataManagerImpl.this.getAnnotator(editor);
                if (annotator == null) {
                    annotator = new SrcFileAnnotator(psiFile, editor);
                }
                SrcFileAnnotator finalAnnotator = annotator;
                Object object2 = CoverageDataManagerImpl.this.ANNOTATORS_LOCK;
                synchronized (object2) {
                    CoverageDataManagerImpl.this.myAnnotators.put(editor, finalAnnotator);
                }
                Runnable request = () -> {
                    if (CoverageDataManagerImpl.this.myProject.isDisposed()) {
                        return;
                    }
                    if (CoverageDataManagerImpl.this.myCurrentSuitesBundle != null && engine.acceptedByFilters(psiFile, CoverageDataManagerImpl.this.myCurrentSuitesBundle)) {
                        finalAnnotator.showCoverageInformation(CoverageDataManagerImpl.this.myCurrentSuitesBundle);
                    }
                };
                this.myCurrentEditors.put(editor, request);
                this.myAlarm.addRequest(request, 100);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Editor editor;
            if (event == null) {
                CoverageEditorFactoryListener.$$$reportNull$$$0(1);
            }
            if ((editor = event.getEditor()).getProject() != CoverageDataManagerImpl.this.myProject) {
                return;
            }
            try {
                SrcFileAnnotator fileAnnotator;
                Object object = CoverageDataManagerImpl.this.ANNOTATORS_LOCK;
                synchronized (object) {
                    fileAnnotator = (SrcFileAnnotator)CoverageDataManagerImpl.this.myAnnotators.remove(editor);
                }
                if (fileAnnotator != null) {
                    Disposer.dispose((Disposable)fileAnnotator);
                }
            }
            finally {
                Runnable request = this.myCurrentEditors.remove(editor);
                if (request != null) {
                    this.myAlarm.cancelRequest(request);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl$CoverageEditorFactoryListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

