/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenMergingUpdateQueue
extends MergingUpdateQueue {
    private static final Logger LOG = Logger.getInstance(MavenMergingUpdateQueue.class);
    private final AtomicInteger mySuspendCounter = new AtomicInteger(0);

    public MavenMergingUpdateQueue(String name, int mergingTimeSpan, boolean isActive, Disposable parent) {
        this(name, mergingTimeSpan, isActive, ANY_COMPONENT, parent);
    }

    public MavenMergingUpdateQueue(String name, int mergingTimeSpan, boolean isActive, JComponent modalityStateComponent, Disposable parent) {
        super(name, mergingTimeSpan, isActive, modalityStateComponent, parent, null, false);
    }

    public void queue(@NotNull Update update) {
        if (update == null) {
            MavenMergingUpdateQueue.$$$reportNull$$$0(0);
        }
        boolean passThrough = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            passThrough = this.isPassThrough();
        } else if (MavenUtil.isNoBackgroundMode()) {
            passThrough = true;
        }
        if (passThrough) {
            update.run();
            return;
        }
        super.queue(update);
    }

    public void makeUserAware(Project project) {
        ApplicationManager.getApplication().runReadAction(() -> {
            EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
            multicaster.addCaretListener(new CaretListener(){

                public void caretPositionChanged(CaretEvent e) {
                    MavenMergingUpdateQueue.this.restartTimer();
                }
            }, (Disposable)this);
            multicaster.addDocumentListener(new DocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    MavenMergingUpdateQueue.this.restartTimer();
                }
            }, (Disposable)this);
            project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
                int beforeCalled;

                public void beforeRootsChange(ModuleRootEvent event) {
                    if (this.beforeCalled++ == 0) {
                        MavenMergingUpdateQueue.this.suspend();
                    }
                }

                public void rootsChanged(ModuleRootEvent event) {
                    if (this.beforeCalled == 0) {
                        return;
                    }
                    if (--this.beforeCalled == 0) {
                        MavenMergingUpdateQueue.this.resume();
                        MavenMergingUpdateQueue.this.restartTimer();
                    }
                }
            });
        });
    }

    public void makeDumbAware(Project project) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (DumbService.isDumb((Project)project)) {
                this.mySuspendCounter.incrementAndGet();
            }
            MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
            connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                    MavenMergingUpdateQueue.this.suspend();
                }

                public void exitDumbMode() {
                    MavenMergingUpdateQueue.this.resume();
                }
            });
            if (DumbService.getInstance((Project)project).isDumb()) {
                this.suspend();
            }
        });
    }

    public void makeModalAware(Project project) {
        MavenUtil.invokeLater(project, () -> {
            ModalityStateListener listener = new ModalityStateListener(){

                public void beforeModalityStateChanged(boolean entering) {
                    if (entering) {
                        MavenMergingUpdateQueue.this.suspend();
                    } else {
                        MavenMergingUpdateQueue.this.resume();
                    }
                }
            };
            LaterInvocator.addModalityStateListener((ModalityStateListener)listener, (Disposable)this);
            if (MavenUtil.isInModalContext()) {
                this.suspend();
            }
        });
    }

    public void suspend() {
        if (this.mySuspendCounter.incrementAndGet() == 1) {
            super.suspend();
        }
    }

    public void resume() {
        int c = this.mySuspendCounter.decrementAndGet();
        if (c <= 0) {
            if (c < 0) {
                this.mySuspendCounter.set(0);
                LOG.error("Invalid suspend counter state", (Throwable)new Exception());
            }
            super.resume();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "org/jetbrains/idea/maven/utils/MavenMergingUpdateQueue", "queue"));
    }
}

