/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.tasks.MavenKeymapExtension;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenShortcutsManager
extends MavenSimpleProjectComponent
implements Disposable,
BaseComponent {
    private static final String ACTION_ID_PREFIX = "Maven_";
    private final AtomicBoolean isInitialized = new AtomicBoolean();
    private final MavenProjectsManager myProjectsManager;
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    @NotNull
    public static MavenShortcutsManager getInstance(Project project) {
        MavenShortcutsManager mavenShortcutsManager = (MavenShortcutsManager)project.getComponent(MavenShortcutsManager.class);
        if (mavenShortcutsManager == null) {
            MavenShortcutsManager.$$$reportNull$$$0(0);
        }
        return mavenShortcutsManager;
    }

    public MavenShortcutsManager(Project project, MavenProjectsManager projectsManager, MavenRunner runner) {
        super(project);
        this.myProjectsManager = projectsManager;
    }

    public void dispose() {
    }

    public void initComponent() {
        if (!this.isNormalProject()) {
            return;
        }
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)((DumbAwareRunnable)() -> this.doInit()));
    }

    public void doInit() {
        if (this.isInitialized.getAndSet(true)) {
            return;
        }
        MyProjectsTreeListener listener = new MyProjectsTreeListener();
        this.myProjectsManager.addManagerListener(listener);
        this.myProjectsManager.addProjectsTreeListener(listener);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(KeymapManagerListener.TOPIC, (Object)new KeymapManagerListener(){
            {
                ApplicationManager.getApplication().getMessageBus().connect((Disposable)MavenShortcutsManager.this).subscribe(KeymapManagerListener.TOPIC, (Object)this);
            }

            public void activeKeymapChanged(Keymap keymap) {
                MavenShortcutsManager.this.fireShortcutsUpdated();
            }

            public void shortcutChanged(@NotNull Keymap keymap, @NotNull String actionId) {
                if (keymap == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (actionId == null) {
                    1.$$$reportNull$$$0(1);
                }
                MavenShortcutsManager.this.fireShortcutsUpdated();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "keymap";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "actionId";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/tasks/MavenShortcutsManager$1";
                objectArray[2] = "shortcutChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void disposeComponent() {
        if (!this.isInitialized.getAndSet(false)) {
            return;
        }
        MavenKeymapExtension.clearActions(this.myProject);
    }

    public String getActionId(@Nullable String projectPath, @Nullable String goal) {
        StringBuilder result = new StringBuilder(ACTION_ID_PREFIX);
        result.append(this.myProject.getLocationHash());
        if (projectPath != null) {
            String portablePath = FileUtil.toSystemIndependentName((String)projectPath);
            result.append(new File(portablePath).getParentFile().getName());
            result.append(Integer.toHexString(portablePath.hashCode()));
            if (goal != null) {
                result.append(goal);
            }
        }
        return result.toString();
    }

    public String getDescription(MavenProject project, String goal) {
        Shortcut[] shortcuts = this.getShortcuts(project, goal);
        if (shortcuts.length == 0) {
            return "";
        }
        return KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
    }

    public boolean hasShortcuts(MavenProject project, String goal) {
        return this.getShortcuts(project, goal).length > 0;
    }

    @NotNull
    private Shortcut[] getShortcuts(MavenProject project, String goal) {
        String actionId = this.getActionId(project.getPath(), goal);
        if (actionId == null) {
            if (Shortcut.EMPTY_ARRAY == null) {
                MavenShortcutsManager.$$$reportNull$$$0(1);
            }
            return Shortcut.EMPTY_ARRAY;
        }
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcutArray = activeKeymap.getShortcuts(actionId);
        if (shortcutArray == null) {
            MavenShortcutsManager.$$$reportNull$$$0(2);
        }
        return shortcutArray;
    }

    private void fireShortcutsUpdated() {
        for (Listener listener : this.myListeners) {
            listener.shortcutsUpdated();
        }
    }

    public void addListener(Listener listener) {
        this.myListeners.add(listener);
    }

    static /* synthetic */ Project access$200(MavenShortcutsManager x0) {
        return x0.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/maven/tasks/MavenShortcutsManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcuts";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MyProjectsTreeListener
    implements MavenProjectsManager.Listener,
    MavenProjectsTree.Listener {
        private final Map<MavenProject, Boolean> mySheduledProjects = new THashMap();
        private final MergingUpdateQueue myUpdateQueue = new MavenMergingUpdateQueue("MavenShortcutsManager: Keymap Update", 500, true, (Disposable)MavenShortcutsManager.access$200(MavenShortcutsManager.this));

        private MyProjectsTreeListener() {
        }

        @Override
        public void activated() {
            this.scheduleKeymapUpdate(MavenShortcutsManager.this.myProjectsManager.getNonIgnoredProjects(), true);
        }

        @Override
        public void projectsScheduled() {
        }

        @Override
        public void importAndResolveScheduled() {
        }

        @Override
        public void projectsIgnoredStateChanged(List<MavenProject> ignored, List<MavenProject> unignored, boolean fromImport) {
            this.scheduleKeymapUpdate(unignored, true);
            this.scheduleKeymapUpdate(ignored, false);
        }

        @Override
        public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted) {
            this.scheduleKeymapUpdate(MavenUtil.collectFirsts(updated), true);
            this.scheduleKeymapUpdate(deleted, false);
        }

        @Override
        public void projectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, NativeMavenProjectHolder nativeMavenProject) {
            this.scheduleKeymapUpdate(Collections.singletonList(projectWithChanges.first), true);
        }

        @Override
        public void pluginsResolved(MavenProject project) {
            this.scheduleKeymapUpdate(Collections.singletonList(project), true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleKeymapUpdate(List<MavenProject> mavenProjects, boolean forUpdate) {
            Map<MavenProject, Boolean> map = this.mySheduledProjects;
            synchronized (map) {
                for (MavenProject each : mavenProjects) {
                    this.mySheduledProjects.put(each, forUpdate);
                }
            }
            this.myUpdateQueue.queue(new Update(MavenShortcutsManager.this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    List projectToDelete;
                    List projectToUpdate;
                    Map map = MyProjectsTreeListener.this.mySheduledProjects;
                    synchronized (map) {
                        projectToUpdate = MyProjectsTreeListener.this.selectScheduledProjects(true);
                        projectToDelete = MyProjectsTreeListener.this.selectScheduledProjects(false);
                        MyProjectsTreeListener.this.mySheduledProjects.clear();
                    }
                    if (!MavenShortcutsManager.this.myProject.isDisposed()) {
                        MavenKeymapExtension.clearActions(MavenShortcutsManager.this.myProject, projectToDelete);
                        MavenKeymapExtension.updateActions(MavenShortcutsManager.this.myProject, projectToUpdate);
                    }
                }
            });
        }

        private List<MavenProject> selectScheduledProjects(boolean forUpdate) {
            return ContainerUtil.mapNotNull(this.mySheduledProjects.entrySet(), eachEntry -> forUpdate == (Boolean)eachEntry.getValue() ? (MavenProject)eachEntry.getKey() : null);
        }
    }

    public static interface Listener {
        public void shortcutsUpdated();
    }
}

