/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.plugins.api;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SingletonInstancesCache;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.plugins.api.MavenPluginDescriptor;
import org.jetbrains.idea.maven.plugins.api.MavenPropertiesGenerator;

public class MavenModelPropertiesPatcher {
    public static void patch(Properties modelProperties, @Nullable Collection<MavenPlugin> plugins) {
        if (plugins == null) {
            return;
        }
        Map<String, Map<String, Map<String, List<MavenPluginDescriptor>>>> map = MavenPluginDescriptor.getDescriptorsMap();
        for (MavenPlugin plugin : plugins) {
            Map<String, List<MavenPluginDescriptor>> goalsMap;
            Map<String, Map<String, List<MavenPluginDescriptor>>> groupMap = map.get(plugin.getArtifactId());
            if (groupMap == null || (goalsMap = groupMap.get(plugin.getGroupId())) == null) continue;
            MavenModelPropertiesPatcher.patch(modelProperties, goalsMap.get(null), null, plugin.getConfigurationElement(), plugin);
            for (MavenPlugin.Execution execution : plugin.getExecutions()) {
                for (String goal : execution.getGoals()) {
                    MavenModelPropertiesPatcher.patch(modelProperties, goalsMap.get(goal), goal, execution.getConfigurationElement(), plugin);
                }
            }
        }
    }

    private static void patch(Properties modelProperties, @Nullable List<MavenPluginDescriptor> descriptors, @Nullable String goal, Element cfgElement, MavenPlugin plugin) {
        if (descriptors == null) {
            return;
        }
        for (MavenPluginDescriptor descriptor : descriptors) {
            if (descriptor.properties != null) {
                for (MavenPluginDescriptor.ModelProperty property : descriptor.properties) {
                    if (property.insideConfigurationOnly || !StringUtil.isNotEmpty((String)property.name)) continue;
                    modelProperties.setProperty(property.name, StringUtil.notNullize((String)property.value));
                }
            }
            if (descriptor.propertyGenerator == null) continue;
            MavenPropertiesGenerator generator = (MavenPropertiesGenerator)SingletonInstancesCache.getInstance((String)descriptor.propertyGenerator, (ClassLoader)descriptor.getLoaderForClass());
            generator.generate(modelProperties, goal, plugin, cfgElement);
        }
    }
}

