/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution.build;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.JpsProjectTaskRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenConsoleImpl;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.TasksBundle;

public class MavenProjectTaskRunner
extends ProjectTaskRunner {
    private static final Pattern ERRORS_NUMBER_PATTERN = Pattern.compile("^\\[INFO] (\\d+) errors\\s*$");
    private static final Pattern WARNING_PATTERN = Pattern.compile("^\\[WARNING]");

    public void run(@NotNull Project project, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ProjectTask> tasks) {
        if (project == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(0);
        }
        if (context == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(1);
        }
        if (tasks == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(2);
        }
        Map taskMap = JpsProjectTaskRunner.groupBy(tasks);
        MavenProjectTaskRunner.buildModuleFiles(project, callback, MavenProjectTaskRunner.getFromGroupedMap(taskMap, ModuleFilesBuildTask.class, Collections.emptyList()));
        MavenProjectTaskRunner.buildModules(project, callback, MavenProjectTaskRunner.getFromGroupedMap(taskMap, ModuleBuildTask.class, Collections.emptyList()));
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        Module module;
        if (projectTask == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(3);
        }
        if (projectTask instanceof ModuleBuildTask && MavenRunner.getInstance((module = ((ModuleBuildTask)projectTask).getModule()).getProject()).getSettings().isDelegateBuildToMaven()) {
            return ExternalSystemModulePropertyManager.getInstance((Module)module).isMavenized();
        }
        return false;
    }

    private static <T extends ProjectTask> List<? extends T> getFromGroupedMap(Map<Class<? extends ProjectTask>, List<ProjectTask>> map, Class<T> key, List<? extends T> defaultValue) {
        List<ProjectTask> result = map.get(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    private static void buildModules(@NotNull Project project, final @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ModuleBuildTask> moduleBuildTasks) {
        if (project == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(4);
        }
        if (moduleBuildTasks == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(5);
        }
        if (moduleBuildTasks.isEmpty()) {
            return;
        }
        MavenRunner mavenRunner = MavenRunner.getInstance(project);
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project);
        MavenExplicitProfiles explicitProfiles = mavenProjectsManager.getExplicitProfiles();
        HashMap<MavenProject, List> rootProjectsToModules = new HashMap<MavenProject, List>();
        for (ModuleBuildTask moduleBuildTask : moduleBuildTasks) {
            MavenProject mavenProject = mavenProjectsManager.findProject(moduleBuildTask.getModule());
            if (mavenProject == null) continue;
            MavenProject rootProject = mavenProjectsManager.findRootProject(mavenProject);
            rootProjectsToModules.computeIfAbsent(rootProject, p -> new ArrayList()).add(mavenProject);
        }
        boolean clean = moduleBuildTasks.stream().anyMatch(task -> !(task instanceof ModuleFilesBuildTask) && !task.isIncrementalBuild());
        boolean bl = moduleBuildTasks.stream().anyMatch(ModuleBuildTask::isIncludeDependentModules);
        ArrayList<MavenRunnerParameters> commands = new ArrayList<MavenRunnerParameters>();
        for (Map.Entry entry : rootProjectsToModules.entrySet()) {
            ParametersList parameters = new ParametersList();
            if (clean) {
                parameters.add("clean");
            }
            parameters.add("install");
            List mavenProjects = (List)entry.getValue();
            if (!bl) {
                if (mavenProjects.size() > 1) {
                    parameters.add("--projects");
                    parameters.add(mavenProjects.stream().map(MavenProject::getMavenId).map(mavenId -> mavenId.getGroupId() + ":" + mavenId.getArtifactId()).collect(Collectors.joining(",")));
                } else {
                    parameters.add("--non-recursive");
                }
            }
            VirtualFile pomFile = (mavenProjects.size() > 1 ? (MavenProject)entry.getKey() : (MavenProject)mavenProjects.get(0)).getFile();
            commands.add(new MavenRunnerParameters(true, pomFile.getParent().getPath(), pomFile.getName(), parameters.getList(), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles()));
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project == null) {
                MavenProjectTaskRunner.$$$reportNull$$$0(8);
            }
            final AtomicInteger errors = new AtomicInteger();
            final AtomicInteger warnings = new AtomicInteger();
            final MavenConsoleImpl console = new MavenConsoleImpl("Maven Build", project){

                @Override
                public void attachToProcess(ProcessHandler processHandler) {
                    super.attachToProcess(processHandler);
                    processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                            Matcher warningMatcher;
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (outputType == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            String line = event.getText();
                            Matcher errorsMatcher = ERRORS_NUMBER_PATTERN.matcher(line);
                            if (errorsMatcher.matches()) {
                                try {
                                    errors.addAndGet(Integer.parseInt(errorsMatcher.group(1)));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if ((warningMatcher = WARNING_PATTERN.matcher(line)).find()) {
                                warnings.incrementAndGet();
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "outputType";
                                    break;
                                }
                            }
                            objectArray[1] = "org/jetbrains/idea/maven/execution/build/MavenProjectTaskRunner$1$1";
                            objectArray[2] = "onTextAvailable";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
            };
            FileDocumentManager.getInstance().saveAllDocuments();
            new Task.Backgroundable(project, TasksBundle.message("maven.tasks.executing", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    mavenRunner.runBatch(commands, null, null, TasksBundle.message("maven.tasks.executing", new Object[0]), indicator, console);
                }

                public boolean shouldStartInBackground() {
                    return mavenRunner.getSettings().isRunMavenInBackground();
                }

                public void processSentToBackground() {
                    mavenRunner.getSettings().setRunMavenInBackground(true);
                }

                public void onCancel() {
                    if (callback != null) {
                        callback.finished(new ProjectTaskResult(true, errors.get(), warnings.get()));
                    }
                }

                public void onSuccess() {
                    if (callback != null) {
                        callback.finished(new ProjectTaskResult(false, errors.get(), warnings.get()));
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    if (error == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (callback != null) {
                        callback.finished(new ProjectTaskResult(false, errors.get(), warnings.get()));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "error";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/idea/maven/execution/build/MavenProjectTaskRunner$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.queue();
        });
    }

    private static void buildModuleFiles(@NotNull Project project, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ModuleFilesBuildTask> moduleFilesBuildTasks) {
        if (project == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(6);
        }
        if (moduleFilesBuildTasks == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(7);
        }
        MavenProjectTaskRunner.buildModules(project, callback, moduleFilesBuildTasks);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleBuildTasks";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFilesBuildTasks";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/execution/build/MavenProjectTaskRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "buildModules";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "buildModuleFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$buildModules$3";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

