/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.openapi.externalSystem.service.ui.ExternalSystemJdkComboBox;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenPropertiesPanel;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenRunnerPanel {
    protected final Project myProject;
    private final boolean myRunConfigurationMode;
    private JCheckBox myDelegateBuildToMavenCheckbox;
    private JCheckBox myRunInBackgroundCheckbox;
    private RawCommandLineEditor myVMParametersEditor;
    private EnvironmentVariablesComponent myEnvVariablesComponent;
    private ExternalSystemJdkComboBox myJdkCombo;
    private JCheckBox mySkipTestsCheckBox;
    private MavenPropertiesPanel myPropertiesPanel;
    private Map<String, String> myProperties;

    public MavenRunnerPanel(@NotNull Project p, boolean isRunConfiguration) {
        if (p == null) {
            MavenRunnerPanel.$$$reportNull$$$0(0);
        }
        this.myProject = p;
        this.myRunConfigurationMode = isRunConfiguration;
    }

    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets.bottom = 5;
        this.myDelegateBuildToMavenCheckbox = new JCheckBox("Delegate IDE build actions to maven (experimental)");
        this.myDelegateBuildToMavenCheckbox.setMnemonic('d');
        this.myRunInBackgroundCheckbox = new JCheckBox("Run in background");
        this.myRunInBackgroundCheckbox.setMnemonic('b');
        if (!this.myRunConfigurationMode) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.gridwidth = 0;
            panel.add((Component)this.myDelegateBuildToMavenCheckbox, c);
            ++c.gridy;
            panel.add((Component)this.myRunInBackgroundCheckbox, c);
        }
        c.gridwidth = 1;
        JLabel labelVMParameters = new JLabel("VM Options:");
        labelVMParameters.setDisplayedMnemonic('v');
        this.myVMParametersEditor = new RawCommandLineEditor();
        labelVMParameters.setLabelFor((Component)this.myVMParametersEditor);
        this.myVMParametersEditor.setDialogCaption(labelVMParameters.getText());
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        panel.add((Component)labelVMParameters, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets.left = 10;
        panel.add((Component)this.myVMParametersEditor, c);
        c.insets.left = 0;
        JLabel jdkLabel = new JLabel("JRE:");
        jdkLabel.setDisplayedMnemonic('j');
        this.myJdkCombo = new ExternalSystemJdkComboBox(this.myProject);
        jdkLabel.setLabelFor((Component)this.myJdkCombo);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        panel.add((Component)jdkLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 0;
        c.insets.left = 10;
        panel.add((Component)this.myJdkCombo, c);
        c.insets.left = 0;
        c.fill = 2;
        this.myEnvVariablesComponent = new EnvironmentVariablesComponent();
        this.myEnvVariablesComponent.setPassParentEnvs(true);
        this.myEnvVariablesComponent.setLabelLocation("West");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 2;
        panel.add((Component)this.myEnvVariablesComponent, c);
        c.gridwidth = 1;
        JPanel propertiesPanel = new JPanel(new BorderLayout());
        propertiesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Properties", (boolean)false));
        this.mySkipTestsCheckBox = new JCheckBox("Skip tests");
        propertiesPanel.add((Component)this.mySkipTestsCheckBox, "North");
        this.mySkipTestsCheckBox.setMnemonic('t');
        this.collectProperties();
        this.myPropertiesPanel = new MavenPropertiesPanel(this.myProperties);
        propertiesPanel.add((Component)((Object)this.myPropertiesPanel), "Center");
        this.myPropertiesPanel.getEmptyText().setText("No properties defined");
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridheight = 0;
        c.gridwidth = 0;
        c.fill = 1;
        panel.add((Component)propertiesPanel, c);
        return panel;
    }

    private void collectProperties() {
        MavenProjectsManager s = MavenProjectsManager.getInstance(this.myProject);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (MavenProject each : s.getProjects()) {
            Properties properties = each.getProperties();
            result.putAll(properties);
        }
        this.myProperties = result;
    }

    protected void getData(MavenRunnerSettings data) {
        this.myDelegateBuildToMavenCheckbox.setSelected(data.isDelegateBuildToMaven());
        this.myRunInBackgroundCheckbox.setSelected(data.isRunMavenInBackground());
        this.myVMParametersEditor.setText(data.getVmOptions());
        this.mySkipTestsCheckBox.setSelected(data.isSkipTests());
        this.myJdkCombo.refreshData(data.getJreName());
        this.myPropertiesPanel.setDataFromMap(data.getMavenProperties());
        this.myEnvVariablesComponent.setEnvs(data.getEnvironmentProperties());
        this.myEnvVariablesComponent.setPassParentEnvs(data.isPassParentEnv());
    }

    protected void setData(MavenRunnerSettings data) {
        data.setDelegateBuildToMaven(this.myDelegateBuildToMavenCheckbox.isSelected());
        data.setRunMavenInBackground(this.myRunInBackgroundCheckbox.isSelected());
        data.setVmOptions(this.myVMParametersEditor.getText().trim());
        data.setSkipTests(this.mySkipTestsCheckBox.isSelected());
        data.setJreName(this.myJdkCombo.getSelectedValue());
        data.setMavenProperties(this.myPropertiesPanel.getDataAsMap());
        data.setEnvironmentProperties(this.myEnvVariablesComponent.getEnvs());
        data.setPassParentEnv(this.myEnvVariablesComponent.isPassParentEnvs());
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/idea/maven/execution/MavenRunnerPanel", "<init>"));
    }
}

