/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenResumeAction;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerParametersSettingEditor;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.MavenRunnerSettingsEditor;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenConsoleImpl;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettingsEditor;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;

public class MavenRunConfiguration
extends LocatableConfigurationBase
implements ModuleRunProfile {
    private MavenSettings mySettings;

    protected MavenRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
        this.mySettings = new MavenSettings(project);
    }

    public MavenRunConfiguration clone() {
        MavenRunConfiguration clone = (MavenRunConfiguration)super.clone();
        clone.mySettings = this.mySettings.clone();
        return clone;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(RunnerBundle.message("maven.runner.parameters.title", new Object[0]), (SettingsEditor)new MavenRunnerParametersSettingEditor(this.getProject()));
        group.addEditor(ProjectBundle.message("maven.tab.general", new Object[0]), (SettingsEditor)new MavenGeneralSettingsEditor(this.getProject()));
        group.addEditor(RunnerBundle.message("maven.tab.runner", new Object[0]), (SettingsEditor)new MavenRunnerSettingsEditor(this.getProject()));
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            MavenRunConfiguration.$$$reportNull$$$0(0);
        }
        return settingsEditorGroup;
    }

    public JavaParameters createJavaParameters(@Nullable Project project) throws ExecutionException {
        return MavenExternalParameters.createJavaParameters(project, this.mySettings.myRunnerParameters, this.mySettings.myGeneralSettings, this.mySettings.myRunnerSettings, this);
    }

    public RunProfileState getState(@NotNull Executor executor, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            MavenRunConfiguration.$$$reportNull$$$0(1);
        }
        if (env == null) {
            MavenRunConfiguration.$$$reportNull$$$0(2);
        }
        JavaCommandLineState state = new JavaCommandLineState(env){

            protected JavaParameters createJavaParameters() throws ExecutionException {
                return MavenRunConfiguration.this.createJavaParameters(env.getProject());
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (executor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (runner == null) {
                    1.$$$reportNull$$$0(1);
                }
                DefaultExecutionResult res = (DefaultExecutionResult)super.execute(executor, runner);
                if (executor.getId().equals(ToolWindowId.RUN) && MavenResumeAction.isApplicable(env.getProject(), this.getJavaParameters(), MavenRunConfiguration.this)) {
                    MavenResumeAction resumeAction = new MavenResumeAction(res.getProcessHandler(), runner, env);
                    res.setRestartActions(new AnAction[]{resumeAction});
                }
                DefaultExecutionResult defaultExecutionResult = res;
                if (defaultExecutionResult == null) {
                    1.$$$reportNull$$$0(2);
                }
                return defaultExecutionResult;
            }

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                OSProcessHandler result = super.startProcess();
                result.setShouldDestroyProcessRecursively(true);
                result.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        MavenRunConfiguration.this.updateProjectsFolders();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/maven/execution/MavenRunConfiguration$1$1", "processTerminated"));
                    }
                });
                OSProcessHandler oSProcessHandler = result;
                if (oSProcessHandler == null) {
                    1.$$$reportNull$$$0(3);
                }
                return oSProcessHandler;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runner";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "execute";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startProcess";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        state.setConsoleBuilder(MavenConsoleImpl.createConsoleBuilder(this.getProject()));
        return state;
    }

    private void updateProjectsFolders() {
        MavenProjectsManager.getInstance(this.getProject()).updateProjectTargetFolders();
    }

    @Nullable
    public MavenGeneralSettings getGeneralSettings() {
        return this.mySettings.myGeneralSettings;
    }

    public void setGeneralSettings(@Nullable MavenGeneralSettings settings) {
        this.mySettings.myGeneralSettings = settings;
    }

    @Nullable
    public MavenRunnerSettings getRunnerSettings() {
        return this.mySettings.myRunnerSettings;
    }

    public void setRunnerSettings(@Nullable MavenRunnerSettings settings) {
        this.mySettings.myRunnerSettings = settings;
    }

    public MavenRunnerParameters getRunnerParameters() {
        return this.mySettings.myRunnerParameters;
    }

    public void setRunnerParameters(MavenRunnerParameters p) {
        this.mySettings.myRunnerParameters = p;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            MavenRunConfiguration.$$$reportNull$$$0(3);
        }
        super.readExternal(element);
        Element mavenSettingsElement = element.getChild("MavenSettings");
        if (mavenSettingsElement != null) {
            this.mySettings = (MavenSettings)XmlSerializer.deserialize((Element)mavenSettingsElement, MavenSettings.class);
            if (this.mySettings.myRunnerParameters == null) {
                this.mySettings.myRunnerParameters = new MavenRunnerParameters();
            }
            this.mySettings.myRunnerParameters.fixAfterLoadingFromOldFormat();
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            MavenRunConfiguration.$$$reportNull$$$0(4);
        }
        super.writeExternal(element);
        element.addContent(XmlSerializer.serialize((Object)this.mySettings));
    }

    public String suggestedName() {
        return MavenRunConfigurationType.generateName(this.getProject(), this.mySettings.myRunnerParameters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MavenSettings
    implements Cloneable {
        public static final String TAG = "MavenSettings";
        public MavenGeneralSettings myGeneralSettings;
        public MavenRunnerSettings myRunnerSettings;
        public MavenRunnerParameters myRunnerParameters;

        public MavenSettings() {
        }

        public MavenSettings(Project project) {
            this(null, null, new MavenRunnerParameters());
        }

        private MavenSettings(@Nullable MavenGeneralSettings cs, @Nullable MavenRunnerSettings rs, MavenRunnerParameters rp) {
            this.myGeneralSettings = cs == null ? null : cs.clone();
            this.myRunnerSettings = rs == null ? null : rs.clone();
            this.myRunnerParameters = rp.clone();
        }

        protected MavenSettings clone() {
            return new MavenSettings(this.myGeneralSettings, this.myRunnerSettings, this.myRunnerParameters);
        }
    }
}

