/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.immutable;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightAnnotation;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u000e\u0010\n\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"GROOVY_TRANSFORM_IMMUTABLE_BASE", "", "GROOVY_TRANSFORM_IMMUTABLE_OPTIONS", "GROOVY_TRANSFORM_KNOWN_IMMUTABLE", "KNOWN_IMMUTABLES_OPTION", "KNOWN_IMMUTABLE_CLASSES_OPTION", "builtinImmutables", "", "getBuiltinImmutables", "()Ljava/util/Set;", "immutableCopyWith", "immutableCopyWithKind", "immutableOrigin", "collectImmutableAnnotations", "", "alias", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/annotation/GrAnnotation;", "list", "", "hasImmutableAnnotation", "", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "isImmutable", "field", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrField;", "intellij.groovy.psi"})
@JvmName(name="GrImmutableUtils")
public final class GrImmutableUtils {
    @NotNull
    private static final Set<String> builtinImmutables = SetsKt.setOf((Object[])new String[]{"java.lang.Class", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.math.BigInteger", "java.math.BigDecimal", "java.awt.Color", "java.net.URI", "java.util.UUID", "java.time.DayOfWeek", "java.time.Duration", "java.time.Instant", "java.time.LocalDate", "java.time.LocalDateTime", "java.time.LocalTime", "java.time.Month", "java.time.MonthDay", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.Period", "java.time.Year", "java.time.YearMonth", "java.time.ZonedDateTime", "java.time.ZoneOffset", "java.time.ZoneRegion", "java.time.chrono.ChronoLocalDate", "java.time.chrono.ChronoLocalDateTime", "java.time.chrono.Chronology", "java.time.chrono.ChronoPeriod", "java.time.chrono.ChronoZonedDateTime", "java.time.chrono.Era", "java.time.format.DecimalStyle", "java.time.format.FormatStyle", "java.time.format.ResolverStyle", "java.time.format.SignStyle", "java.time.format.TextStyle", "java.time.temporal.IsoFields", "java.time.temporal.JulianFields", "java.time.temporal.ValueRange", "java.time.temporal.WeekFields"});
    @NotNull
    public static final String immutableCopyWithKind = "@Immutable#copyWith";
    @NotNull
    public static final String immutableOrigin = "by @Immutable";
    @NotNull
    public static final String immutableCopyWith = "copyWith";
    @NotNull
    public static final String KNOWN_IMMUTABLES_OPTION = "knownImmutables";
    @NotNull
    public static final String KNOWN_IMMUTABLE_CLASSES_OPTION = "knownImmutableClasses";
    @NotNull
    public static final String GROOVY_TRANSFORM_IMMUTABLE_BASE = "groovy.transform.ImmutableBase";
    @NotNull
    public static final String GROOVY_TRANSFORM_IMMUTABLE_OPTIONS = "groovy.transform.ImmutableOptions";
    @NotNull
    public static final String GROOVY_TRANSFORM_KNOWN_IMMUTABLE = "groovy.transform.KnownImmutable";

    @NotNull
    public static final Set<String> getBuiltinImmutables() {
        return builtinImmutables;
    }

    public static final boolean hasImmutableAnnotation(@NotNull PsiModifierListOwner owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        return owner.hasAnnotation("groovy.lang.Immutable") || owner.hasAnnotation("groovy.transform.Immutable") || owner.hasAnnotation(GROOVY_TRANSFORM_IMMUTABLE_BASE);
    }

    public static final void collectImmutableAnnotations(@NotNull GrAnnotation alias, @NotNull List<GrAnnotation> list) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        PsiAnnotationOwner psiAnnotationOwner = alias.getOwner();
        if (psiAnnotationOwner == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationOwner, (String)"alias.owner ?: return");
        PsiAnnotationOwner owner = psiAnnotationOwner;
        list.add(new GrLightAnnotation(owner, alias, GROOVY_TRANSFORM_IMMUTABLE_BASE, MapsKt.emptyMap()));
        list.add(new GrLightAnnotation(owner, alias, GROOVY_TRANSFORM_IMMUTABLE_OPTIONS, MapsKt.emptyMap()));
        list.add(new GrLightAnnotation(owner, alias, GROOVY_TRANSFORM_KNOWN_IMMUTABLE, MapsKt.emptyMap()));
        list.add(new GrLightAnnotation(owner, alias, "groovy.transform.TupleConstructor", MapsKt.mapOf((Pair)TuplesKt.to((Object)"defaults", (Object)"false"))));
    }

    public static final boolean isImmutable(@NotNull GrField field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        PsiClass psiClass = field.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"field.containingClass ?: return false");
        PsiClass containingClass = psiClass;
        PsiType psiType = field.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"field.type");
        PsiType type = psiType;
        if (type instanceof PsiPrimitiveType) {
            return true;
        }
        if (type instanceof PsiArrayType) {
            return true;
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass psiClass2 = ((PsiClassType)type).resolve();
        if (psiClass2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass2, (String)"type.resolve() ?: return false");
        PsiClass psiClass3 = psiClass2;
        if (psiClass3.isEnum()) {
            return true;
        }
        if (CollectionsKt.contains((Iterable)builtinImmutables, (Object)psiClass3.getQualifiedName())) {
            return true;
        }
        if (InheritanceUtil.isInheritor((PsiClass)psiClass3, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiClass)psiClass3, (String)"java.util.Map") || InheritanceUtil.isInheritor((PsiClass)psiClass3, (String)"java.lang.Cloneable")) {
            return true;
        }
        PsiAnnotation psiAnnotation = containingClass.getAnnotation(GROOVY_TRANSFORM_IMMUTABLE_OPTIONS);
        if (psiAnnotation != null) {
            PsiAnnotation psiAnnotation2 = psiAnnotation;
            PsiAnnotation it = psiAnnotation2;
            List<String> immutableFields = GrAnnotationUtil.getStringArrayValue(it, KNOWN_IMMUTABLES_OPTION, true);
            if (immutableFields.contains(field.getName())) {
                return true;
            }
            List<PsiClass> immutableClasses = GrAnnotationUtil.getClassArrayValue(it, KNOWN_IMMUTABLE_CLASSES_OPTION, true);
            if (immutableClasses.contains(psiClass3)) {
                return true;
            }
        }
        if (GrImmutableUtils.hasImmutableAnnotation((PsiModifierListOwner)psiClass3)) {
            return true;
        }
        return psiClass3.hasAnnotation(GROOVY_TRANSFORM_KNOWN_IMMUTABLE);
    }
}

