/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter.java2groovy;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.ExpressionConverter;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import com.intellij.refactoring.introduceParameter.IntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.introduceParameter.IntroduceParameterUtil;
import com.intellij.refactoring.util.javadoc.MethodJavaDocHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GroovyIntroduceParameterUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.java2groovy.FieldConflictsResolver;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.java2groovy.OldReferencesResolver;

public class GroovyIntroduceParameterMethodUsagesProcessor
implements IntroduceParameterMethodUsagesProcessor {
    private static final Logger LOG = Logger.getInstance(GroovyIntroduceParameterMethodUsagesProcessor.class);

    private static boolean isGroovyUsage(UsageInfo usage) {
        PsiElement el = usage.getElement();
        return el != null && ((Object)((Object)GroovyLanguage.INSTANCE)).equals(el.getLanguage());
    }

    public boolean isMethodUsage(UsageInfo usage) {
        return GroovyRefactoringUtil.isMethodUsage(usage.getElement()) && GroovyIntroduceParameterMethodUsagesProcessor.isGroovyUsage(usage);
    }

    public void findConflicts(IntroduceParameterData data, UsageInfo[] usages, MultiMap<PsiElement, String> conflicts) {
    }

    public boolean processChangeMethodUsage(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        int lastNonVararg;
        PsiParameter[] parameters;
        GrCall callExpression = GroovyRefactoringUtil.getCallExpressionByMethodReference(usage.getElement());
        if (callExpression == null) {
            return true;
        }
        GrArgumentList argList = callExpression.getArgumentList();
        GrExpression[] oldArgs = argList.getExpressionArguments();
        GrExpression anchor = !data.getMethodToSearchFor().isVarArgs() ? GroovyIntroduceParameterMethodUsagesProcessor.getLast(oldArgs) : ((parameters = data.getMethodToSearchFor().getParameterList().getParameters()).length > oldArgs.length ? GroovyIntroduceParameterMethodUsagesProcessor.getLast(oldArgs) : ((lastNonVararg = parameters.length - 2) >= 0 ? oldArgs[lastNonVararg] : null));
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)argList, PsiMethod.class);
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature(callExpression);
        if (signature == null) {
            signature = GrClosureSignatureUtil.createSignature(data.getMethodToSearchFor(), PsiSubstitutor.EMPTY);
        }
        GrClosureSignatureUtil.ArgInfo<PsiElement>[] actualArgs = GrClosureSignatureUtil.mapParametersToArguments(signature, callExpression.getNamedArguments(), callExpression.getExpressionArguments(), callExpression.getClosureArguments(), callExpression, false, true);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(data.getProject());
        if (method != null && IntroduceParameterUtil.isMethodInUsages((IntroduceParameterData)data, (PsiMethod)method, (UsageInfo[])usages)) {
            argList.addAfter(factory.createExpressionFromText(data.getParameterName()), anchor);
        } else {
            PsiElement _expr = data.getParameterInitializer().getExpression();
            PsiElement initializer = ExpressionConverter.getExpression((PsiElement)_expr, (Language)GroovyLanguage.INSTANCE, (Project)data.getProject());
            LOG.assertTrue(initializer instanceof GrExpression);
            GrExpression newArg = GroovyIntroduceParameterUtil.addClosureToCall(initializer, argList);
            if (newArg == null) {
                PsiElement dummy = argList.addAfter(factory.createExpressionFromText("1"), anchor);
                newArg = ((GrExpression)dummy).replaceWithExpression((GrExpression)initializer, true);
            }
            PsiMethod methodToReplaceIn = data.getMethodToReplaceIn();
            new OldReferencesResolver(callExpression, newArg, (PsiElement)methodToReplaceIn, data.getReplaceFieldsWithGetters(), initializer, signature, actualArgs, methodToReplaceIn.getParameterList().getParameters()).resolve();
            ChangeContextUtil.clearContextInfo((PsiElement)initializer);
            if (newArg.isValid()) {
                JavaCodeStyleManager.getInstance((Project)newArg.getProject()).shortenClassReferences((PsiElement)newArg);
                CodeStyleManager.getInstance((Project)data.getProject()).reformat((PsiElement)newArg);
            }
        }
        if (actualArgs == null) {
            GroovyIntroduceParameterMethodUsagesProcessor.removeParamsFromUnresolvedCall(callExpression, data);
        } else {
            GroovyIntroduceParameterMethodUsagesProcessor.removeParametersFromCall(actualArgs, data.getParametersToRemove());
        }
        if (argList.getAllArguments().length == 0 && callExpression.hasClosureArguments()) {
            GrArgumentList emptyArgList = ((GrMethodCallExpression)factory.createExpressionFromText("foo{}")).getArgumentList();
            argList.replace(emptyArgList);
        }
        return false;
    }

    @Nullable
    private static GrExpression getLast(GrExpression[] oldArgs) {
        GrExpression anchor = oldArgs.length > 0 ? oldArgs[oldArgs.length - 1] : null;
        return anchor;
    }

    private static void removeParametersFromCall(GrClosureSignatureUtil.ArgInfo<PsiElement>[] actualArgs, TIntArrayList parametersToRemove) {
        parametersToRemove.forEach(paramNum -> {
            try {
                GrClosureSignatureUtil.ArgInfo actualArg = actualArgs[paramNum];
                if (actualArg == null) {
                    return true;
                }
                for (PsiElement arg : actualArg.args) {
                    arg.delete();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            return true;
        });
    }

    private static void removeParamsFromUnresolvedCall(GrCall callExpression, IntroduceParameterData data) {
        boolean hasNamedArgs;
        GrExpression[] arguments = callExpression.getExpressionArguments();
        GrClosableBlock[] closureArguments = callExpression.getClosureArguments();
        GrNamedArgument[] namedArguments = callExpression.getNamedArguments();
        if (namedArguments.length > 0) {
            PsiMethod method = data.getMethodToSearchFor();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length > 0) {
                PsiType type = parameters[0].getType();
                hasNamedArgs = InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map");
            } else {
                hasNamedArgs = false;
            }
        } else {
            hasNamedArgs = false;
        }
        data.getParametersToRemove().forEachDescending(paramNum -> {
            try {
                if (paramNum == 0 && hasNamedArgs) {
                    for (GrNamedArgument namedArgument : namedArguments) {
                        namedArgument.delete();
                    }
                } else {
                    if (hasNamedArgs) {
                        --paramNum;
                    }
                    if (paramNum < arguments.length) {
                        arguments[paramNum].delete();
                    } else if (paramNum < arguments.length + closureArguments.length) {
                        closureArguments[paramNum - arguments.length].delete();
                    }
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            return true;
        });
    }

    public boolean processChangeMethodSignature(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        if (!(usage.getElement() instanceof GrMethod) || !GroovyIntroduceParameterMethodUsagesProcessor.isGroovyUsage(usage)) {
            return true;
        }
        GrMethod method = (GrMethod)usage.getElement();
        FieldConflictsResolver fieldConflictsResolver = new FieldConflictsResolver(data.getParameterName(), method.getBlock());
        MethodJavaDocHelper javaDocHelper = new MethodJavaDocHelper((PsiMethod)method);
        PsiParameter[] parameters = method.getParameterList().getParameters();
        data.getParametersToRemove().forEachDescending(paramNum -> {
            try {
                PsiParameter param = parameters[paramNum];
                PsiDocTag tag = javaDocHelper.getTagForParameter(param);
                if (tag != null) {
                    tag.delete();
                }
                param.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            return true;
        });
        GroovyIntroduceParameterMethodUsagesProcessor.addParameter(method, javaDocHelper, data.getForcedType(), data.getParameterName(), data.isDeclareFinal(), data.getProject());
        fieldConflictsResolver.fix();
        return false;
    }

    @NotNull
    public static GrParameter addParameter(@NotNull GrParametersOwner parametersOwner, @Nullable MethodJavaDocHelper javaDocHelper, @NotNull PsiType forcedType, @NotNull String parameterName, boolean isFinal, @NotNull Project project) {
        if (parametersOwner == null) {
            GroovyIntroduceParameterMethodUsagesProcessor.$$$reportNull$$$0(0);
        }
        if (forcedType == null) {
            GroovyIntroduceParameterMethodUsagesProcessor.$$$reportNull$$$0(1);
        }
        if (parameterName == null) {
            GroovyIntroduceParameterMethodUsagesProcessor.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GroovyIntroduceParameterMethodUsagesProcessor.$$$reportNull$$$0(3);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        String typeText = forcedType.equalsToText("java.lang.Object") || forcedType == PsiType.NULL || PsiType.VOID.equals((Object)forcedType) ? null : forcedType.getCanonicalText();
        GrParameter parameter = factory.createParameter(parameterName, typeText, parametersOwner);
        parameter.getModifierList().setModifierProperty("final", isFinal);
        PsiParameter anchorParameter = GroovyIntroduceParameterMethodUsagesProcessor.getAnchorParameter(parametersOwner);
        GrParameterList parameterList = parametersOwner.getParameterList();
        parameter = (GrParameter)parameterList.addAfter(parameter, (PsiElement)anchorParameter);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)parameter);
        if (javaDocHelper != null) {
            PsiDocTag tagForAnchorParameter = javaDocHelper.getTagForParameter(anchorParameter);
            javaDocHelper.addParameterAfter(parameterName, tagForAnchorParameter);
        }
        GrParameter grParameter = parameter;
        if (grParameter == null) {
            GroovyIntroduceParameterMethodUsagesProcessor.$$$reportNull$$$0(4);
        }
        return grParameter;
    }

    @Nullable
    private static PsiParameter getAnchorParameter(GrParametersOwner parametersOwner) {
        GrParameterList parameterList = parametersOwner.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        int length = parameters.length;
        PsiParameter anchorParameter = !parametersOwner.isVarArgs() ? (length > 0 ? parameters[length - 1] : null) : (length > 1 ? parameters[length - 2] : null);
        return anchorParameter;
    }

    public boolean processAddDefaultConstructor(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) {
        if (!(usage.getElement() instanceof PsiClass) || !GroovyIntroduceParameterMethodUsagesProcessor.isGroovyUsage(usage)) {
            return true;
        }
        PsiClass aClass = (PsiClass)usage.getElement();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(data.getProject());
        GrMethod constructor = factory.createConstructorFromText(aClass.getName(), ArrayUtil.EMPTY_STRING_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, "{}");
        constructor = (GrMethod)aClass.add((PsiElement)constructor);
        constructor.getModifierList().setModifierProperty(VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList()), true);
        this.processAddSuperCall(data, new UsageInfo((PsiElement)constructor), usages);
        return false;
    }

    public boolean processAddSuperCall(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        if (!(usage.getElement() instanceof GrMethod) || !GroovyIntroduceParameterMethodUsagesProcessor.isGroovyUsage(usage)) {
            return true;
        }
        GrMethod constructor = (GrMethod)usage.getElement();
        if (!constructor.isConstructor()) {
            return true;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(data.getProject());
        GrConstructorInvocation superCall = factory.createConstructorInvocation("super();");
        GrOpenBlock body = constructor.getBlock();
        GrStatement[] statements = body.getStatements();
        superCall = statements.length > 0 ? (GrConstructorInvocation)body.addStatementBefore(superCall, statements[0]) : (GrConstructorInvocation)body.addStatementBefore(superCall, null);
        this.processChangeMethodUsage(data, new UsageInfo((PsiElement)superCall), usages);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forcedType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/java2groovy/GroovyIntroduceParameterMethodUsagesProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/java2groovy/GroovyIntroduceParameterMethodUsagesProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

