/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.noReturnMethod.MissingReturnInspection;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassItemGeneratorImpl;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.CodeBlockGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GeneratorClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;

public class ClosureGenerator {
    private static final Logger LOG = Logger.getInstance(ClosureGenerator.class);
    private final StringBuilder builder;
    private final ExpressionContext context;

    public ClosureGenerator(@NotNull StringBuilder builder, @NotNull ExpressionContext context) {
        if (builder == null) {
            ClosureGenerator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ClosureGenerator.$$$reportNull$$$0(1);
        }
        this.builder = builder;
        this.context = context;
    }

    public void generate(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            ClosureGenerator.$$$reportNull$$$0(2);
        }
        this.builder.append("new ");
        TypeWriter.writeTypeForNew(this.builder, closure.getType(), closure);
        this.builder.append('(');
        CharSequence owner = this.getOwner(closure);
        this.builder.append(owner);
        this.builder.append(", ");
        this.builder.append(owner);
        this.builder.append(") {\n");
        this.generateClosureMainMethod(closure);
        ClassItemGeneratorImpl generator = new ClassItemGeneratorImpl(this.context);
        GrMethod method = this.generateClosureMethod(closure);
        GrReflectedMethod[] reflectedMethods = method.getReflectedMethods();
        if (reflectedMethods.length > 0) {
            for (GrReflectedMethod reflectedMethod : reflectedMethods) {
                if (reflectedMethod.getSkippedParameters().length <= 0) continue;
                generator.writeMethod(this.builder, reflectedMethod);
                this.builder.append('\n');
            }
        }
        this.builder.append('}');
    }

    private void generateClosureMainMethod(@NotNull GrClosableBlock block) {
        if (block == null) {
            ClosureGenerator.$$$reportNull$$$0(3);
        }
        this.builder.append("public ");
        PsiType returnType = this.context.typeProvider.getReturnType(block);
        TypeWriter.writeType(this.builder, returnType, block);
        this.builder.append(" doCall");
        PsiParameter[] parameters = block.getAllParameters();
        GenerationUtil.writeParameterList(this.builder, parameters, new GeneratorClassNameProvider(), this.context);
        Set<GrStatement> myExitPoints = !PsiType.VOID.equals((Object)returnType) ? ControlFlowUtils.collectReturns(block) : Collections.emptySet();
        boolean shouldInsertReturnNull = !(returnType instanceof PsiPrimitiveType) && MissingReturnInspection.methodMissesSomeReturns(block, MissingReturnInspection.ReturnStatus.shouldNotReturnValue);
        new CodeBlockGenerator(this.builder, this.context.extend(), myExitPoints).generateCodeBlock((GrParameter[])parameters, block, shouldInsertReturnNull);
        this.builder.append('\n');
    }

    @NotNull
    private GrMethod generateClosureMethod(@NotNull GrClosableBlock block) {
        if (block == null) {
            ClosureGenerator.$$$reportNull$$$0(4);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.context.project);
        GrMethod method = factory.createMethodFromText("def doCall(){}", block);
        GrReferenceAdjuster.shortenAllReferencesIn(method.setReturnType(this.context.typeProvider.getReturnType(block)));
        if (block.hasParametersSection()) {
            method.getParameterList().replace(block.getParameterList());
        } else {
            GrParameter[] allParameters = block.getAllParameters();
            LOG.assertTrue(allParameters.length == 1);
            GrParameter itParameter = allParameters[0];
            GrParameter parameter = factory.createParameter("it", itParameter.getType().getCanonicalText(), "null", block, new String[0]);
            method.getParameterList().add(parameter);
        }
        ((GroovyFileImpl)method.getContainingFile()).setContextNullable(null);
        GrMethod grMethod = method;
        if (grMethod == null) {
            ClosureGenerator.$$$reportNull$$$0(5);
        }
        return grMethod;
    }

    @NonNls
    @NotNull
    private CharSequence getOwner(@NotNull GrClosableBlock closure) {
        GroovyPsiElement context;
        if (closure == null) {
            ClosureGenerator.$$$reportNull$$$0(6);
        }
        LOG.assertTrue((context = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)closure, (Class[])new Class[]{GrMember.class, GroovyFile.class})) != null);
        Object contextClass = context instanceof GroovyFile ? ((GroovyFile)context).getScriptClass() : (context instanceof PsiClass ? (PsiClass)context : (context instanceof GrMember ? (((GrMember)context).hasModifierProperty("static") ? null : ((GrMember)context).getContainingClass()) : null));
        if (contextClass == null) {
            if ("null" == null) {
                ClosureGenerator.$$$reportNull$$$0(7);
            }
            return "null";
        }
        PsiElement implicitClass = GenerationUtil.getWrappingImplicitClass(closure);
        if (implicitClass == null) {
            if ("this" == null) {
                ClosureGenerator.$$$reportNull$$$0(8);
            }
            return "this";
        }
        StringBuilder buffer = new StringBuilder();
        GenerationUtil.writeThisReference(contextClass, buffer, this.context);
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            ClosureGenerator.$$$reportNull$$$0(9);
        }
        return stringBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/ClosureGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/ClosureGenerator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateClosureMethod";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateClosureMainMethod";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateClosureMethod";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOwner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

