/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcRunConfigurationEditor;

public abstract class MvcRunConfiguration
extends ModuleBasedConfiguration<RunConfigurationModule>
implements CommonJavaRunConfigurationParameters {
    public String vmParams;
    public String cmdLine;
    public boolean depsClasspath = true;
    protected final MvcFramework myFramework;
    public final Map<String, String> envs = new HashMap<String, String>();
    public boolean passParentEnv = true;

    public MvcRunConfiguration(String name, RunConfigurationModule configurationModule, ConfigurationFactory factory, MvcFramework framework) {
        super(name, configurationModule, factory);
        this.myFramework = framework;
    }

    public MvcFramework getFramework() {
        return this.myFramework;
    }

    public String getVMParameters() {
        return this.vmParams;
    }

    public void setVMParameters(@Nullable String vmParams) {
        this.vmParams = vmParams;
    }

    public void setProgramParameters(@Nullable String value) {
        this.cmdLine = value;
    }

    @Nullable
    public String getProgramParameters() {
        return this.cmdLine;
    }

    public void setWorkingDirectory(@Nullable String value) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getWorkingDirectory() {
        return null;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            MvcRunConfiguration.$$$reportNull$$$0(0);
        }
        this.envs.clear();
        this.envs.putAll(envs);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map2 = this.envs;
        if (map2 == null) {
            MvcRunConfiguration.$$$reportNull$$$0(1);
        }
        return map2;
    }

    public void setPassParentEnvs(boolean passParentEnv) {
        this.passParentEnv = passParentEnv;
    }

    public boolean isPassParentEnvs() {
        return this.passParentEnv;
    }

    public boolean isAlternativeJrePathEnabled() {
        return false;
    }

    public void setAlternativeJrePathEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getAlternativeJrePath() {
        return null;
    }

    public void setAlternativeJrePath(String path) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getRunClass() {
        return null;
    }

    @Nullable
    public String getPackage() {
        return null;
    }

    public Collection<Module> getValidModules() {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        ArrayList<Module> res = new ArrayList<Module>();
        for (Module module : modules) {
            if (!this.isSupport(module)) continue;
            res.add(module);
        }
        return res;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            MvcRunConfiguration.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        this.vmParams = JDOMExternalizer.readString((Element)element, (String)"vmparams");
        this.cmdLine = JDOMExternalizer.readString((Element)element, (String)"cmdLine");
        String sPassParentEnviroment = JDOMExternalizer.readString((Element)element, (String)"passParentEnv");
        this.passParentEnv = StringUtil.isEmpty((String)sPassParentEnviroment) || Boolean.parseBoolean(sPassParentEnviroment);
        this.envs.clear();
        JDOMExternalizer.readMap((Element)element, this.envs, null, (String)"env");
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
        this.depsClasspath = !"false".equals(JDOMExternalizer.readString((Element)element, (String)"depsClasspath"));
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            MvcRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        JDOMExternalizer.write((Element)element, (String)"vmparams", (String)this.vmParams);
        JDOMExternalizer.write((Element)element, (String)"cmdLine", (String)this.cmdLine);
        JDOMExternalizer.write((Element)element, (String)"depsClasspath", (boolean)this.depsClasspath);
        JDOMExternalizer.writeMap((Element)element, this.envs, null, (String)"env");
        JDOMExternalizer.write((Element)element, (String)"passParentEnv", (boolean)this.passParentEnv);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
    }

    protected abstract String getNoSdkMessage();

    protected boolean isSupport(@NotNull Module module) {
        if (module == null) {
            MvcRunConfiguration.$$$reportNull$$$0(4);
        }
        return this.myFramework.getSdkRoot(module) != null && !this.myFramework.isAuxModule(module);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        Module module = this.getModule();
        if (module == null) {
            throw new RuntimeConfigurationException("Module not specified");
        }
        if (module.isDisposed()) {
            throw new RuntimeConfigurationException("Module is disposed");
        }
        if (!this.isSupport(module)) {
            throw new RuntimeConfigurationException(this.getNoSdkMessage());
        }
        super.checkConfiguration();
    }

    @Nullable
    public Module getModule() {
        return this.getConfigurationModule().getModule();
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        Module module;
        if (executor == null) {
            MvcRunConfiguration.$$$reportNull$$$0(5);
        }
        if (environment == null) {
            MvcRunConfiguration.$$$reportNull$$$0(6);
        }
        if ((module = this.getModule()) == null) {
            throw new ExecutionException("Module is not specified");
        }
        if (!this.isSupport(module)) {
            throw new ExecutionException(this.getNoSdkMessage());
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        Sdk sdk = rootManager.getSdk();
        if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) {
            throw CantRunException.noJdkForModule((Module)module);
        }
        return this.createCommandLineState(environment, module);
    }

    protected RunProfileState createCommandLineState(@NotNull ExecutionEnvironment environment, @NotNull Module module) {
        if (environment == null) {
            MvcRunConfiguration.$$$reportNull$$$0(7);
        }
        if (module == null) {
            MvcRunConfiguration.$$$reportNull$$$0(8);
        }
        return new MvcCommandLineState(environment, this.cmdLine, module, false);
    }

    @NotNull
    public SettingsEditor<? extends MvcRunConfiguration> getConfigurationEditor() {
        MvcRunConfigurationEditor mvcRunConfigurationEditor = new MvcRunConfigurationEditor();
        if (mvcRunConfigurationEditor == null) {
            MvcRunConfiguration.$$$reportNull$$$0(9);
        }
        return mvcRunConfigurationEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/mvc/MvcRunConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/MvcRunConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSupport";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLineState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MvcCommandLineState
    extends JavaCommandLineState {
        protected final boolean myForTests;
        protected String myCmdLine;
        @NotNull
        protected final Module myModule;

        public MvcCommandLineState(ExecutionEnvironment environment, @NotNull String cmdLine, Module module, boolean forTests) {
            if (environment == null) {
                MvcCommandLineState.$$$reportNull$$$0(0);
            }
            if (module == null) {
                MvcCommandLineState.$$$reportNull$$$0(1);
            }
            super(environment);
            this.myModule = module;
            this.myForTests = forTests;
            this.myCmdLine = cmdLine;
        }

        public String getCmdLine() {
            return this.myCmdLine;
        }

        public void setCmdLine(String cmdLine) {
            this.myCmdLine = cmdLine;
        }

        protected void addEnvVars(JavaParameters params) {
            HashMap<String, String> envVars = new HashMap<String, String>(MvcRunConfiguration.this.envs);
            envVars.putAll(params.getEnv());
            params.setupEnvs(envVars, MvcRunConfiguration.this.passParentEnv);
            MvcFramework.addJavaHome(params, this.myModule);
        }

        @NotNull
        protected OSProcessHandler startProcess() throws ExecutionException {
            OSProcessHandler handler = super.startProcess();
            handler.setShouldDestroyProcessRecursively(true);
            RunnerSettings runnerSettings = this.getRunnerSettings();
            JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)MvcRunConfiguration.this, (ProcessHandler)handler, runnerSettings);
            OSProcessHandler oSProcessHandler = handler;
            if (oSProcessHandler == null) {
                MvcCommandLineState.$$$reportNull$$$0(2);
            }
            return oSProcessHandler;
        }

        protected final JavaParameters createJavaParameters() throws ExecutionException {
            JavaParameters javaParameters = this.createJavaParametersMVC();
            for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions((ExtensionPointName)RunConfigurationExtension.EP_NAME)) {
                ext.updateJavaParameters((RunConfigurationBase)MvcRunConfiguration.this, javaParameters, this.getRunnerSettings());
            }
            return javaParameters;
        }

        protected JavaParameters createJavaParametersMVC() throws ExecutionException {
            MvcCommand cmd = MvcCommand.parse(this.myCmdLine).setVmOptions(MvcRunConfiguration.this.vmParams);
            JavaParameters params = MvcRunConfiguration.this.myFramework.createJavaParameters(this.myModule, false, this.myForTests, MvcRunConfiguration.this.depsClasspath, cmd);
            this.addEnvVars(params);
            return params;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/mvc/MvcRunConfiguration$MvcCommandLineState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/MvcRunConfiguration$MvcCommandLineState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startProcess";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

