/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/DefaultListOrMapTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/typing/GrTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/GrListOrMap;", "()V", "getListTypeFromDiamond", "Lcom/intellij/psi/PsiType;", "expression", "getMapTypeFromDiamond", "getTupleType", "getType", "intellij.groovy.psi"})
public final class DefaultListOrMapTypeCalculator
implements GrTypeCalculator<GrListOrMap> {
    @Override
    @Nullable
    public PsiType getType(@NotNull GrListOrMap expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        if (expression.isMap()) {
            PsiType psiType = this.getMapTypeFromDiamond(expression);
            if (psiType == null) {
                psiType = (PsiType)GrMapType.createFromNamedArgs(expression, expression.getNamedArguments());
            }
            return psiType;
        }
        PsiType psiType = this.getListTypeFromDiamond(expression);
        if (psiType == null) {
            psiType = this.getTupleType(expression);
        }
        return psiType;
    }

    private final PsiType getMapTypeFromDiamond(GrListOrMap expression) {
        GrNamedArgument[] namedArgs;
        GrNamedArgument[] grNamedArgumentArray;
        GrNamedArgument[] grNamedArgumentArray2 = expression.getNamedArguments();
        Intrinsics.checkExpressionValueIsNotNull((Object)grNamedArgumentArray2, (String)"expression.namedArguments");
        GrNamedArgument[] grNamedArgumentArray3 = grNamedArgumentArray = (namedArgs = grNamedArgumentArray2);
        if (!(grNamedArgumentArray3.length == 0)) {
            return null;
        }
        PsiType psiType = PsiImplUtil.inferExpectedTypeForDiamond(expression);
        if (psiType == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"PsiImplUtil.inferExpecte\u2026xpression) ?: return null");
        PsiType lType = psiType;
        if (!(lType instanceof PsiClassType) || !InheritanceUtil.isInheritor((PsiType)lType, (String)"java.util.Map")) {
            return null;
        }
        GlobalSearchScope globalSearchScope = expression.getResolveScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"expression.resolveScope");
        GlobalSearchScope scope = globalSearchScope;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression.getProject());
        PsiClass psiClass = facade.findClass("java.util.LinkedHashMap", scope);
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"facade.findClass(GroovyC\u2026AP, scope) ?: return null");
        PsiClass hashMap = psiClass;
        JavaPsiFacade javaPsiFacade = facade;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaPsiFacade, (String)"facade");
        return (PsiType)javaPsiFacade.getElementFactory().createType(hashMap, new PsiType[]{PsiUtil.substituteTypeParameter((PsiType)lType, (String)"java.util.Map", (int)0, (boolean)false), PsiUtil.substituteTypeParameter((PsiType)lType, (String)"java.util.Map", (int)1, (boolean)false)});
    }

    private final PsiType getListTypeFromDiamond(GrListOrMap expression) {
        GrExpression[] initializers;
        GrExpression[] grExpressionArray;
        GrExpression[] grExpressionArray2 = expression.getInitializers();
        Intrinsics.checkExpressionValueIsNotNull((Object)grExpressionArray2, (String)"expression.initializers");
        GrExpression[] grExpressionArray3 = grExpressionArray = (initializers = grExpressionArray2);
        if (!(grExpressionArray3.length == 0)) {
            return null;
        }
        PsiType lType = PsiImplUtil.inferExpectedTypeForDiamond(expression);
        if (!(lType instanceof PsiClassType)) {
            return null;
        }
        GlobalSearchScope globalSearchScope = expression.getResolveScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"expression.resolveScope");
        GlobalSearchScope scope = globalSearchScope;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression.getProject());
        if (InheritanceUtil.isInheritor((PsiType)lType, (String)"java.util.List")) {
            PsiClass psiClass = facade.findClass("java.util.ArrayList", scope);
            if (psiClass == null) {
                psiClass = facade.findClass("java.util.List", scope);
            }
            if (psiClass == null) {
                return null;
            }
            PsiClass arrayList = psiClass;
            JavaPsiFacade javaPsiFacade = facade;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaPsiFacade, (String)"facade");
            return (PsiType)javaPsiFacade.getElementFactory().createType(arrayList, PsiUtil.substituteTypeParameter((PsiType)lType, (String)"java.util.List", (int)0, (boolean)false));
        }
        if (InheritanceUtil.isInheritor((PsiType)lType, (String)"java.util.Set")) {
            PsiClass psiClass = facade.findClass("java.util.LinkedHashSet", scope);
            if (psiClass == null) {
                psiClass = facade.findClass("java.util.Set", scope);
            }
            if (psiClass == null) {
                return null;
            }
            PsiClass set = psiClass;
            JavaPsiFacade javaPsiFacade = facade;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaPsiFacade, (String)"facade");
            return (PsiType)javaPsiFacade.getElementFactory().createType(set, PsiUtil.substituteTypeParameter((PsiType)lType, (String)"java.util.Set", (int)0, (boolean)false));
        }
        return null;
    }

    private final PsiType getTupleType(GrListOrMap expression) {
        GrExpression[] grExpressionArray = expression.getInitializers();
        Intrinsics.checkExpressionValueIsNotNull((Object)grExpressionArray, (String)"expression.initializers");
        GrExpression[] initializers = grExpressionArray;
        return (PsiType)new GrTupleType(initializers, expression, expression.getResolveScope(), JavaPsiFacade.getInstance((Project)expression.getProject())){
            final /* synthetic */ GrExpression[] $initializers;
            final /* synthetic */ GrListOrMap $expression;

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected PsiType[] inferComponents() {
                void $receiver$iv$iv;
                Object $receiver$iv = this.$initializers;
                GrExpression[] grExpressionArray = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                int n = ((void)$receiver$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it;
                    void v0 = it = (element$iv$iv = $receiver$iv$iv[i]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
                    Collection<PsiType> collection = this.doGetComponentTypes((GrExpression)v0);
                    if (collection == null) {
                        Intrinsics.checkExpressionValueIsNotNull((Object)PsiType.EMPTY_ARRAY, (String)"PsiType.EMPTY_ARRAY");
                        return PsiType.EMPTY_ARRAY;
                    }
                    Iterable list$iv$iv = collection;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                Object thisCollection$iv = $receiver$iv;
                PsiType[] psiTypeArray = thisCollection$iv.toArray(new PsiType[0]);
                if (psiTypeArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                return psiTypeArray;
            }

            private final Collection<PsiType> doGetComponentTypes(GrExpression initializer) {
                return (Collection)RecursionManager.doPreventingRecursion((Object)initializer, (boolean)false, (Computable)((Computable)new Computable<T>(initializer){
                    final /* synthetic */ GrExpression $initializer;

                    @Nullable
                    public final List<PsiType> compute() {
                        List list;
                        if (this.$initializer instanceof GrSpreadArgument) {
                            Object[] objectArray;
                            GrExpression grExpression = ((GrSpreadArgument)this.$initializer).getArgument();
                            Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"initializer.argument");
                            PsiType psiType = grExpression.getType();
                            if (!(psiType instanceof GrTupleType)) {
                                psiType = null;
                            }
                            list = (objectArray = (Object[])psiType) != null && (objectArray = objectArray.getComponentTypes()) != null ? ArraysKt.toList((Object[])objectArray) : null;
                        } else {
                            PsiType psiType = TypesUtil.boxPrimitiveType(this.$initializer.getType(), this.$initializer.getManager(), this.$initializer.getResolveScope());
                            if (psiType != null) {
                                PsiType psiType2;
                                PsiType it = psiType2 = psiType;
                                list = CollectionsKt.listOf((Object)it);
                            } else {
                                list = null;
                            }
                        }
                        return list;
                    }
                    {
                        this.$initializer = grExpression;
                    }
                }));
            }

            public boolean isValid() {
                boolean bl;
                block1: {
                    GrExpression[] $receiver$iv = this.$initializers;
                    int n = $receiver$iv.length;
                    for (int i = 0; i < n; ++i) {
                        GrExpression element$iv;
                        GrExpression it;
                        GrExpression grExpression = it = (element$iv = $receiver$iv[i]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"it");
                        if (grExpression.isValid()) continue;
                        bl = false;
                        break block1;
                    }
                    bl = true;
                }
                return bl;
            }
            {
                this.$initializers = $captured_local_variable$0;
                this.$expression = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
    }
}

