/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrOperatorExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.resolve.DependentResolver;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\"\u0010\u0004\u001a\u0016\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrOperatorResolver;", "Lorg/jetbrains/plugins/groovy/lang/resolve/DependentResolver;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrOperatorExpression;", "()V", "operatorNames", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "", "collectDependencies", "", "Lcom/intellij/psi/PsiPolyVariantReference;", "ref", "doResolve", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "incomplete", "", "intellij.groovy.psi"})
public final class GrOperatorResolver
extends DependentResolver<GrOperatorExpression> {
    private static final Map<IElementType, String> operatorNames;
    public static final GrOperatorResolver INSTANCE;

    @Override
    @Nullable
    protected Collection<PsiPolyVariantReference> collectDependencies(@NotNull GrOperatorExpression ref) {
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        SmartList result2 = new SmartList();
        ref.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(result2){
            final /* synthetic */ SmartList $result;

            public void visitElement(@NotNull PsiElement element) {
                GrExpression operand;
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                if (element instanceof GrOperatorExpression) {
                    super.visitElement(element);
                } else if (element instanceof GrParenthesizedExpression && (operand = ((GrParenthesizedExpression)element).getOperand()) != null) {
                    super.visitElement((PsiElement)operand);
                }
            }

            protected void elementFinished(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                if (element instanceof GrOperatorExpression) {
                    this.$result.add((Object)element);
                }
            }
            {
                this.$result = $captured_local_variable$0;
            }
        });
        return (Collection)result2;
    }

    @Override
    @NotNull
    protected Collection<GroovyResolveResult> doResolve(@NotNull GrOperatorExpression ref, boolean incomplete) {
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        String string = operatorNames.get(ref.getOperator());
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String operatorName = string;
        PsiType psiType = ref.getLeftType();
        if (psiType == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"ref.leftType ?: return emptyList()");
        PsiType leftType = psiType;
        PsiType rightType = ref.getRightType();
        Object[] objectArray = ResolveUtil.getMethodCandidates(leftType, operatorName, (PsiElement)ref, incomplete, rightType);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"getMethodCandidates(left\u2026f, incomplete, rightType)");
        return ArraysKt.toList((Object[])objectArray);
    }

    private GrOperatorResolver() {
    }

    static {
        GrOperatorResolver grOperatorResolver;
        INSTANCE = grOperatorResolver = new GrOperatorResolver();
        operatorNames = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)GroovyTokenTypes.mPLUS, (Object)"plus"), TuplesKt.to((Object)GroovyTokenTypes.mMINUS, (Object)"minus"), TuplesKt.to((Object)GroovyTokenTypes.mDIV, (Object)"div"), TuplesKt.to((Object)GroovyTokenTypes.mSTAR, (Object)"multiply"), TuplesKt.to((Object)GroovyTokenTypes.mMOD, (Object)"mod"), TuplesKt.to((Object)GroovyTokenTypes.mSTAR_STAR, (Object)"power"), TuplesKt.to((Object)GroovyTokenTypes.mBAND, (Object)"and"), TuplesKt.to((Object)GroovyTokenTypes.mBOR, (Object)"or"), TuplesKt.to((Object)GroovyTokenTypes.mBXOR, (Object)"xor"), TuplesKt.to((Object)GroovyElementTypes.COMPOSITE_LSHIFT_SIGN, (Object)"leftShift"), TuplesKt.to((Object)GroovyElementTypes.COMPOSITE_RSHIFT_SIGN, (Object)"rightShift"), TuplesKt.to((Object)GroovyElementTypes.COMPOSITE_TRIPLE_SHIFT_SIGN, (Object)"rightShiftUnsigned"), TuplesKt.to((Object)GroovyTokenTypes.mEQUAL, (Object)"equals"), TuplesKt.to((Object)GroovyTokenTypes.mNOT_EQUAL, (Object)"equals"), TuplesKt.to((Object)GroovyTokenTypes.mLT, (Object)"compareTo"), TuplesKt.to((Object)GroovyTokenTypes.mLE, (Object)"compareTo"), TuplesKt.to((Object)GroovyTokenTypes.mGT, (Object)"compareTo"), TuplesKt.to((Object)GroovyTokenTypes.mGE, (Object)"compareTo"), TuplesKt.to((Object)GroovyTokenTypes.mCOMPARE_TO, (Object)"compareTo")});
    }
}

