/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/TypeConstraint;", "Lcom/intellij/psi/impl/source/resolve/graphInference/constraints/ConstraintFormula;", "leftType", "Lcom/intellij/psi/PsiType;", "rightType", "context", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiType;Lcom/intellij/psi/PsiType;Lcom/intellij/psi/PsiElement;)V", "getContext", "()Lcom/intellij/psi/PsiElement;", "getLeftType", "()Lcom/intellij/psi/PsiType;", "apply", "", "substitutor", "Lcom/intellij/psi/PsiSubstitutor;", "cache", "", "reduce", "session", "Lcom/intellij/psi/impl/source/resolve/graphInference/InferenceSession;", "constraints", "", "intellij.groovy.psi"})
public final class TypeConstraint
implements ConstraintFormula {
    @NotNull
    private final PsiType leftType;
    private final PsiType rightType;
    @NotNull
    private final PsiElement context;

    public boolean reduce(@NotNull InferenceSession session, @NotNull List<ConstraintFormula> constraints) {
        PsiType rawWildcardType;
        PsiType psiType;
        PsiType argType;
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(constraints, (String)"constraints");
        if (!(session instanceof GroovyInferenceSession)) {
            return true;
        }
        PsiType psiType2 = this.rightType;
        if (psiType2 == null) {
            psiType2 = argType = (PsiType)PsiType.NULL;
        }
        if (argType instanceof GrTupleType && (psiType = (rawWildcardType = TypesUtil.rawWildcard(argType, this.context))) == null) {
            psiType = argType = argType;
        }
        if (!(argType instanceof GrLiteralClassType)) {
            argType = PsiUtil.captureToplevelWildcards((PsiType)argType, (PsiElement)this.context);
        }
        if (argType instanceof GrMapType && ((GroovyInferenceSession)session).getSkipClosureBlock()) {
            argType = (PsiType)TypesUtil.createTypeByFQClassName("java.util.Map", this.context);
        }
        PsiType t = ((GroovyInferenceSession)session).getSiteSubstitutor().substitute(session.substituteWithInferenceVariables(this.leftType));
        PsiType s = ((GroovyInferenceSession)session).getSiteSubstitutor().substitute(session.substituteWithInferenceVariables(argType));
        constraints.add((ConstraintFormula)new TypeCompatibilityConstraint(t, s));
        return true;
    }

    public void apply(@NotNull PsiSubstitutor substitutor, boolean cache2) {
        Intrinsics.checkParameterIsNotNull((Object)substitutor, (String)"substitutor");
    }

    @NotNull
    public final PsiType getLeftType() {
        return this.leftType;
    }

    @NotNull
    public final PsiElement getContext() {
        return this.context;
    }

    public TypeConstraint(@NotNull PsiType leftType, @Nullable PsiType rightType, @NotNull PsiElement context) {
        Intrinsics.checkParameterIsNotNull((Object)leftType, (String)"leftType");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.leftType = leftType;
        this.rightType = rightType;
        this.context = context;
    }
}

