/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.ClosureConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.ReferenceExpressionConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.TypeConstraint;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/ExpressionConstraint;", "Lcom/intellij/psi/impl/source/resolve/graphInference/constraints/ConstraintFormula;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "leftType", "Lcom/intellij/psi/PsiType;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;Lcom/intellij/psi/PsiType;)V", "getExpression", "()Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "getLeftType", "()Lcom/intellij/psi/PsiType;", "apply", "", "substitutor", "Lcom/intellij/psi/PsiSubstitutor;", "cache", "", "reduce", "session", "Lcom/intellij/psi/impl/source/resolve/graphInference/InferenceSession;", "constraints", "", "intellij.groovy.psi"})
public final class ExpressionConstraint
implements ConstraintFormula {
    @NotNull
    private final GrExpression expression;
    @Nullable
    private final PsiType leftType;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reduce(@NotNull InferenceSession session, @NotNull List<ConstraintFormula> constraints) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(constraints, (String)"constraints");
        GrExpression grExpression = this.expression;
        if (grExpression instanceof GrMethodCall) {
            GrExpression invokedExpression;
            GrExpression grExpression2 = ((GrMethodCall)this.expression).getInvokedExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)grExpression2, (String)"expression.invokedExpression");
            GrExpression grExpression3 = invokedExpression = grExpression2;
            if (!(grExpression3 instanceof GrReferenceExpression)) return true;
            constraints.add(new ReferenceExpressionConstraint((GrReferenceExpression)invokedExpression, this.leftType));
            return true;
        } else if (grExpression instanceof GrClosableBlock) {
            if (this.leftType == null) return true;
            constraints.add(new ClosureConstraint((GrClosableBlock)this.expression, this.leftType));
            return true;
        } else {
            if (this.leftType == null) return true;
            constraints.add(new TypeConstraint(this.leftType, this.expression.getType(), this.expression));
        }
        return true;
    }

    public void apply(@NotNull PsiSubstitutor substitutor, boolean cache2) {
        Intrinsics.checkParameterIsNotNull((Object)substitutor, (String)"substitutor");
    }

    @NotNull
    public final GrExpression getExpression() {
        return this.expression;
    }

    @Nullable
    public final PsiType getLeftType() {
        return this.leftType;
    }

    public ExpressionConstraint(@NotNull GrExpression expression, @Nullable PsiType leftType) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        this.expression = expression;
        this.leftType = leftType;
    }
}

