/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.sam.SamConversionKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0002J\u001e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/ClosureConstraint;", "Lcom/intellij/psi/impl/source/resolve/graphInference/constraints/ConstraintFormula;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "leftType", "Lcom/intellij/psi/PsiType;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;Lcom/intellij/psi/PsiType;)V", "getClosure", "()Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "getLeftType", "()Lcom/intellij/psi/PsiType;", "apply", "", "substitutor", "Lcom/intellij/psi/PsiSubstitutor;", "cache", "", "callSamReturnType", "reduce", "session", "Lcom/intellij/psi/impl/source/resolve/graphInference/InferenceSession;", "constraints", "", "intellij.groovy.psi"})
public final class ClosureConstraint
implements ConstraintFormula {
    @NotNull
    private final GrClosableBlock closure;
    @NotNull
    private final PsiType leftType;

    public boolean reduce(@NotNull InferenceSession session, @NotNull List<ConstraintFormula> constraints) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(constraints, (String)"constraints");
        if (!((GroovyInferenceSession)session).getSkipClosureBlock() && !CollectionsKt.contains((Iterable)((GroovyInferenceSession)session).getClosureSkipList(), (Object)GrClosureSignatureUtil.findCall(this.closure))) {
            if (!(this.leftType instanceof PsiClassType)) {
                return true;
            }
            PsiType psiType = this.closure.getReturnType();
            if (psiType == null) {
                return true;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"closure.returnType ?: return true");
            PsiType closureReturnType = psiType;
            if (Intrinsics.areEqual((Object)closureReturnType, (Object)PsiType.VOID)) {
                return true;
            }
            if (TypesUtil.isClassType(this.leftType, "groovy.lang.Closure")) {
                PsiType[] psiTypeArray = ((PsiClassType)this.leftType).getParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeArray, (String)"leftType.parameters");
                PsiType[] parameters = psiTypeArray;
                if (parameters.length != 1) {
                    return true;
                }
                PsiType psiType2 = parameters[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)psiType2, (String)"parameters[0]");
                constraints.add(new TypeConstraint(psiType2, closureReturnType, this.closure));
            } else {
                PsiType psiType3 = this.callSamReturnType();
                if (psiType3 == null) {
                    return true;
                }
                PsiType samReturnType = psiType3;
                constraints.add(new TypeConstraint(samReturnType, closureReturnType, this.closure));
            }
        }
        return true;
    }

    private final PsiType callSamReturnType() {
        if (SamConversionKt.isSamConversionAllowed(this.closure)) {
            PsiClassType groundType;
            PsiClassType psiClassType;
            PsiClassType it;
            PsiClassType psiClassType2;
            PsiType psiType = this.leftType;
            if (!(psiType instanceof PsiClassType)) {
                psiType = null;
            }
            if ((psiClassType2 = (PsiClassType)psiType) == null || (psiClassType2 = FunctionalInterfaceParameterizationUtil.getNonWildcardParameterization((PsiClassType)(it = (psiClassType = psiClassType2)))) == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType2, (String)"(leftType as? PsiClassTy\u2026tion(it) } ?: return null");
            PsiClassType psiClassType3 = groundType = psiClassType2;
            if (psiClassType3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiClassType");
            }
            PsiClassType.ClassResolveResult classResolveResult = psiClassType3.resolveGenerics();
            Intrinsics.checkExpressionValueIsNotNull((Object)classResolveResult, (String)"(groundType as PsiClassType).resolveGenerics()");
            PsiClassType.ClassResolveResult resolveResult = classResolveResult;
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"resolveResult.element ?: return null");
            PsiClass samClass = psiClass;
            PsiMethod psiMethod = SamConversionKt.findSingleAbstractMethod(samClass);
            if (psiMethod == null) {
                return null;
            }
            PsiMethod sam2 = psiMethod;
            return resolveResult.getSubstitutor().substitute(sam2.getReturnType());
        }
        return null;
    }

    public void apply(@NotNull PsiSubstitutor substitutor, boolean cache2) {
        Intrinsics.checkParameterIsNotNull((Object)substitutor, (String)"substitutor");
    }

    @NotNull
    public final GrClosableBlock getClosure() {
        return this.closure;
    }

    @NotNull
    public final PsiType getLeftType() {
        return this.leftType;
    }

    public ClosureConstraint(@NotNull GrClosableBlock closure, @NotNull PsiType leftType) {
        Intrinsics.checkParameterIsNotNull((Object)closure, (String)"closure");
        Intrinsics.checkParameterIsNotNull((Object)leftType, (String)"leftType");
        this.closure = closure;
        this.leftType = leftType;
    }
}

