/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.scope.ElementClassHint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrScopeProcessorWithHints;

public abstract class ResolverProcessor<T extends GroovyResolveResult>
extends GrScopeProcessorWithHints {
    protected final PsiElement myPlace;
    private List<T> myCandidates;

    protected ResolverProcessor(@Nullable String name, @NotNull EnumSet<ElementClassHint.DeclarationKind> resolveTargets, @NotNull PsiElement place) {
        if (resolveTargets == null) {
            ResolverProcessor.$$$reportNull$$$0(0);
        }
        if (place == null) {
            ResolverProcessor.$$$reportNull$$$0(1);
        }
        super(name, resolveTargets);
        this.myPlace = place;
    }

    protected final void addCandidate(@NotNull T candidate) {
        if (candidate == null) {
            ResolverProcessor.$$$reportNull$$$0(2);
        }
        PsiElement element = candidate.getElement();
        assert (element == null || element.isValid()) : ResolverProcessor.getElementInfo(element);
        if (this.myCandidates == null) {
            this.myCandidates = new ArrayList<T>();
        }
        this.myCandidates.add(candidate);
    }

    @NotNull
    private static String getElementInfo(@NotNull PsiElement element) {
        PsiElement context;
        if (element == null) {
            ResolverProcessor.$$$reportNull$$$0(3);
        }
        String text = element instanceof LightElement ? ((context = element.getContext()) instanceof LightElement ? context.toString() : (context != null ? context.getText() : null)) : element.getText();
        String string = "invalid resolve candidate: " + element.getClass() + ", text: " + text;
        if (string == null) {
            ResolverProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected List<T> getCandidatesInternal() {
        List list = this.myCandidates == null ? Collections.emptyList() : this.myCandidates;
        if (list == null) {
            ResolverProcessor.$$$reportNull$$$0(5);
        }
        return list;
    }

    protected boolean isAccessible(@NotNull PsiNamedElement namedElement) {
        if (namedElement == null) {
            ResolverProcessor.$$$reportNull$$$0(6);
        }
        if (namedElement instanceof GrField) {
            GrField field = (GrField)namedElement;
            if (PsiUtil.isAccessible(this.myPlace, field)) {
                return true;
            }
            for (GrAccessorMethod method : field.getGetters()) {
                if (!PsiUtil.isAccessible(this.myPlace, (PsiMember)method)) continue;
                return true;
            }
            GrAccessorMethod setter = field.getSetter();
            return setter != null && PsiUtil.isAccessible(this.myPlace, (PsiMember)setter);
        }
        return !(namedElement instanceof PsiMember) || PsiUtil.isAccessible(this.myPlace, (PsiMember)namedElement);
    }

    protected boolean isStaticsOK(@NotNull PsiNamedElement element, @Nullable PsiElement resolveContext, boolean filterStaticAfterInstanceQualifier) {
        if (element == null) {
            ResolverProcessor.$$$reportNull$$$0(7);
        }
        if (resolveContext instanceof GrImportStatement) {
            return true;
        }
        if (element instanceof PsiModifierListOwner) {
            return GrStaticChecker.isStaticsOK((PsiModifierListOwner)element, this.myPlace, resolveContext, filterStaticAfterInstanceQualifier);
        }
        return true;
    }

    @NotNull
    public GroovyResolveResult[] getCandidates() {
        if (this.myCandidates == null) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                ResolverProcessor.$$$reportNull$$$0(8);
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult[] groovyResolveResultArray = this.myCandidates.toArray(GroovyResolveResult.EMPTY_ARRAY);
        if (groovyResolveResultArray == null) {
            ResolverProcessor.$$$reportNull$$$0(9);
        }
        return groovyResolveResultArray;
    }

    public boolean hasCandidates() {
        return this.myCandidates != null;
    }

    public String toString() {
        return "NameHint: '" + this.myName + "', " + this.myResolveTargetKinds + ", Candidates: " + (this.myCandidates == null ? 0 : this.myCandidates.size());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveTargets";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidatesInternal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCandidate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isStaticsOK";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

