/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyMethodResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.PropertyUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.GrResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.DynamicMembersHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.MethodCandidate;

public abstract class GroovyResolverProcessor
implements PsiScopeProcessor,
ElementClassHint,
NameHint,
DynamicMembersHint {
    @NotNull
    protected final GrReferenceExpression myRef;
    @NotNull
    private final String myName;
    @NotNull
    protected final EnumSet<GroovyResolveKind> myAcceptableKinds;
    private final boolean myIsLValue;
    @NotNull
    protected final PsiType[] myTypeArguments;
    @NotNull
    protected final NullableLazyValue<PsiType[]> myArgumentTypes;
    protected final List<GrResolverProcessor<? extends GroovyResolveResult>> myAccessorProcessors;
    protected final MultiMap<GroovyResolveKind, GroovyResolveResult> myCandidates;
    protected final MultiMap<GroovyResolveKind, GroovyResolveResult> myInapplicableCandidates;
    private boolean myStopExecutingMethods;

    GroovyResolverProcessor(@NotNull GrReferenceExpression ref, @NotNull EnumSet<GroovyResolveKind> kinds, boolean forceRValue) {
        if (ref == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(0);
        }
        if (kinds == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(1);
        }
        this.myCandidates = MultiMap.create();
        this.myInapplicableCandidates = MultiMap.create();
        this.myStopExecutingMethods = false;
        this.myRef = ref;
        this.myAcceptableKinds = kinds;
        this.myName = GroovyResolverProcessor.getReferenceName(ref);
        this.myIsLValue = !forceRValue && PsiUtil.isLValue(this.myRef);
        this.myTypeArguments = ref.getTypeArguments();
        this.myArgumentTypes = kinds.contains((Object)GroovyResolveKind.METHOD) || this.myIsLValue ? NullableLazyValue.createValue(() -> InferenceKt.buildTopLevelArgumentTypes(this.myRef)) : NullableLazyValue.createValue(() -> null);
        this.myAccessorProcessors = this.calcAccessorProcessors();
    }

    private List<GrResolverProcessor<? extends GroovyResolveResult>> calcAccessorProcessors() {
        if (!this.isPropertyResolve() || !PropertyUtilKt.isPropertyName(this.myName)) {
            return Collections.emptyList();
        }
        Lazy receiverType = LazyKt.lazy(() -> this.getTopLevelQualifierType());
        if (this.myIsLValue) {
            return Collections.singletonList(new PropertyProcessor((Lazy<? extends PsiType>)receiverType, this.myName, PropertyKind.SETTER, (Function0<PsiType[]>)((Function0)() -> (PsiType[])this.myArgumentTypes.getValue()), (PsiElement)this.myRef));
        }
        return ContainerUtil.newArrayList((Object[])new GrResolverProcessor[]{new PropertyProcessor((Lazy<? extends PsiType>)receiverType, this.myName, PropertyKind.GETTER, (Function0<PsiType[]>)((Function0)() -> PsiType.EMPTY_ARRAY), (PsiElement)this.myRef), new PropertyProcessor((Lazy<? extends PsiType>)receiverType, this.myName, PropertyKind.BOOLEAN_GETTER, (Function0<PsiType[]>)((Function0)() -> PsiType.EMPTY_ARRAY), (PsiElement)this.myRef)});
    }

    public PsiType getTopLevelQualifierType() {
        GrExpression expression = this.myRef.getQualifierExpression();
        if (expression instanceof GrMethodCallExpression) {
            return InferenceKt.getTopLevelTypeCached(expression);
        }
        return PsiImplUtil.getQualifierType(this.myRef);
    }

    public boolean isPropertyResolve() {
        return this.myAcceptableKinds.contains((Object)GroovyResolveKind.PROPERTY);
    }

    public static List<PsiScopeProcessor> allProcessors(PsiScopeProcessor processor) {
        List<GrResolverProcessor<? extends GroovyResolveResult>> accessors;
        if (processor instanceof GroovyResolverProcessor && !((GroovyResolverProcessor)processor).myStopExecutingMethods && !(accessors = ((GroovyResolverProcessor)processor).myAccessorProcessors).isEmpty()) {
            return ContainerUtil.concat(Collections.singletonList(processor), accessors);
        }
        return Collections.singletonList(processor);
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        GroovyResolveResultImpl candidate;
        if (element == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(2);
        }
        if (state == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(3);
        }
        if (!(element instanceof PsiNamedElement)) {
            return true;
        }
        PsiNamedElement namedElement = (PsiNamedElement)element;
        String name = ResolveUtilKt.getName(state, namedElement);
        if (!this.myName.equals(name)) {
            return true;
        }
        GroovyResolveKind kind = GroovyResolverProcessor.getResolveKind(namedElement);
        if (!this.myAcceptableKinds.contains((Object)kind)) {
            return true;
        }
        if (kind == GroovyResolveKind.METHOD ? this.myStopExecutingMethods : !this.myCandidates.get((Object)kind).isEmpty()) {
            return true;
        }
        PsiElement resolveContext = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT);
        SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
        boolean isAccessible = ResolveUtil.isAccessible(this.myRef, namedElement);
        boolean isStaticsOK = ResolveUtil.isStaticsOK(this.myRef, namedElement, resolveContext, false);
        if (kind == GroovyResolveKind.METHOD) {
            PsiMethod method = (PsiMethod)namedElement;
            MethodCandidate methodCandidate = this.buildMethodCandidate(state, method);
            GroovyInferenceSession session = new GroovyInferenceSessionBuilder(this.myRef, methodCandidate).build();
            PsiSubstitutor applicabilitySubst = session.inferSubst();
            candidate = new GroovyMethodResultImpl(method, resolveContext, spreadState, applicabilitySubst, (NotNullComputable<PsiSubstitutor>)((NotNullComputable)() -> {
                GroovyInferenceSession inferenceSession = new GroovyInferenceSessionBuilder(this.myRef, methodCandidate).addReturnConstraint().resolveMode(false).startFromTop(true).build();
                PsiSubstitutor substitutor = inferenceSession.inferSubst(this.myRef);
                return substitutor;
            }), methodCandidate, false, isAccessible, isStaticsOK, methodCandidate.isApplicable(applicabilitySubst));
        } else {
            PsiSubstitutor substitutor = GroovyResolverProcessor.getSubstitutor(state);
            candidate = new GroovyResolveResultImpl((PsiElement)namedElement, resolveContext, spreadState, substitutor, isAccessible, isStaticsOK, false, true);
        }
        (candidate.isValidResult() ? this.myCandidates : this.myInapplicableCandidates).putValue((Object)kind, (Object)candidate);
        if (candidate.isValidResult() && kind == GroovyResolveKind.VARIABLE) {
            this.myStopExecutingMethods = true;
        }
        return true;
    }

    private MethodCandidate buildMethodCandidate(@NotNull ResolveState state, PsiMethod method) {
        if (state == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(4);
        }
        PsiSubstitutor substitutor = GroovyResolverProcessor.getSubstitutor(state);
        PsiSubstitutor siteSubstitutor = GroovyResolverProcessor.updateSubst(this.myRef.getTypeArguments(), method.getTypeParameters(), substitutor);
        GrExpression qualifierExpression = this.myRef.getQualifierExpression();
        Argument qualifierConstraint = this.buildQualifier(state, qualifierExpression);
        List<Argument> argumentConstraints = InferenceKt.buildArguments(this.myRef);
        if (method instanceof GrGdkMethod) {
            ArrayList<Argument> arguments = new ArrayList<Argument>();
            arguments.add(0, qualifierConstraint);
            arguments.addAll(argumentConstraints);
            return new MethodCandidate(((GrGdkMethod)method).getStaticMethod(), siteSubstitutor, null, arguments, this.myRef);
        }
        return new MethodCandidate(method, siteSubstitutor, qualifierConstraint, argumentConstraints, this.myRef);
    }

    @NotNull
    private Argument buildQualifier(@NotNull ResolveState state, GrExpression qualifierExpression) {
        if (state == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(5);
        }
        PsiType resolvedThis = (PsiType)state.get(ClassHint.THIS_TYPE);
        SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
        if (qualifierExpression != null && spreadState == null) {
            Argument argument = new Argument(null, qualifierExpression);
            if (argument == null) {
                GroovyResolverProcessor.$$$reportNull$$$0(6);
            }
            return argument;
        }
        PsiType type = PsiImplUtil.getQualifierType(this.myRef);
        if (spreadState != null && type != null) {
            type = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)false);
        }
        Argument argument = new Argument(resolvedThis != null ? resolvedThis : type, null);
        if (argument == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(7);
        }
        return argument;
    }

    @NotNull
    private static PsiSubstitutor updateSubst(@NotNull PsiType[] arguments, @NotNull PsiTypeParameter[] parameters, @NotNull PsiSubstitutor substitutor) {
        if (arguments == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(8);
        }
        if (parameters == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(9);
        }
        if (substitutor == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(10);
        }
        if (arguments.length != parameters.length) {
            PsiSubstitutor psiSubstitutor = substitutor;
            if (psiSubstitutor == null) {
                GroovyResolverProcessor.$$$reportNull$$$0(11);
            }
            return psiSubstitutor;
        }
        for (int i = 0; i < arguments.length; ++i) {
            substitutor.put(parameters[i], arguments[i]);
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(12);
        }
        return psiSubstitutor;
    }

    @Nullable
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(13);
        }
        if (hintKey == ElementClassHint.KEY || hintKey == NameHint.KEY || hintKey == DynamicMembersHint.KEY) {
            return (T)this;
        }
        return null;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, @Nullable Object associated) {
        if (event == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(14);
        }
        if (JavaScopeProcessorEvent.CHANGE_LEVEL == event && !this.myCandidates.get((Object)GroovyResolveKind.METHOD).isEmpty()) {
            this.myStopExecutingMethods = true;
        }
    }

    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        if (kind == ElementClassHint.DeclarationKind.METHOD) {
            if (this.myStopExecutingMethods) {
                return false;
            }
            if (this.isPropertyResolve() && !this.myAcceptableKinds.contains((Object)GroovyResolveKind.METHOD)) {
                return false;
            }
        }
        for (GroovyResolveKind resolveKind : this.myAcceptableKinds) {
            if (!resolveKind.declarationKinds.contains(kind)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getName(@NotNull ResolveState state) {
        if (state == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(15);
        }
        String string = this.myName;
        if (string == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    public boolean shouldProcessMethods() {
        return this.myRef.getParent() instanceof GrCallExpression && !this.myCandidates.containsKey((Object)GroovyResolveKind.METHOD);
    }

    @Override
    public boolean shouldProcessProperties() {
        return true;
    }

    @NotNull
    public abstract List<GroovyResolveResult> getCandidates();

    public final GroovyResolveResult[] getCandidatesArray() {
        List<GroovyResolveResult> candidates = this.getCandidates();
        int size = candidates.size();
        if (size == 0) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        if (size == 1) {
            return new GroovyResolveResult[]{candidates.get(0)};
        }
        return candidates.toArray(new GroovyResolveResult[size]);
    }

    private static GroovyResolveKind getResolveKind(PsiNamedElement element) {
        if (element instanceof PsiClass) {
            return GroovyResolveKind.CLASS;
        }
        if (element instanceof PsiPackage) {
            return GroovyResolveKind.PACKAGE;
        }
        if (element instanceof PsiMethod) {
            return GroovyResolveKind.METHOD;
        }
        if (element instanceof PsiEnumConstant) {
            return GroovyResolveKind.ENUM_CONST;
        }
        if (element instanceof PsiField) {
            return GroovyResolveKind.FIELD;
        }
        if (element instanceof GrBindingVariable) {
            return GroovyResolveKind.BINDING;
        }
        if (element instanceof PsiVariable) {
            return GroovyResolveKind.VARIABLE;
        }
        return null;
    }

    @NotNull
    protected List<GroovyResolveResult> getCandidates(GroovyResolveKind ... kinds) {
        if (kinds == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(17);
        }
        List<GroovyResolveResult> list = this.getCandidates(true, kinds);
        if (list == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    protected List<GroovyResolveResult> getCandidates(boolean applicable, GroovyResolveKind ... kinds) {
        if (kinds == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(19);
        }
        MultiMap<GroovyResolveKind, GroovyResolveResult> map2 = applicable ? this.myCandidates : this.myInapplicableCandidates;
        List results = ContainerUtil.newSmartList();
        for (GroovyResolveKind kind : kinds) {
            if (kind == GroovyResolveKind.PROPERTY) {
                this.myAccessorProcessors.forEach(it -> it.getResults().stream().filter(result2 -> applicable == result2.isValidResult()).forEach(results::add));
                continue;
            }
            results.addAll(map2.get((Object)kind));
        }
        List list = results;
        if (list == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    protected static PsiSubstitutor getSubstitutor(@NotNull ResolveState state) {
        PsiSubstitutor substitutor;
        if (state == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(21);
        }
        if ((substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY)) == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(22);
        }
        return psiSubstitutor;
    }

    @NotNull
    private static String getReferenceName(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(23);
        }
        String name = ref.getReferenceName();
        assert (name != null) : "Reference name cannot be null";
        String string = name;
        if (string == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildQualifier";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "updateSubst";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildMethodCandidate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildQualifier";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateSubst";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCandidates";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

