/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.imports.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyFileImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyNamedImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyStarImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.RegularImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StarImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StaticImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StaticStarImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.impl.ImportKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.util.FlatCollectionKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001c\u0010\u0004\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\fJ\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0016J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0007H\u0016J&\u0010%\u001a\b\u0012\u0004\u0012\u0002H&0\u0007\"\b\b\u0000\u0010&*\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0\u0006H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\bH\u0016J \u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J \u00102\u001a\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J \u00103\u001a\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J \u00104\u001a\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J \u00105\u001a\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\b\u00106\u001a\u00020$H\u0016J*\u00107\u001a\u00020)*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0014\u00108\u001a\u00020/*\u00020/2\u0006\u0010*\u001a\u00020\bH\u0002R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0010\u00a8\u00069"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/imports/impl/GroovyFileImportsImpl;", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyFileImports;", "file", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "imports", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/impl/ImportKind;", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyImport;", "statementToImport", "Lorg/jetbrains/plugins/groovy/lang/psi/api/toplevel/imports/GrImportStatement;", "importToStatement", "(Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "allNamedImports", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyNamedImport;", "getAllNamedImports", "()Ljava/util/Collection;", "allStarImports", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyStarImport;", "getFile", "()Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "regularImports", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/RegularImport;", "getRegularImports", "starImports", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/StarImport;", "getStarImports", "staticImports", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/StaticImport;", "getStaticImports", "staticStarImports", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/StaticStarImport;", "getStaticStarImports", "findUnnecessaryStatements", "findUnresolvedStatements", "names", "", "getImports", "T", "kind", "isImplicit", "", "import", "processAllNamedImports", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "processAllStarImports", "processDefaultImports", "processStaticImports", "processStaticStarImports", "toString", "doProcess", "putImport", "intellij.groovy.psi"})
public final class GroovyFileImportsImpl
implements GroovyFileImports {
    @NotNull
    private final Collection<GroovyNamedImport> allNamedImports;
    private final Collection<GroovyStarImport> allStarImports;
    @NotNull
    private final GroovyFileBase file;
    private final Map<ImportKind<?>, Collection<GroovyImport>> imports;
    private final Map<GrImportStatement, GroovyImport> statementToImport;
    private final Map<GroovyImport, GrImportStatement> importToStatement;

    private final <T extends GroovyImport> Collection<T> getImports(ImportKind<T> kind) {
        Collection<GroovyImport> collection;
        Collection<GroovyImport> collection2 = this.imports.get(kind);
        if (collection2 == null) {
            return CollectionsKt.emptyList();
        }
        Collection<GroovyImport> collection3 = collection = collection2;
        if (collection3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<T>");
        }
        return collection3;
    }

    private final Collection<RegularImport> getRegularImports() {
        return this.getImports(ImportKind.Regular.INSTANCE);
    }

    private final Collection<StaticImport> getStaticImports() {
        return this.getImports(ImportKind.Static.INSTANCE);
    }

    @Override
    @NotNull
    public Collection<StarImport> getStarImports() {
        return this.getImports(ImportKind.Star.INSTANCE);
    }

    @Override
    @NotNull
    public Collection<StaticStarImport> getStaticStarImports() {
        return this.getImports(ImportKind.StaticStar.INSTANCE);
    }

    @Override
    @NotNull
    public Collection<GroovyNamedImport> getAllNamedImports() {
        return this.allNamedImports;
    }

    private final ResolveState putImport(@NotNull ResolveState $receiver, GroovyImport groovyImport) {
        ResolveState resolveState = $receiver.put(GroovyImports.getImportKey(), (Object)groovyImport);
        Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"put(importKey, import)");
        ResolveState state = resolveState;
        GrImportStatement grImportStatement = this.importToStatement.get(groovyImport);
        if (grImportStatement == null) {
            return state;
        }
        GrImportStatement statement = grImportStatement;
        ResolveState resolveState2 = state.put(ClassHint.RESOLVE_CONTEXT, (Object)statement);
        Intrinsics.checkExpressionValueIsNotNull((Object)resolveState2, (String)"state.put(ClassHint.RESOLVE_CONTEXT, statement)");
        return resolveState2;
    }

    private final boolean doProcess(@NotNull Collection<? extends GroovyImport> $receiver, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        for (GroovyImport groovyImport : $receiver) {
            if (groovyImport.processDeclarations(processor, this.putImport(state, groovyImport), place, this.getFile())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean processStaticImports(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        return this.doProcess(this.getStaticImports(), processor, state, place);
    }

    @Override
    public boolean processAllNamedImports(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        return this.doProcess(this.getAllNamedImports(), processor, state, place);
    }

    @Override
    public boolean processStaticStarImports(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        return this.doProcess(this.getStaticStarImports(), processor, state, place);
    }

    @Override
    public boolean processAllStarImports(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        return this.doProcess(this.allStarImports, processor, state, place);
    }

    @Override
    public boolean processDefaultImports(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        return this.doProcess((Collection<? extends GroovyImport>)GroovyImports.getDefaultImports(), processor, state, place);
    }

    @Override
    public boolean isImplicit(@NotNull GroovyImport groovyImport) {
        Intrinsics.checkParameterIsNotNull((Object)groovyImport, (String)"import");
        return !this.importToStatement.containsKey(groovyImport);
    }

    @Override
    @NotNull
    public Collection<GrImportStatement> findUnnecessaryStatements() {
        Map<GrImportStatement, GroovyImport> $receiver$iv = this.statementToImport;
        LinkedHashMap<GrImportStatement, GroovyImport> result$iv = new LinkedHashMap<GrImportStatement, GroovyImport>();
        Map<GrImportStatement, GroovyImport> map2 = $receiver$iv;
        for (Map.Entry<GrImportStatement, GroovyImport> entry$iv : map2.entrySet()) {
            GroovyImport it = entry$iv.getValue();
            if (!it.isUnnecessary(this)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return ((Map)result$iv).keySet();
    }

    @Override
    @NotNull
    public Collection<GrImportStatement> findUnresolvedStatements(@NotNull Collection<String> names) {
        GrImportStatement statement;
        Collection collection;
        Intrinsics.checkParameterIsNotNull(names, (String)"names");
        if (names.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        HashSet result2 = new HashSet();
        for (StarImport starImport : this.getStarImports()) {
            if (this.importToStatement.get(starImport) == null) {
                continue;
            }
            if (starImport.resolveImport(this.getFile()) != null) continue;
            collection = result2;
            collection.add(statement);
        }
        for (GroovyNamedImport groovyNamedImport : this.getAllNamedImports()) {
            if (!names.contains(groovyNamedImport.getName())) continue;
            if (this.importToStatement.get(groovyNamedImport) == null) {
                continue;
            }
            if (groovyNamedImport.resolveImport(this.getFile()) != null) continue;
            collection = result2;
            collection.add(statement);
        }
        return result2;
    }

    @NotNull
    public String toString() {
        return "Regular: " + this.getRegularImports().size() + "; " + "static: " + this.getStaticImports().size() + "; " + "*: " + this.getStarImports().size() + "; " + "static *: " + this.getStaticStarImports().size();
    }

    @Override
    @NotNull
    public GroovyFileBase getFile() {
        return this.file;
    }

    public GroovyFileImportsImpl(@NotNull GroovyFileBase file, @NotNull Map<ImportKind<?>, ? extends Collection<? extends GroovyImport>> imports2, @NotNull Map<GrImportStatement, ? extends GroovyImport> statementToImport, @NotNull Map<GroovyImport, ? extends GrImportStatement> importToStatement) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(imports2, (String)"imports");
        Intrinsics.checkParameterIsNotNull(statementToImport, (String)"statementToImport");
        Intrinsics.checkParameterIsNotNull(importToStatement, (String)"importToStatement");
        this.file = file;
        this.imports = imports2;
        this.statementToImport = statementToImport;
        this.importToStatement = importToStatement;
        this.allNamedImports = FlatCollectionKt.flatten(this.getImports(ImportKind.Regular.INSTANCE), this.getImports(ImportKind.Static.INSTANCE));
        this.allStarImports = FlatCollectionKt.flatten(this.getImports(ImportKind.Star.INSTANCE), this.getImports(ImportKind.StaticStar.INSTANCE));
    }
}

