/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.imports;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyFileImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyNamedImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StaticStarImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.impl.NonFqnImport;
import org.jetbrains.plugins.groovy.lang.resolve.processors.StaticMembersFilteringProcessor;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001e0\u001dH\u0002J(\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/imports/StaticImport;", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/impl/NonFqnImport;", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyNamedImport;", "classFqn", "", "memberName", "(Ljava/lang/String;Ljava/lang/String;)V", "name", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getClassFqn", "()Ljava/lang/String;", "isAliased", "", "()Z", "getMemberName", "getName", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "isUnnecessary", "imports", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyFileImports;", "namesMapping", "", "Lkotlin/Pair;", "processDeclarations", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "toString", "Companion", "intellij.groovy.psi"})
public final class StaticImport
extends NonFqnImport
implements GroovyNamedImport {
    private final boolean isAliased;
    @NotNull
    private final String classFqn;
    @NotNull
    private final String memberName;
    @NotNull
    private final String name;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isAliased() {
        return this.isAliased;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, @NotNull GroovyFileBase file) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (ResolveUtilKt.isAnnotationResolve(processor)) {
            return true;
        }
        if (!ResolveUtilKt.shouldProcessMembers(processor)) {
            return true;
        }
        PsiClass psiClass = this.resolveImport(file);
        if (psiClass == null) {
            return true;
        }
        PsiClass clazz = psiClass;
        List<Pair<String, String>> namesMapping = this.namesMapping();
        String hintName = ResolveUtilKt.getName(processor, state);
        for (Pair<String, String> pair : namesMapping) {
            StaticMembersFilteringProcessor delegate;
            String memberName = (String)pair.component1();
            String alias = (String)pair.component2();
            if (hintName != null && Intrinsics.areEqual((Object)hintName, (Object)alias) ^ true || clazz.processDeclarations((PsiScopeProcessor)(delegate = new StaticMembersFilteringProcessor(processor, memberName)), state.put(GroovyImports.getImportedNameKey(), (Object)alias), null, place)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUnnecessary(@NotNull GroovyFileImports imports2) {
        Intrinsics.checkParameterIsNotNull((Object)imports2, (String)"imports");
        if (this.isAliased()) {
            return false;
        }
        return imports2.getStaticStarImports().contains(new StaticStarImport(this.getClassFqn()));
    }

    @NotNull
    public String toString() {
        return "import static " + this.getClassFqn() + '.' + this.memberName + " as " + this.getName();
    }

    private final List<Pair<String, String>> namesMapping() {
        return StaticImport.Companion.namesMapping(this.memberName, this.getName());
    }

    @Override
    @NotNull
    public String getClassFqn() {
        return this.classFqn;
    }

    @NotNull
    public final String getMemberName() {
        return this.memberName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public StaticImport(@NotNull String classFqn, @NotNull String memberName, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)classFqn, (String)"classFqn");
        Intrinsics.checkParameterIsNotNull((Object)memberName, (String)"memberName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.classFqn = classFqn;
        this.memberName = memberName;
        this.name = name;
        this.isAliased = Intrinsics.areEqual((Object)this.memberName, (Object)this.getName()) ^ true;
    }

    public StaticImport(@NotNull String classFqn, @NotNull String memberName) {
        Intrinsics.checkParameterIsNotNull((Object)classFqn, (String)"classFqn");
        Intrinsics.checkParameterIsNotNull((Object)memberName, (String)"memberName");
        this(classFqn, memberName, memberName);
    }

    @NotNull
    public final String component1() {
        return this.getClassFqn();
    }

    @NotNull
    public final String component2() {
        return this.memberName;
    }

    @NotNull
    public final String component3() {
        return this.getName();
    }

    @NotNull
    public final StaticImport copy(@NotNull String classFqn, @NotNull String memberName, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)classFqn, (String)"classFqn");
        Intrinsics.checkParameterIsNotNull((Object)memberName, (String)"memberName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new StaticImport(classFqn, memberName, name);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ StaticImport copy$default(StaticImport staticImport, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = staticImport.getClassFqn();
        }
        if ((n & 2) != 0) {
            string2 = staticImport.memberName;
        }
        if ((n & 4) != 0) {
            string3 = staticImport.getName();
        }
        return staticImport.copy(string, string2, string3);
    }

    public int hashCode() {
        String string = this.getClassFqn();
        String string2 = this.memberName;
        String string3 = this.getName();
        return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof StaticImport)) break block3;
                StaticImport staticImport = (StaticImport)object;
                if (!Intrinsics.areEqual((Object)this.getClassFqn(), (Object)staticImport.getClassFqn()) || !Intrinsics.areEqual((Object)this.memberName, (Object)staticImport.memberName) || !Intrinsics.areEqual((Object)this.getName(), (Object)staticImport.getName())) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J*\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b0\u00042\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/imports/StaticImport$Companion;", "", "()V", "names", "", "", "name", "namesMapping", "Lkotlin/Pair;", "left", "right", "intellij.groovy.psi"})
    public static final class Companion {
        private final List<String> names(String name) {
            return CollectionsKt.listOf((Object[])new String[]{name, GroovyPropertyUtils.getGetterNameNonBoolean(name), GroovyPropertyUtils.getGetterNameBoolean(name), GroovyPropertyUtils.getSetterName(name)});
        }

        private final List<Pair<String, String>> namesMapping(String left, String right) {
            List<String> leftNames = this.names(left);
            List<String> rightNames = Intrinsics.areEqual((Object)left, (Object)right) ? leftNames : this.names(right);
            return CollectionsKt.zip((Iterable)leftNames, (Iterable)rightNames);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

