/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.util.Function;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class GroovyTraitFieldsFileIndex
extends SingleEntryFileBasedIndexExtension<Collection<TraitFieldDescriptor>>
implements DataExternalizer<Collection<TraitFieldDescriptor>> {
    public static final ID<Integer, Collection<TraitFieldDescriptor>> INDEX_ID = ID.create((String)"groovy.trait.fields");
    public static final String HELPER_SUFFIX = "$Trait$FieldHelper.class";
    private static final FileBasedIndex.InputFilter FILTER = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaClassFileType.INSTANCE}){

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                1.$$$reportNull$$$0(0);
            }
            return StringUtil.endsWith((CharSequence)file.getNameSequence(), (CharSequence)GroovyTraitFieldsFileIndex.HELPER_SUFFIX);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex$1", "acceptInput"));
        }
    };
    private static final SingleEntryIndexer<Collection<TraitFieldDescriptor>> INDEXER = new SingleEntryIndexer<Collection<TraitFieldDescriptor>>(true){

        protected Collection<TraitFieldDescriptor> computeValue(@NotNull FileContent inputData) {
            if (inputData == null) {
                2.$$$reportNull$$$0(0);
            }
            return GroovyTraitFieldsFileIndex.index(inputData);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex$2", "computeValue"));
        }
    };
    private static final String INSTANCE_PREFIX = "$ins";
    private static final String STATIC_PREFIX = "$static";
    private static final String PRIVATE_PREFIX = "$0";
    private static final String PUBLIC_PREFIX = "$1";
    private static final String DELIMITER = "__";

    @NotNull
    public ID<Integer, Collection<TraitFieldDescriptor>> getName() {
        ID<Integer, Collection<TraitFieldDescriptor>> iD = INDEX_ID;
        if (iD == null) {
            GroovyTraitFieldsFileIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public SingleEntryIndexer<Collection<TraitFieldDescriptor>> getIndexer() {
        SingleEntryIndexer<Collection<TraitFieldDescriptor>> singleEntryIndexer = INDEXER;
        if (singleEntryIndexer == null) {
            GroovyTraitFieldsFileIndex.$$$reportNull$$$0(1);
        }
        return singleEntryIndexer;
    }

    @NotNull
    public DataExternalizer<Collection<TraitFieldDescriptor>> getValueExternalizer() {
        GroovyTraitFieldsFileIndex groovyTraitFieldsFileIndex = this;
        if (groovyTraitFieldsFileIndex == null) {
            GroovyTraitFieldsFileIndex.$$$reportNull$$$0(2);
        }
        return groovyTraitFieldsFileIndex;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = FILTER;
        if (inputFilter == null) {
            GroovyTraitFieldsFileIndex.$$$reportNull$$$0(3);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 4;
    }

    private static Collection<TraitFieldDescriptor> index(FileContent inputData) {
        final ArrayList values = ContainerUtil.newArrayList();
        new ClassReader(inputData.getContent()).accept(new ClassVisitor(393216){

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                this.processField(access, name, desc, signature);
                return null;
            }

            private void processField(int access, String name, String desc, String signature) {
                if ((access & 0x1000) == 0) {
                    return;
                }
                Pair<Boolean, String> p = this.parse(GroovyTraitFieldsFileIndex.STATIC_PREFIX, GroovyTraitFieldsFileIndex.INSTANCE_PREFIX, name);
                if (p.first == null) {
                    return;
                }
                boolean isStatic = (Boolean)p.first;
                name = (String)p.second;
                p = this.parse(GroovyTraitFieldsFileIndex.PUBLIC_PREFIX, GroovyTraitFieldsFileIndex.PRIVATE_PREFIX, name);
                if (p.first == null) {
                    return;
                }
                boolean isPublic = (Boolean)p.first;
                name = (String)p.second;
                String typeString = this.fieldType(desc, signature);
                if (typeString == null) {
                    return;
                }
                int delimiter = name.indexOf(GroovyTraitFieldsFileIndex.DELIMITER);
                if (delimiter > -1) {
                    name = name.substring(delimiter + GroovyTraitFieldsFileIndex.DELIMITER.length());
                }
                byte flags = (byte)((isPublic ? 1 : 0) | (isStatic ? 2 : 0));
                values.add(new TraitFieldDescriptor(flags, typeString, name));
            }

            private Pair<Boolean, String> parse(String prefix, String prefix2, String input) {
                if (input.startsWith(prefix)) {
                    return Pair.create((Object)true, (Object)input.substring(prefix.length()));
                }
                if (input.startsWith(prefix2)) {
                    return Pair.create((Object)false, (Object)input.substring(prefix2.length()));
                }
                return Pair.create(null, (Object)input);
            }

            private String fieldType(String desc, String signature) {
                if (signature != null) {
                    try {
                        return SignatureParsing.parseTypeString((CharacterIterator)new StringCharacterIterator(signature), (Function)StubBuildingVisitor.GUESSING_MAPPER);
                    }
                    catch (ClsFormatException clsFormatException) {
                        // empty catch block
                    }
                }
                String raw = Type.getType((String)desc).getClassName();
                return (String)StubBuildingVisitor.GUESSING_MAPPER.fun((Object)raw);
            }
        }, ClsFileImpl.EMPTY_ATTRIBUTES, 1);
        return values;
    }

    public void save(@NotNull DataOutput out, Collection<TraitFieldDescriptor> values) throws IOException {
        if (out == null) {
            GroovyTraitFieldsFileIndex.$$$reportNull$$$0(4);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)values.size());
        for (TraitFieldDescriptor descriptor2 : values) {
            out.writeByte(descriptor2.flags);
            IOUtil.writeUTF((DataOutput)out, (String)descriptor2.typeString);
            IOUtil.writeUTF((DataOutput)out, (String)descriptor2.name);
        }
    }

    public Collection<TraitFieldDescriptor> read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            GroovyTraitFieldsFileIndex.$$$reportNull$$$0(5);
        }
        int size = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)size);
        for (int i = 0; i < size; ++i) {
            result2.add(new TraitFieldDescriptor(in.readByte(), IOUtil.readUTF((DataInput)in), IOUtil.readUTF((DataInput)in)));
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TraitFieldDescriptor {
        public static final byte PUBLIC = 1;
        public static final byte STATIC = 2;
        public final byte flags;
        public final String typeString;
        public final String name;

        private TraitFieldDescriptor(byte flags, @NotNull String typeString, @NotNull String name) {
            if (typeString == null) {
                TraitFieldDescriptor.$$$reportNull$$$0(0);
            }
            if (name == null) {
                TraitFieldDescriptor.$$$reportNull$$$0(1);
            }
            this.flags = flags;
            this.typeString = typeString;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TraitFieldDescriptor that = (TraitFieldDescriptor)o;
            if (this.flags != that.flags) {
                return false;
            }
            if (!this.typeString.equals(that.typeString)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result2 = this.flags;
            result2 = 31 * result2 + this.typeString.hashCode();
            result2 = 31 * result2 + this.name.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex$TraitFieldDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

