/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiTreeUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.ClassResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GrCodeReferenceResolverKt;
import org.jetbrains.plugins.groovy.lang.resolve.GrReferenceResolveRunner;
import org.jetbrains.plugins.groovy.lang.resolve.OwnerKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.CodeFieldProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessorBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.processors.LocalVariableProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ReferenceExpressionClassProcessor;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0005*\u00020\u0007H\u0002\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0007H\u0002\u001a!\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000b*\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000e\u001a\u0014\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0010*\u00020\u0007H\u0002\u001a\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u001a \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017*\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u000e\u0010\u001a\u001a\u0004\u0018\u00010\t*\u00020\u0007H\u0002\u001a \u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00100\u0017*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a \u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00100\u0017*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u0012*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u001f"}, d2={"checkCurrentClass", "", "field", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrField;", "place", "Lcom/intellij/psi/PsiElement;", "doResolvePackageOrClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "doResolveStatic", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "getCallVariants", "", "upToArgument", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;)[Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "resolvePackageOrClass", "Lorg/jetbrains/plugins/groovy/lang/resolve/ElementResolveResult;", "resolveQualifiedType", "Lorg/jetbrains/plugins/groovy/lang/resolve/ClassResolveResult;", "name", "", "qualifier", "resolveReferenceExpression", "", "forceRValue", "incomplete", "resolveStatic", "resolveToField", "resolveToLocalVariable", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariable;", "resolveUnqualifiedType", "intellij.groovy.psi"})
public final class GrReferenceResolveRunnerKt {
    @NotNull
    public static final GroovyResolveResult[] getCallVariants(@NotNull GrReferenceExpression $receiver, @Nullable GrExpression upToArgument) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        GroovyResolverProcessor groovyResolverProcessor = GroovyResolverProcessorBuilder.builder().setAllVariants(true).build($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolverProcessor, (String)"GroovyResolverProcessorB\u2026ts(true)\n    .build(this)");
        GroovyResolverProcessor processor = groovyResolverProcessor;
        new GrReferenceResolveRunner($receiver, processor).resolveReferenceExpression();
        GroovyResolveResult[] groovyResolveResultArray = processor.getCandidatesArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResultArray, (String)"processor.candidatesArray");
        return groovyResolveResultArray;
    }

    @NotNull
    public static final Collection<GroovyResolveResult> resolveReferenceExpression(@NotNull GrReferenceExpression $receiver, boolean forceRValue, boolean incomplete) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        GroovyResolveResult groovyResolveResult = GrReferenceResolveRunnerKt.resolveStatic($receiver);
        if (groovyResolveResult != null) {
            GroovyResolveResult groovyResolveResult2;
            GroovyResolveResult it = groovyResolveResult2 = groovyResolveResult;
            return CollectionsKt.listOf((Object)it);
        }
        if (!ResolveUtil.canResolveToMethod($receiver) && ResolveUtil.isDefinitelyKeyOfMap($receiver)) {
            return CollectionsKt.emptyList();
        }
        GroovyResolverProcessor groovyResolverProcessor = GroovyResolverProcessorBuilder.builder().setForceRValue(forceRValue).setIncomplete(incomplete).build($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolverProcessor, (String)"GroovyResolverProcessorB\u2026omplete)\n    .build(this)");
        GroovyResolverProcessor processor = groovyResolverProcessor;
        new GrReferenceResolveRunner($receiver, processor).resolveReferenceExpression();
        List<GroovyResolveResult> list = processor.getCandidates();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"processor.candidates");
        return list;
    }

    private static final ElementResolveResult<PsiElement> resolvePackageOrClass(@NotNull GrReferenceExpression $receiver) {
        ElementResolveResult<PsiElement> elementResolveResult;
        PsiElement psiElement = GrReferenceResolveRunnerKt.doResolvePackageOrClass($receiver);
        if (psiElement != null) {
            PsiElement psiElement2;
            PsiElement p1 = psiElement2 = psiElement;
            elementResolveResult = new ElementResolveResult<PsiElement>(p1);
        } else {
            elementResolveResult = null;
        }
        return elementResolveResult;
    }

    private static final PsiElement doResolvePackageOrClass(@NotNull GrReferenceExpression $receiver) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)$receiver.getProject());
        GlobalSearchScope globalSearchScope = $receiver.getResolveScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"resolveScope");
        GlobalSearchScope scope = globalSearchScope;
        Function1<GrReferenceExpression, PsiClass> resolveClass$ = new Function1<GrReferenceExpression, PsiClass>(facade, scope){
            final /* synthetic */ JavaPsiFacade $facade;
            final /* synthetic */ GlobalSearchScope $scope;

            @Nullable
            public final PsiClass invoke(@NotNull GrReferenceExpression $receiver) {
                char c;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                if ($receiver.getParent() instanceof GrMethodCall) {
                    return null;
                }
                String string = $receiver.getReferenceName();
                if (string == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"referenceName ?: return null");
                String name = string;
                CharSequence charSequence = name;
                if (charSequence.length() == 0 || !Character.isUpperCase(c = StringsKt.first((CharSequence)name))) {
                    return null;
                }
                String string2 = $receiver.getQualifiedReferenceName();
                if (string2 == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"qualifiedReferenceName ?: return null");
                String qname = string2;
                return this.$facade.findClass(qname, this.$scope);
            }
            {
                this.$facade = javaPsiFacade;
                this.$scope = globalSearchScope;
                super(1);
            }
        };
        if ($receiver.isQualified()) {
            PsiClass psiClass = resolveClass$.invoke($receiver);
            if (psiClass != null) {
                PsiClass psiClass2;
                PsiClass it = psiClass2 = psiClass;
                return (PsiElement)it;
            }
        }
        for (PsiElement parent : com.intellij.psi.util.PsiTreeUtilKt.strictParents((PsiElement)$receiver)) {
            if (!(parent instanceof GrReferenceExpression)) {
                return null;
            }
            if (resolveClass$.invoke((GrReferenceExpression)parent) == null) continue;
            String string = $receiver.getQualifiedReferenceName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"qualifiedReferenceName!!");
            String qname = string;
            return (PsiElement)facade.findPackage(qname);
        }
        return null;
    }

    private static final GroovyResolveResult resolveStatic(@NotNull GrReferenceExpression $receiver) {
        return (GroovyResolveResult)CachedValuesManager.getCachedValue((PsiElement)$receiver, (CachedValueProvider)new CachedValueProvider<T>($receiver){
            final /* synthetic */ GrReferenceExpression receiver$0;

            public final CachedValueProvider.Result<GroovyResolveResult> compute() {
                return CachedValueProvider.Result.create((Object)GrReferenceResolveRunnerKt.access$doResolveStatic(this.receiver$0), (Object[])new Object[]{this.receiver$0, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
            {
                this.receiver$0 = grReferenceExpression;
            }
        });
    }

    private static final GroovyResolveResult doResolveStatic(@NotNull GrReferenceExpression $receiver) {
        ElementResolveResult localVariable;
        String string = $receiver.getReferenceName();
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"referenceName ?: return null");
        String name = string;
        ElementResolveResult<PsiElement> fqnResult = GrReferenceResolveRunnerKt.resolvePackageOrClass($receiver);
        if (fqnResult != null) {
            return fqnResult;
        }
        GrExpression qualifier = (GrExpression)$receiver.getQualifier();
        if (qualifier == null && (localVariable = (ElementResolveResult)CollectionsKt.singleOrNull((Iterable)GrReferenceResolveRunnerKt.resolveToLocalVariable($receiver, name))) != null) {
            return localVariable;
        }
        if (!($receiver.getParent() instanceof GrMethodCall)) {
            ElementResolveResult field;
            if ((qualifier == null || PsiUtilKt.isThisExpression(qualifier)) && (field = (ElementResolveResult)CollectionsKt.singleOrNull((Iterable)GrReferenceResolveRunnerKt.resolveToField($receiver, name))) != null && GrReferenceResolveRunnerKt.checkCurrentClass((GrField)field.getElement(), $receiver)) {
                return field;
            }
            if (qualifier == null) {
                return GrReferenceResolveRunnerKt.resolveUnqualifiedType($receiver, name);
            }
            if (qualifier instanceof GrReferenceExpression) {
                return GrReferenceResolveRunnerKt.resolveQualifiedType($receiver, name, (GrReferenceExpression)qualifier);
            }
        }
        return null;
    }

    private static final Collection<ElementResolveResult<GrVariable>> resolveToLocalVariable(@NotNull PsiElement $receiver, String name) {
        return PsiTreeUtilKt.treeWalkUpAndGet($receiver, new LocalVariableProcessor(name));
    }

    private static final Collection<ElementResolveResult<GrField>> resolveToField(@NotNull PsiElement $receiver, String name) {
        return PsiTreeUtilKt.treeWalkUpAndGet($receiver, new CodeFieldProcessor(name, $receiver));
    }

    private static final boolean checkCurrentClass(GrField field, PsiElement place) {
        PsiClass psiClass = field.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"field.containingClass ?: return false");
        PsiClass containingClass = psiClass;
        return Intrinsics.areEqual((Object)containingClass, (Object)OwnerKt.getOwner(place));
    }

    private static final ClassResolveResult resolveUnqualifiedType(@NotNull PsiElement $receiver, String name) {
        ReferenceExpressionClassProcessor processor = new ReferenceExpressionClassProcessor(name, $receiver);
        PsiScopeProcessor psiScopeProcessor = processor;
        ResolveState resolveState = ResolveState.initial();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"ResolveState.initial()");
        GrCodeReferenceResolverKt.processUnqualified($receiver, psiScopeProcessor, resolveState);
        return (ClassResolveResult)processor.getResult();
    }

    private static final ClassResolveResult resolveQualifiedType(@NotNull PsiElement $receiver, String name, GrReferenceExpression qualifier) {
        GroovyResolveResult groovyResolveResult = GrReferenceResolveRunnerKt.resolveStatic(qualifier);
        Object object = groovyResolveResult != null ? groovyResolveResult.getElement() : null;
        if (!(object instanceof PsiClass)) {
            object = null;
        }
        PsiClass psiClass = (PsiClass)object;
        if (psiClass == null) {
            return null;
        }
        PsiClass classQualifier = psiClass;
        ReferenceExpressionClassProcessor processor = new ReferenceExpressionClassProcessor(name, $receiver);
        classQualifier.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, $receiver);
        return (ClassResolveResult)processor.getResult();
    }

    @Nullable
    public static final /* synthetic */ GroovyResolveResult access$doResolveStatic(@NotNull GrReferenceExpression $receiver) {
        return GrReferenceResolveRunnerKt.doResolveStatic($receiver);
    }
}

