/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.light.JavaIdentifier;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.extensions.GroovyApplicabilityProvider;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.EmptyGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrPropertySelection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrBuilderMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrNamedArgumentsOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyCommonClassNames;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;

public class PsiUtil {
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil");
    public static final Key<JavaIdentifier> NAME_IDENTIFIER = new Key("Java Identifier");
    public static final Set<String> OPERATOR_METHOD_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"plus", "minus", "multiply", "power", "div", "mod", "or", "and", "xor", "next", "previous", "getAt", "putAt", "leftShift", "rightShift", "isCase", "bitwiseNegate", "negative", "positive", "call"});
    private static final String[] visibilityModifiers = new String[]{"private", "protected", "public"};

    private PsiUtil() {
    }

    @Nullable
    public static String getMethodName(GrMethodCall methodCall) {
        GrExpression invokedExpression = methodCall.getInvokedExpression();
        if (!(invokedExpression instanceof GrReferenceExpression)) {
            return null;
        }
        return ((GrReferenceExpression)invokedExpression).getReferenceName();
    }

    @Nullable
    public static String getUnqualifiedMethodName(GrMethodCall methodCall) {
        GrExpression invokedExpression = methodCall.getInvokedExpression();
        if (!(invokedExpression instanceof GrReferenceExpression)) {
            return null;
        }
        if (((GrReferenceExpression)invokedExpression).isQualified()) {
            return null;
        }
        return ((GrReferenceExpression)invokedExpression).getReferenceName();
    }

    @Nullable
    public static String getQualifiedReferenceText(GrCodeReferenceElement referenceElement) {
        StringBuilder builder = new StringBuilder();
        if (!PsiUtil.appendName(referenceElement, builder)) {
            return null;
        }
        return builder.toString();
    }

    private static boolean appendName(GrCodeReferenceElement referenceElement, StringBuilder builder) {
        String refName = referenceElement.getReferenceName();
        if (refName == null) {
            return false;
        }
        GrCodeReferenceElement qualifier = (GrCodeReferenceElement)referenceElement.getQualifier();
        if (qualifier != null) {
            PsiUtil.appendName(qualifier, builder);
            builder.append(".");
        }
        builder.append(refName);
        return true;
    }

    public static boolean isLValue(GroovyPsiElement element) {
        if (element instanceof GrExpression) {
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{GrParenthesizedExpression.class});
            if (parent instanceof GrTuple) {
                return true;
            }
            return parent instanceof GrAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)((GrAssignmentExpression)parent).getLValue(), (PsiElement)element, (boolean)false);
        }
        return false;
    }

    public static boolean isLValueOfOperatorAssignment(@NotNull GrReferenceExpression element) {
        PsiElement parent;
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(0);
        }
        return (parent = PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{GrParenthesizedExpression.class})) instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent).isOperatorAssignment() && PsiTreeUtil.isAncestor((PsiElement)((GrAssignmentExpression)parent).getLValue(), (PsiElement)element, (boolean)false);
    }

    public static boolean isApplicable(@Nullable PsiType[] argumentTypes, @NotNull PsiMethod method, PsiSubstitutor substitutor, PsiElement place, boolean eraseParameterTypes) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(1);
        }
        return PsiUtil.isApplicableConcrete(argumentTypes, method, substitutor, place, eraseParameterTypes) != GrClosureSignatureUtil.ApplicabilityResult.inapplicable;
    }

    public static GrClosureSignatureUtil.ApplicabilityResult isApplicableConcrete(@Nullable PsiType[] argumentTypes, @NotNull PsiMethod method, PsiSubstitutor substitutor, PsiElement place, boolean eraseParameterTypes) {
        PsiParameter[] parameters;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(2);
        }
        if (argumentTypes == null) {
            return GrClosureSignatureUtil.ApplicabilityResult.canBeApplicable;
        }
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature(method, substitutor, eraseParameterTypes);
        GrClosureSignatureUtil.ApplicabilityResult result2 = GroovyApplicabilityProvider.checkProviders(argumentTypes, method, substitutor, place, eraseParameterTypes);
        if (result2 != null) {
            return result2;
        }
        result2 = GrClosureSignatureUtil.isSignatureApplicableConcrete(signature, argumentTypes, place);
        if (result2 != GrClosureSignatureUtil.ApplicabilityResult.inapplicable && GenericsUtil.isTypeArgumentsApplicable((PsiTypeParameter[])method.getTypeParameters(), (PsiSubstitutor)substitutor, (PsiElement)place)) {
            return result2;
        }
        if (method instanceof GrBuilderMethod && !((GrBuilderMethod)method).hasObligatoryNamedArguments() && (parameters = method.getParameterList().getParameters()).length > 0 && parameters[0].getType() instanceof GrMapType && (argumentTypes.length == 0 || !(argumentTypes[0] instanceof GrMapType))) {
            return GrClosureSignatureUtil.isSignatureApplicableConcrete(GrClosureSignatureUtil.removeParam(signature, 0), argumentTypes, place);
        }
        return GrClosureSignatureUtil.ApplicabilityResult.inapplicable;
    }

    public static boolean isApplicable(@Nullable PsiType[] argumentTypes, GrClosureType type, GroovyPsiElement context) {
        return PsiUtil.isApplicableConcrete(argumentTypes, type, context) != GrClosureSignatureUtil.ApplicabilityResult.inapplicable;
    }

    public static GrClosureSignatureUtil.ApplicabilityResult isApplicableConcrete(@Nullable PsiType[] argumentTypes, GrClosureType type, GroovyPsiElement context) {
        if (argumentTypes == null) {
            return GrClosureSignatureUtil.ApplicabilityResult.canBeApplicable;
        }
        GrSignature signature = type.getSignature();
        return GrClosureSignatureUtil.isSignatureApplicableConcrete(signature, argumentTypes, context);
    }

    @Nullable
    public static GrArgumentList getArgumentsList(@Nullable PsiElement methodRef) {
        if (methodRef == null) {
            return null;
        }
        if (methodRef instanceof GrEnumConstant) {
            return ((GrEnumConstant)methodRef).getArgumentList();
        }
        PsiElement parent = methodRef.getParent();
        if (parent instanceof GrCall) {
            return ((GrCall)parent).getArgumentList();
        }
        if (parent instanceof GrAnonymousClassDefinition) {
            return ((GrAnonymousClassDefinition)parent).getArgumentListGroovy();
        }
        return null;
    }

    @Nullable
    public static PsiType[] getArgumentTypes(@Nullable PsiElement place, boolean nullAsBottom) {
        return PsiUtil.getArgumentTypes(place, nullAsBottom, null);
    }

    @Nullable
    public static PsiType[] getArgumentTypes(@Nullable PsiElement place, boolean nullAsBottom, @Nullable GrExpression stopAt) {
        PsiElement parent;
        Object object = place instanceof GrEnumConstant ? place : (parent = place != null ? place.getParent() : null);
        if (parent instanceof GrIndexProperty) {
            GrIndexProperty index = (GrIndexProperty)parent;
            GrArgumentList list = index.getArgumentList();
            Object[] argTypes = PsiUtil.getArgumentTypes(list.getNamedArguments(), list.getExpressionArguments(), GrClosableBlock.EMPTY_ARRAY, nullAsBottom, stopAt);
            if (PsiUtil.isLValue(index) && argTypes != null) {
                PsiType rawInitializer = TypeInferenceHelper.getInitializerTypeFor(index);
                PsiType initializer = PsiUtil.notNullizeType(rawInitializer, nullAsBottom, index);
                return (PsiType[])ArrayUtil.append((Object[])argTypes, (Object)initializer);
            }
            return argTypes;
        }
        if (parent instanceof GrCall) {
            GrCall call = (GrCall)parent;
            GrNamedArgument[] namedArgs = call.getNamedArguments();
            GrExpression[] expressions = call.getExpressionArguments();
            GrClosableBlock[] closures = call.getClosureArguments();
            return PsiUtil.getArgumentTypes(namedArgs, expressions, closures, nullAsBottom, stopAt);
        }
        if (parent instanceof GrAnonymousClassDefinition) {
            GrArgumentList argList = ((GrAnonymousClassDefinition)parent).getArgumentListGroovy();
            if (argList == null) {
                return PsiUtil.getArgumentTypes(GrNamedArgument.EMPTY_ARRAY, GrExpression.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, nullAsBottom, stopAt);
            }
            return PsiUtil.getArgumentTypes(argList.getNamedArguments(), argList.getExpressionArguments(), GrClosableBlock.EMPTY_ARRAY, nullAsBottom, stopAt);
        }
        if (parent instanceof GrBinaryExpression) {
            GrExpression right = ((GrBinaryExpression)parent).getRightOperand();
            PsiType type = right != null ? right.getType() : null;
            return new PsiType[]{PsiUtil.notNullizeType(type, nullAsBottom, parent)};
        }
        if (parent instanceof GrAssignmentExpression) {
            PsiType type = ((GrAssignmentExpression)parent).getType();
            return new PsiType[]{PsiUtil.notNullizeType(type, nullAsBottom, parent)};
        }
        return null;
    }

    @Contract(value="_, false, _ -> !null; !null, _, _ -> !null; null, true, _ -> null")
    private static PsiType notNullizeType(PsiType type, boolean acceptNull, PsiElement context) {
        return type != null || acceptNull ? type : TypesUtil.getJavaLangObject(context);
    }

    @Nullable
    public static PsiType[] getArgumentTypes(GrArgumentList argList) {
        return PsiUtil.getArgumentTypes(argList, false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static PsiType[] getArgumentTypes(@NotNull GrNamedArgument[] namedArgs, @NotNull GrExpression[] expressions, @NotNull GrClosableBlock[] closures, boolean nullAsBottom, @Nullable GrExpression stopAt) {
        if (namedArgs == null) {
            PsiUtil.$$$reportNull$$$0(3);
        }
        if (expressions == null) {
            PsiUtil.$$$reportNull$$$0(4);
        }
        if (closures == null) {
            PsiUtil.$$$reportNull$$$0(5);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        if (namedArgs.length > 0) {
            GrNamedArgument context = namedArgs[0];
            result2.add((Object)GrMapType.createFromNamedArgs(context, namedArgs));
        }
        for (GrExpression grExpression : expressions) {
            PsiType type = grExpression.getType();
            if (grExpression instanceof GrSpreadArgument) {
                if (!(type instanceof GrTupleType)) return null;
                result2.addAll(Arrays.asList(((GrTupleType)type).getComponentTypes()));
            } else if (type == null) {
                result2.add(nullAsBottom ? null : TypesUtil.getJavaLangObject(grExpression));
            } else {
                if (stopAt == grExpression) {
                    type = TypeConversionUtil.erasure((PsiType)type);
                }
                result2.add(type);
            }
            if (stopAt != grExpression) continue;
            return result2.toArray(PsiType.createArray((int)result2.size()));
        }
        for (GrExpression grExpression : closures) {
            PsiType closureType = grExpression.getType();
            if (closureType != null) {
                if (stopAt == grExpression) {
                    closureType = TypeConversionUtil.erasure((PsiType)closureType);
                }
                result2.add(PsiUtil.notNullizeType(closureType, nullAsBottom, grExpression));
            }
            if (stopAt == grExpression) return result2.toArray(PsiType.createArray((int)result2.size()));
        }
        return result2.toArray(PsiType.createArray((int)result2.size()));
    }

    @Nullable
    public static PsiClass getJavaLangClass(PsiElement resolved, GlobalSearchScope scope) {
        return JavaPsiFacade.getInstance((Project)resolved.getProject()).findClass("java.lang.Class", scope);
    }

    public static boolean isValidReferenceName(@NotNull String text) {
        if (text == null) {
            PsiUtil.$$$reportNull$$$0(6);
        }
        GroovyLexer lexer = new GroovyLexer();
        lexer.start(text);
        return TokenSets.REFERENCE_NAMES_WITHOUT_NUMBERS.contains(lexer.getTokenType()) && lexer.getTokenEnd() == text.length();
    }

    public static boolean isAccessible(@NotNull PsiElement place, @NotNull PsiMember member) {
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(7);
        }
        if (member == null) {
            PsiUtil.$$$reportNull$$$0(8);
        }
        if (member instanceof LightElement) {
            return true;
        }
        if (place instanceof GrReferenceExpression && ((GrReferenceExpression)place).getQualifierExpression() == null && member.getContainingClass() instanceof GroovyScriptClass) {
            return true;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)place, GrDocComment.class) != null) {
            return true;
        }
        return com.intellij.psi.util.PsiUtil.isAccessible((PsiMember)member, (PsiElement)place, null);
    }

    public static void reformatCode(PsiElement element) {
        TextRange textRange = element.getTextRange();
        PsiFile file = element.getContainingFile();
        FileViewProvider viewProvider = file.getViewProvider();
        if (viewProvider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            MultiplePsiFilesPerDocumentFileViewProvider multiProvider = (MultiplePsiFilesPerDocumentFileViewProvider)viewProvider;
            file = multiProvider.getPsi(multiProvider.getBaseLanguage());
            LOG.assertTrue(file != null, (Object)(element + " " + multiProvider.getBaseLanguage()));
        }
        try {
            CodeStyleManager.getInstance((Project)element.getProject()).reformatText(file, textRange.getStartOffset(), textRange.getEndOffset());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static Iterable<PsiClass> iterateSupers(final @NotNull PsiClass psiClass, final boolean includeSelf) {
        if (psiClass == null) {
            PsiUtil.$$$reportNull$$$0(9);
        }
        return new Iterable<PsiClass>(){

            @Override
            public Iterator<PsiClass> iterator() {
                return new Iterator<PsiClass>(){
                    TIntStack indices = new TIntStack();
                    Stack<PsiClassType[]> superTypesStack = new Stack();
                    PsiClass current;
                    boolean nextObtained;
                    Set<PsiClass> visited = new HashSet<PsiClass>();
                    {
                        if (includeSelf) {
                            this.current = psiClass;
                            this.nextObtained = true;
                        } else {
                            this.current = null;
                            this.nextObtained = false;
                        }
                        this.pushSuper(psiClass);
                    }

                    @Override
                    public boolean hasNext() {
                        this.nextElement();
                        return this.current != null;
                    }

                    private void nextElement() {
                        if (this.nextObtained) {
                            return;
                        }
                        this.nextObtained = true;
                        while (!this.superTypesStack.empty()) {
                            assert (this.indices.size() > 0);
                            PsiClassType[] superTypes = this.superTypesStack.peek();
                            for (int i = this.indices.pop(); i < superTypes.length; ++i) {
                                PsiClass clazz = superTypes[i].resolve();
                                if (clazz == null || this.visited.contains(clazz)) continue;
                                this.current = clazz;
                                this.visited.add(clazz);
                                this.indices.push(i + 1);
                                this.pushSuper(clazz);
                                return;
                            }
                            this.superTypesStack.pop();
                        }
                        this.current = null;
                    }

                    private void pushSuper(PsiClass clazz) {
                        this.superTypesStack.push(clazz.getSuperTypes());
                        this.indices.push(0);
                    }

                    @Override
                    @NotNull
                    public PsiClass next() {
                        this.nextElement();
                        this.nextObtained = false;
                        if (this.current == null) {
                            throw new NoSuchElementException();
                        }
                        PsiClass psiClass = this.current;
                        if (psiClass == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return psiClass;
                    }

                    @Override
                    public void remove() {
                        throw new IllegalStateException("should not be called");
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/PsiUtil$1$1", "next"));
                    }
                };
            }
        };
    }

    @Nullable
    public static PsiClass getContextClass(@Nullable PsiElement context) {
        while (context != null) {
            if (context instanceof PsiClass && !PsiUtil.isInDummyFile(context)) {
                return (PsiClass)context;
            }
            if (context instanceof GroovyFileBase && !PsiUtil.isInDummyFile(context)) {
                return ((GroovyFileBase)context).getScriptClass();
            }
            context = context.getContext();
        }
        return null;
    }

    public static boolean isInDummyFile(@NotNull PsiElement context) {
        PsiFile file;
        if (context == null) {
            PsiUtil.$$$reportNull$$$0(10);
        }
        if ((file = context.getContainingFile()) == null) {
            return false;
        }
        String name = file.getName();
        return name.startsWith("DUMMY__1234567890_DUMMYYYYYY___");
    }

    @Nullable
    public static GroovyPsiElement getFileOrClassContext(PsiElement context) {
        while (context != null) {
            if (context instanceof GrTypeDefinition) {
                return (GroovyPsiElement)context;
            }
            if (context instanceof GroovyFileBase && context.isPhysical()) {
                return (GroovyPsiElement)context;
            }
            context = context.getContext();
        }
        return null;
    }

    public static boolean mightBeLValue(@Nullable GrExpression expr) {
        if (expr instanceof GrParenthesizedExpression) {
            return PsiUtil.mightBeLValue(((GrParenthesizedExpression)expr).getOperand());
        }
        if (expr instanceof GrTuple || expr instanceof GrReferenceExpression || expr instanceof GrIndexProperty || expr instanceof GrPropertySelection) {
            return true;
        }
        return PsiUtil.isThisOrSuperRef(expr) && GroovyConfigUtils.getInstance().isVersionAtLeast(expr, "1.8");
    }

    public static boolean isRawMethodCall(GrMethodCallExpression call) {
        GrExpression expression;
        PsiType type;
        GroovyResolveResult result2 = call.advancedResolve();
        PsiElement element = result2.getElement();
        if (element == null) {
            return false;
        }
        if (element instanceof PsiMethod) {
            PsiType returnType = PsiUtil.getSmartReturnType((PsiMethod)element);
            GrExpression expression2 = call.getInvokedExpression();
            if (expression2 instanceof GrReferenceExpression && result2.isInvokedOnProperty()) {
                if (returnType instanceof GrClosureType) {
                    return PsiUtil.isRawClosureCall(call, result2, (GrClosureType)returnType);
                }
            } else {
                return PsiUtil.isRawType(returnType, result2.getSubstitutor());
            }
        }
        if (element instanceof PsiVariable && (type = (expression = call.getInvokedExpression()).getType()) instanceof GrClosureType) {
            return PsiUtil.isRawClosureCall(call, result2, (GrClosureType)type);
        }
        return false;
    }

    private static boolean isRawClosureCall(GrMethodCallExpression call, GroovyResolveResult result2, GrClosureType returnType) {
        GrClosureSignature _signature;
        GrSignature signature = returnType.getSignature();
        if (signature instanceof GrClosureSignature) {
            _signature = (GrClosureSignature)signature;
        } else {
            PsiType[] types = PsiUtil.getArgumentTypes(call.getInvokedExpression(), true);
            Trinity<GrClosureSignature, GrClosureSignatureUtil.ArgInfo<PsiType>[], GrClosureSignatureUtil.ApplicabilityResult> resultTrinity = types != null ? GrClosureSignatureUtil.getApplicableSignature(signature, types, call) : null;
            GrClosureSignature grClosureSignature = _signature = resultTrinity != null ? (GrClosureSignature)resultTrinity.first : null;
        }
        if (_signature != null) {
            return PsiUtil.isRawType(_signature.getReturnType(), TypesUtil.composeSubstitutors(_signature.getSubstitutor(), result2.getSubstitutor()));
        }
        return false;
    }

    public static boolean isRawFieldAccess(GrReferenceExpression ref) {
        PsiElement element = null;
        GroovyResolveResult[] resolveResults = ref.multiResolve(false);
        if (resolveResults.length == 0) {
            return false;
        }
        GroovyResolveResult resolveResult = resolveResults[0];
        if (resolveResult != null) {
            element = resolveResult.getElement();
        }
        if (element instanceof PsiField) {
            return PsiUtil.isRawType(((PsiField)element).getType(), resolveResult.getSubstitutor());
        }
        if (element instanceof GrAccessorMethod) {
            return PsiUtil.isRawType(((GrAccessorMethod)element).getReturnType(), resolveResult.getSubstitutor());
        }
        return false;
    }

    private static boolean isRawIndexPropertyAccess(GrIndexProperty expr) {
        GrExpression qualifier = expr.getInvokedExpression();
        PsiType qualifierType = qualifier.getType();
        if (qualifierType instanceof PsiClassType) {
            PsiElement element;
            if (InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.List")) {
                return com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)qualifierType, (boolean)false) == null;
            }
            if (InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.Map")) {
                return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)qualifierType, (String)"java.util.Map", (int)1, (boolean)false) == null;
            }
            PsiClassType classType = (PsiClassType)qualifierType;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            GrExpression[] arguments = expr.getArgumentList().getExpressionArguments();
            PsiType[] argTypes = PsiType.createArray((int)arguments.length);
            for (int i = 0; i < arguments.length; ++i) {
                PsiType argType = arguments[i].getType();
                if (argType == null) {
                    argType = TypesUtil.getJavaLangObject(expr);
                }
                argTypes[i] = argType;
            }
            MethodResolverProcessor processor = new MethodResolverProcessor("getAt", expr, false, qualifierType, argTypes, PsiType.EMPTY_ARRAY);
            PsiClass qClass = resolveResult.getElement();
            ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)PsiSubstitutor.EMPTY);
            if (qClass != null) {
                qClass.processDeclarations((PsiScopeProcessor)processor, state, null, (PsiElement)expr);
            }
            ResolveUtil.processNonCodeMembers(qualifierType, processor, qualifier, state);
            GroovyResolveResult[] candidates = processor.getCandidates();
            PsiType type = null;
            if (candidates.length == 1 && (element = candidates[0].getElement()) instanceof PsiMethod) {
                type = PsiUtil.getSmartReturnType((PsiMethod)element);
            }
            return PsiUtil.isRawType(type, resolveResult.getSubstitutor());
        }
        return false;
    }

    public static boolean isRawClassMemberAccess(GrExpression expr) {
        if ((expr = (GrExpression)PsiUtil.skipParentheses(expr, false)) instanceof GrMethodCallExpression) {
            return PsiUtil.isRawMethodCall((GrMethodCallExpression)expr);
        }
        if (expr instanceof GrReferenceExpression) {
            return PsiUtil.isRawFieldAccess((GrReferenceExpression)expr);
        }
        if (expr instanceof GrIndexProperty) {
            return PsiUtil.isRawIndexPropertyAccess((GrIndexProperty)expr);
        }
        return false;
    }

    public static boolean isRawType(@Nullable PsiType type, @NotNull PsiSubstitutor substitutor) {
        PsiClass returnClass;
        if (substitutor == null) {
            PsiUtil.$$$reportNull$$$0(11);
        }
        if (type instanceof PsiClassType && (returnClass = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)returnClass;
            return substitutor.substitute(typeParameter) == null;
        }
        return false;
    }

    public static boolean isWhiteSpaceOrLineFeed(PsiElement element) {
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        IElementType elementType = node.getElementType();
        return elementType == GroovyTokenTypes.mNLS || elementType == TokenType.WHITE_SPACE;
    }

    public static boolean isNewLine(PsiElement element) {
        return PsiUtil.isWhiteSpaceOrLineFeed(element) && element.getText().contains("\n");
    }

    @Nullable
    public static PsiElement getPrevNonSpace(@NotNull PsiElement elem) {
        if (elem == null) {
            PsiUtil.$$$reportNull$$$0(12);
        }
        PsiElement prevSibling = elem.getPrevSibling();
        while (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        return prevSibling;
    }

    @Nullable
    public static PsiElement getNextNonSpace(PsiElement elem) {
        PsiElement nextSibling = elem.getNextSibling();
        while (nextSibling instanceof PsiWhiteSpace) {
            nextSibling = nextSibling.getNextSibling();
        }
        return nextSibling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static PsiIdentifier getJavaNameIdentifier(@NotNull GrNamedElement namedElement) {
        PsiElement element;
        JavaIdentifier identifier;
        if (namedElement == null) {
            PsiUtil.$$$reportNull$$$0(13);
        }
        if ((identifier = (JavaIdentifier)(element = namedElement.getNameIdentifierGroovy()).getUserData(NAME_IDENTIFIER)) == null) {
            PsiElement psiElement = element;
            synchronized (psiElement) {
                identifier = (JavaIdentifier)element.getUserData(NAME_IDENTIFIER);
                if (identifier != null) {
                    JavaIdentifier javaIdentifier = identifier;
                    // MONITOREXIT @DISABLED, blocks:[2, 5, 6] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (javaIdentifier == null) {
                        PsiUtil.$$$reportNull$$$0(14);
                    }
                    return javaIdentifier;
                }
                identifier = new JavaIdentifier(element.getManager(), element);
                element.putUserData(NAME_IDENTIFIER, (Object)identifier);
            }
        }
        JavaIdentifier javaIdentifier = identifier;
        if (javaIdentifier == null) {
            PsiUtil.$$$reportNull$$$0(15);
        }
        return javaIdentifier;
    }

    @Nullable
    public static GrStatement findEnclosingStatement(@Nullable PsiElement context) {
        while (context != null) {
            if (PsiUtil.isExpressionStatement(context)) {
                return (GrStatement)context;
            }
            context = PsiTreeUtil.getParentOfType((PsiElement)context, GrStatement.class, (boolean)true);
        }
        return null;
    }

    public static boolean isMethodCall(GrMethodCall call, String methodName) {
        GrExpression expression = call.getInvokedExpression();
        return expression instanceof GrReferenceExpression && methodName.equals(expression.getText().trim());
    }

    public static boolean hasEnclosingInstanceInScope(@NotNull PsiClass clazz, @Nullable PsiElement scope, boolean isSuperClassAccepted) {
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(16);
        }
        return PsiUtil.findEnclosingInstanceClassInScope(clazz, scope, isSuperClassAccepted) != null;
    }

    public static PsiClass findEnclosingInstanceClassInScope(@NotNull PsiClass clazz, @Nullable PsiElement scope, boolean isInheritorOfClazzAccepted) {
        PsiElement place;
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(17);
        }
        for (place = scope; !(place == null || place == clazz || place instanceof PsiFile && place.isPhysical()); place = place.getContext()) {
            if (place instanceof PsiClass && (isInheritorOfClazzAccepted ? InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)place), (PsiClass)clazz, (boolean)true) : clazz.getManager().areElementsEquivalent(place, (PsiElement)clazz))) {
                return (PsiClass)place;
            }
            if (!(place instanceof PsiModifierListOwner) || !((PsiModifierListOwner)place).hasModifierProperty("static")) continue;
            return null;
        }
        if (clazz instanceof GroovyScriptClass && place == clazz.getContainingFile() || place == clazz) {
            return clazz;
        }
        return null;
    }

    @Nullable
    public static PsiElement skipWhitespacesAndComments(@Nullable PsiElement elem, boolean forward, boolean skipNLs) {
        return PsiUtil.skipSet(elem, forward, TokenSets.WHITE_SPACES_OR_COMMENTS, skipNLs);
    }

    @Nullable
    public static PsiElement skipWhitespacesAndComments(@Nullable PsiElement elem, boolean forward) {
        return PsiUtil.skipSet(elem, forward, TokenSets.WHITE_SPACES_OR_COMMENTS, true);
    }

    @Nullable
    public static PsiElement skipSet(PsiElement elem, boolean forward, TokenSet set, boolean skipNLs) {
        while (elem != null && elem.getNode() != null && set.contains(elem.getNode().getElementType()) && (skipNLs || elem.getText().indexOf(10) == -1)) {
            if (forward) {
                elem = elem.getNextSibling();
                continue;
            }
            elem = elem.getPrevSibling();
        }
        return elem;
    }

    @Nullable
    public static PsiElement skipSet(@NotNull PsiElement element, boolean forward, @NotNull TokenSet set) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(18);
        }
        if (set == null) {
            PsiUtil.$$$reportNull$$$0(19);
        }
        while ((element = forward ? element.getNextSibling() : element.getPrevSibling()) != null && element.getNode() != null && set.contains(element.getNode().getElementType())) {
        }
        return element;
    }

    @Nullable
    public static PsiElement skipWhitespaces(@Nullable PsiElement elem, boolean forward) {
        return PsiUtil.skipSet(elem, forward, TokenSets.WHITE_SPACES_SET, true);
    }

    @Nullable
    public static PsiType getSmartReturnType(@NotNull PsiMethod method) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(20);
        }
        if (method instanceof GrMethod) {
            return ((GrMethod)method).getInferredReturnType();
        }
        if (method instanceof GrAccessorMethod) {
            return ((GrAccessorMethod)method).getInferredReturnType();
        }
        if (method instanceof GrGdkMethod) {
            return PsiUtil.getSmartReturnType(((GrGdkMethod)method).getStaticMethod());
        }
        return method.getReturnType();
    }

    public static boolean isClosurePropertyGetter(PsiMethod method) {
        PsiType type;
        PsiModifierList modifiers;
        String methodName = method.getName();
        return methodName.startsWith("get") && GroovyPropertyUtils.isGetterName(methodName) && !(modifiers = method.getModifierList()).hasModifierProperty("static") && !modifiers.hasModifierProperty("private") && !modifiers.hasModifierProperty("protected") && method.getParameterList().isEmpty() && (type = PsiUtil.getSmartReturnType(method)) != null && (TypesUtil.isClassType(type, "java.lang.Object") || TypesUtil.isClassType(type, "groovy.lang.Closure"));
    }

    public static boolean isMethodUsage(PsiElement element) {
        if (element instanceof GrEnumConstant) {
            return true;
        }
        if (!(element instanceof GrReferenceElement)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof GrCall) {
            return true;
        }
        if (parent instanceof GrAnonymousClassDefinition) {
            return element.equals(((GrAnonymousClassDefinition)parent).getBaseClassReferenceGroovy());
        }
        return false;
    }

    @NotNull
    public static GroovyResolveResult[] getConstructorCandidates(@NotNull PsiElement place, @NotNull GroovyResolveResult classCandidate, @Nullable PsiType[] argTypes) {
        PsiElement element;
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(21);
        }
        if (classCandidate == null) {
            PsiUtil.$$$reportNull$$$0(22);
        }
        if (!((element = classCandidate.getElement()) instanceof PsiClass)) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                PsiUtil.$$$reportNull$$$0(23);
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        PsiClass clazz = (PsiClass)element;
        PsiSubstitutor substitutor = classCandidate.getSubstitutor();
        GroovyResolveResult[] groovyResolveResultArray = ResolveUtil.getAllClassConstructors(clazz, substitutor, argTypes, place);
        if (groovyResolveResultArray == null) {
            PsiUtil.$$$reportNull$$$0(24);
        }
        return groovyResolveResultArray;
    }

    public static boolean isAccessedForReading(GrExpression expr) {
        return !PsiUtil.isLValue(expr);
    }

    public static boolean isAccessedForWriting(GrExpression expr) {
        return PsiUtil.isLValue(expr) || PsiUtil.isUsedInIncOrDec(expr);
    }

    public static boolean isUsedInIncOrDec(GrExpression expr) {
        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{GrParenthesizedExpression.class});
        if (parent instanceof GrUnaryExpression) {
            IElementType tokenType = ((GrUnaryExpression)parent).getOperationTokenType();
            return tokenType == GroovyTokenTypes.mINC || tokenType == GroovyTokenTypes.mDEC;
        }
        return false;
    }

    public static GrReferenceExpression qualifyMemberReference(GrReferenceExpression refExpr, PsiMember member, String name) {
        PsiElement replaced;
        assert (refExpr.getQualifierExpression() == null);
        PsiClass clazz = member.getContainingClass();
        assert (clazz != null);
        if (member.hasModifierProperty("static")) {
            GrReferenceExpression newRefExpr = GroovyPsiElementFactory.getInstance(member.getProject()).createReferenceExpressionFromText(clazz.getQualifiedName() + "." + name);
            replaced = refExpr.replace(newRefExpr);
        } else {
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiClass.class);
            if (member.getManager().areElementsEquivalent((PsiElement)containingClass, (PsiElement)clazz)) {
                GrReferenceExpression newRefExpr = GroovyPsiElementFactory.getInstance(member.getProject()).createReferenceExpressionFromText("this." + name);
                replaced = refExpr.replace(newRefExpr);
            } else {
                GrReferenceExpression newRefExpr = GroovyPsiElementFactory.getInstance(member.getProject()).createReferenceExpressionFromText(clazz.getName() + ".this." + name);
                replaced = refExpr.replace(newRefExpr);
            }
        }
        return (GrReferenceExpression)replaced;
    }

    public static GroovyResolveResult[] getConstructorCandidates(PsiClassType classType, PsiType[] argTypes, GroovyPsiElement context) {
        PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (psiClass == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult grResult = resolveResult instanceof GroovyResolveResult ? (GroovyResolveResult)resolveResult : new GroovyResolveResultImpl((PsiElement)psiClass, context, null, substitutor, true, true);
        return PsiUtil.getConstructorCandidates(context, grResult, argTypes);
    }

    @Nullable
    public static PsiElement skipParentheses(@Nullable PsiElement element, boolean up) {
        if (element == null) {
            return null;
        }
        if (up) {
            PsiElement parent;
            while ((parent = element.getParent()) instanceof GrParenthesizedExpression) {
                element = parent;
            }
            return element;
        }
        while (element instanceof GrParenthesizedExpression) {
            element = ((GrParenthesizedExpression)element).getOperand();
        }
        return element;
    }

    @NotNull
    public static PsiElement skipParenthesesIfSensibly(@NotNull PsiElement element, boolean up) {
        PsiElement res;
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(25);
        }
        PsiElement psiElement = (res = PsiUtil.skipParentheses(element, up)) == null ? element : res;
        if (psiElement == null) {
            PsiUtil.$$$reportNull$$$0(26);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement getNamedArgumentValue(GrNamedArgument otherNamedArgument, String argumentName) {
        PsiElement parent = otherNamedArgument.getParent();
        if (!(parent instanceof GrNamedArgumentsOwner)) {
            return null;
        }
        GrNamedArgument namedArgument = ((GrNamedArgumentsOwner)parent).findNamedArgument(argumentName);
        if (namedArgument == null) {
            return null;
        }
        return namedArgument.getExpression();
    }

    @NotNull
    public static PsiClass getOriginalClass(@NotNull PsiClass aClass) {
        PsiFile file;
        if (aClass == null) {
            PsiUtil.$$$reportNull$$$0(27);
        }
        if ((file = aClass.getContainingFile()) == null) {
            PsiClass psiClass = aClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(28);
            }
            return psiClass;
        }
        PsiFile originalFile = file.getOriginalFile();
        if (originalFile == file) {
            PsiClass psiClass = aClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(29);
            }
            return psiClass;
        }
        if (!(originalFile instanceof PsiClassOwner)) {
            PsiClass psiClass = aClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(30);
            }
            return psiClass;
        }
        String name = aClass.getName();
        if (name == null) {
            PsiClass psiClass = aClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(31);
            }
            return psiClass;
        }
        for (PsiClass originalClass : ((PsiClassOwner)originalFile).getClasses()) {
            if (!name.equals(originalClass.getName())) continue;
            PsiClass psiClass = originalClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(32);
            }
            return psiClass;
        }
        PsiClass psiClass = aClass;
        if (psiClass == null) {
            PsiUtil.$$$reportNull$$$0(33);
        }
        return psiClass;
    }

    public static void escalateVisibility(PsiMember owner, PsiElement place) {
        String modifier;
        int index;
        PsiModifierList modifierList = owner.getModifierList();
        LOG.assertTrue(modifierList != null);
        String visibilityModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierList);
        for (index = 0; index < visibilityModifiers.length && !(modifier = visibilityModifiers[index]).equals(visibilityModifier); ++index) {
        }
        while (index < visibilityModifiers.length && !PsiUtil.isAccessible(place, owner)) {
            modifier = visibilityModifiers[index];
            com.intellij.psi.util.PsiUtil.setModifierProperty((PsiModifierListOwner)owner, (String)modifier, (boolean)true);
            ++index;
        }
    }

    public static int getArgumentIndex(@NotNull GrCall call, @NotNull PsiElement argument) {
        GrArgumentList argumentList;
        if (call == null) {
            PsiUtil.$$$reportNull$$$0(34);
        }
        if (argument == null) {
            PsiUtil.$$$reportNull$$$0(35);
        }
        if ((argumentList = call.getArgumentList()) == null) {
            return -1;
        }
        GrExpression[] expressionArguments = argumentList.getExpressionArguments();
        for (int i = 0; i < expressionArguments.length; ++i) {
            if (!argument.equals(expressionArguments[i])) continue;
            int res = i;
            if (argumentList.getNamedArguments().length > 0) {
                ++res;
            }
            return res;
        }
        if (argument instanceof GrClosableBlock) {
            GrClosableBlock[] closureArgs = call.getClosureArguments();
            for (int i = 0; i < closureArgs.length; ++i) {
                if (!argument.equals(closureArgs[i])) continue;
                int res = i + expressionArguments.length;
                if (argumentList.getNamedArguments().length > 0) {
                    ++res;
                }
                return res;
            }
        }
        return -1;
    }

    public static GrExpression[] getAllArguments(@NotNull GrCall call) {
        GrArgumentList argumentList;
        if (call == null) {
            PsiUtil.$$$reportNull$$$0(36);
        }
        if ((argumentList = call.getArgumentList()) == null) {
            return GrExpression.EMPTY_ARRAY;
        }
        GrClosableBlock[] closureArguments = call.getClosureArguments();
        GrExpression[] expressionArguments = argumentList.getExpressionArguments();
        GrNamedArgument[] namedArguments = argumentList.getNamedArguments();
        int length = expressionArguments.length + closureArguments.length;
        int k = 0;
        if (namedArguments.length > 0) {
            ++length;
            k = 1;
        }
        GrExpression[] res = new GrExpression[length];
        for (GrExpression grExpression : expressionArguments) {
            res[k++] = grExpression;
        }
        for (GrExpression grExpression : closureArguments) {
            res[k++] = grExpression;
        }
        return res;
    }

    public static GrNamedArgument[] getFirstMapNamedArguments(@NotNull GrCall grCall) {
        GrNamedArgument[] res;
        if (grCall == null) {
            PsiUtil.$$$reportNull$$$0(37);
        }
        if ((res = grCall.getNamedArguments()).length > 0) {
            return res;
        }
        GrExpression[] arguments = grCall.getExpressionArguments();
        if (arguments.length == 0) {
            return GrNamedArgument.EMPTY_ARRAY;
        }
        GrExpression firstArg = arguments[0];
        if (!(firstArg instanceof GrListOrMap)) {
            return GrNamedArgument.EMPTY_ARRAY;
        }
        return ((GrListOrMap)firstArg).getNamedArguments();
    }

    public static boolean isExpressionStatement(@Nullable PsiElement expr) {
        if (!(expr instanceof GrStatement)) {
            return false;
        }
        PsiElement parent = expr.getParent();
        if (parent instanceof GrControlFlowOwner || parent instanceof GrCaseSection) {
            return true;
        }
        if (parent instanceof GrLabeledStatement) {
            return true;
        }
        if (parent instanceof GrIfStatement && (expr == ((GrIfStatement)parent).getThenBranch() || expr == ((GrIfStatement)parent).getElseBranch())) {
            return true;
        }
        return parent instanceof GrWhileStatement && expr == ((GrWhileStatement)parent).getBody();
    }

    @Nullable
    public static GrMethodCall getMethodCallByNamedParameter(GrNamedArgument namedArgument) {
        GrCall res = PsiUtil.getCallByNamedParameter(namedArgument);
        if (res instanceof GrMethodCall) {
            return (GrMethodCall)res;
        }
        return null;
    }

    @Nullable
    public static GrCall getCallByNamedParameter(GrNamedArgument namedArgument) {
        PsiElement eMethodCall;
        PsiElement parent = namedArgument.getParent();
        if (parent instanceof GrArgumentList) {
            eMethodCall = parent.getParent();
        } else {
            if (!(parent instanceof GrListOrMap)) {
                return null;
            }
            PsiElement eArgumentList = parent.getParent();
            if (!(eArgumentList instanceof GrArgumentList)) {
                return null;
            }
            GrArgumentList argumentList = (GrArgumentList)eArgumentList;
            if (argumentList.getNamedArguments().length > 0) {
                return null;
            }
            if (argumentList.getExpressionArgumentIndex((GrListOrMap)parent) != 0) {
                return null;
            }
            eMethodCall = eArgumentList.getParent();
        }
        if (!(eMethodCall instanceof GrCall)) {
            return null;
        }
        return (GrCall)eMethodCall;
    }

    public static String getAnnoAttributeValue(@NotNull PsiAnnotation annotation, String attributeName, String defaultValue) {
        Object o;
        PsiAnnotationMemberValue value;
        if (annotation == null) {
            PsiUtil.$$$reportNull$$$0(38);
        }
        if ((value = annotation.findAttributeValue(attributeName)) instanceof GrExpression && (o = GroovyConstantExpressionEvaluator.evaluate((GrExpression)value)) instanceof String) {
            return (String)o;
        }
        return defaultValue;
    }

    public static boolean getAnnoAttributeValue(@NotNull PsiAnnotation annotation, String attributeName, boolean defaultValue) {
        Object o;
        PsiAnnotationMemberValue value;
        if (annotation == null) {
            PsiUtil.$$$reportNull$$$0(39);
        }
        if ((value = annotation.findAttributeValue(attributeName)) instanceof GrExpression && (o = GroovyConstantExpressionEvaluator.evaluate((GrExpression)value)) instanceof Boolean) {
            return (Boolean)o;
        }
        return defaultValue;
    }

    public static boolean isExpressionUsed(PsiElement expr) {
        while (expr.getParent() instanceof GrParenthesizedExpression) {
            expr = expr.getParent();
        }
        PsiElement parent = expr.getParent();
        if (parent instanceof GrBinaryExpression || parent instanceof GrUnaryExpression || parent instanceof GrConditionalExpression || parent instanceof GrAssignmentExpression || parent instanceof GrInstanceOfExpression || parent instanceof GrSafeCastExpression || parent instanceof GrTuple || parent instanceof GrArgumentList || parent instanceof GrReturnStatement || parent instanceof GrAssertStatement || parent instanceof GrThrowStatement || parent instanceof GrSwitchStatement || parent instanceof GrVariable || parent instanceof GrWhileStatement) {
            return true;
        }
        if (parent instanceof GrReferenceExpression) {
            PsiElement resolved;
            if (ResolveUtil.isClassReference(parent)) {
                parent = parent.getParent();
            }
            if (parent instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)parent).resolve()) instanceof PsiMember) {
                PsiClass containingClass = ((PsiMember)resolved).getContainingClass();
                return containingClass != null && "java.lang.Class".equals(containingClass.getQualifiedName());
            }
            return true;
        }
        if (parent instanceof GrTraditionalForClause) {
            GrTraditionalForClause forClause = (GrTraditionalForClause)parent;
            return expr == forClause.getCondition();
        }
        return PsiUtil.isReturnStatement(expr);
    }

    public static boolean isReturnStatement(@NotNull PsiElement statement) {
        GrControlFlowOwner controlFlowOwner;
        if (statement == null) {
            PsiUtil.$$$reportNull$$$0(40);
        }
        if ((controlFlowOwner = ControlFlowUtils.findControlFlowOwner(statement)) instanceof GrOpenBlock) {
            PsiElement controlFlowOwnerParent = controlFlowOwner.getParent();
            if (controlFlowOwnerParent instanceof GrMethod && ((GrMethod)controlFlowOwnerParent).isConstructor()) {
                return false;
            }
            if (controlFlowOwnerParent instanceof PsiMethod && PsiType.VOID.equals((Object)((PsiMethod)controlFlowOwnerParent).getReturnType())) {
                return false;
            }
        }
        return ControlFlowUtils.collectReturns(controlFlowOwner, true).contains(statement);
    }

    @Nullable
    public static PsiClass getContainingNotInnerClass(@Nullable PsiElement element) {
        PsiClass domainClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (domainClass == null) {
            return null;
        }
        PsiClass c;
        while ((c = domainClass.getContainingClass()) != null) {
            domainClass = c;
        }
        return domainClass;
    }

    @NotNull
    public static ResolveResult getAccessObjectClass(GrExpression expression) {
        GroovyResolveResult resolveResult;
        if (PsiUtil.isThisOrSuperRef(expression)) {
            EmptyGroovyResolveResult emptyGroovyResolveResult = EmptyGroovyResolveResult.INSTANCE;
            if (emptyGroovyResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(41);
            }
            return emptyGroovyResolveResult;
        }
        PsiType type = expression.getType();
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)type).resolveGenerics();
            if (classResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(42);
            }
            return classResolveResult;
        }
        if (type == null && expression instanceof GrReferenceExpression && (resolveResult = ((GrReferenceExpression)expression).advancedResolve()).getElement() instanceof PsiClass) {
            GroovyResolveResult groovyResolveResult = resolveResult;
            if (groovyResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(43);
            }
            return groovyResolveResult;
        }
        EmptyGroovyResolveResult emptyGroovyResolveResult = EmptyGroovyResolveResult.INSTANCE;
        if (emptyGroovyResolveResult == null) {
            PsiUtil.$$$reportNull$$$0(44);
        }
        return emptyGroovyResolveResult;
    }

    public static boolean isReferenceWithoutQualifier(@Nullable PsiElement element, @NotNull String name) {
        if (name == null) {
            PsiUtil.$$$reportNull$$$0(45);
        }
        if (!(element instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression ref = (GrReferenceExpression)element;
        return !ref.isQualified() && name.equals(ref.getReferenceName());
    }

    public static boolean isProperty(@NotNull GrField field) {
        PsiClass clazz;
        if (field == null) {
            PsiUtil.$$$reportNull$$$0(46);
        }
        if ((clazz = field.getContainingClass()) == null) {
            return false;
        }
        if (clazz.isInterface() && !GrTraitUtil.isTrait(clazz)) {
            return false;
        }
        GrModifierList modifierList = field.getModifierList();
        return modifierList == null || !modifierList.hasExplicitVisibilityModifiers();
    }

    public static boolean isConstructorHasRequiredParameters(@NotNull PsiMethod constructor) {
        PsiParameter[] parameters;
        if (constructor == null) {
            PsiUtil.$$$reportNull$$$0(47);
        }
        LOG.assertTrue(constructor.isConstructor());
        for (PsiParameter parameter : parameters = constructor.getParameterList().getParameters()) {
            if (parameter instanceof GrParameter && ((GrParameter)parameter).isOptional()) continue;
            return true;
        }
        return false;
    }

    public static boolean isInMethodCallContext(PsiElement context) {
        return PsiUtil.getArgumentsList(context) != null;
    }

    @NotNull
    public static List<GrImportStatement> getValidImportStatements(GroovyFile file) {
        ArrayList<GrImportStatement> oldImports = new ArrayList<GrImportStatement>();
        for (GrImportStatement statement : file.getImportStatements()) {
            if (ErrorUtil.containsError(statement)) continue;
            oldImports.add(statement);
        }
        ArrayList<GrImportStatement> arrayList = oldImports;
        if (arrayList == null) {
            PsiUtil.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    public static boolean isCompileStatic(PsiElement e) {
        PsiMember containingMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)e, PsiMember.class, (boolean)false, (Class[])new Class[]{GrAnnotation.class});
        return containingMember != null && GroovyPsiManager.getInstance(containingMember.getProject()).isCompileStatic(containingMember);
    }

    @Nullable
    public static PsiType extractIteratedType(GrForInClause forIn) {
        GrExpression iterated = forIn.getIteratedExpression();
        if (iterated == null) {
            return null;
        }
        return ClosureParameterEnhancer.findTypeForIteration(iterated, (PsiElement)forIn);
    }

    public static boolean isThisReference(@Nullable PsiElement expression) {
        return PsiUtil.isThisOrSuperRef(expression, GroovyTokenTypes.kTHIS, false);
    }

    public static boolean isSuperReference(@Nullable PsiElement expression) {
        return PsiUtil.isThisOrSuperRef(expression, GroovyTokenTypes.kSUPER, true);
    }

    private static boolean isThisOrSuperRef(PsiElement expression, IElementType token, boolean superClassAccepted) {
        if (!(expression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression ref = (GrReferenceExpression)expression;
        PsiElement nameElement = ref.getReferenceNameElement();
        if (nameElement == null) {
            return false;
        }
        IElementType type = nameElement.getNode().getElementType();
        if (type != token) {
            return false;
        }
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier == null) {
            return true;
        }
        PsiElement resolved = ref.resolve();
        if (resolved instanceof PsiClass) {
            if (PsiUtil.hasEnclosingInstanceInScope((PsiClass)resolved, ref, superClassAccepted)) {
                return true;
            }
            if (superClassAccepted && GrTraitUtil.isTrait((PsiClass)resolved) && PsiUtil.scopeClassImplementsTrait((PsiClass)resolved, ref)) {
                return true;
            }
        }
        return false;
    }

    public static boolean scopeClassImplementsTrait(@NotNull PsiClass trait, @NotNull PsiElement place) {
        GrTypeDefinition scopeClass;
        if (trait == null) {
            PsiUtil.$$$reportNull$$$0(49);
        }
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(50);
        }
        return (scopeClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)place, GrTypeDefinition.class, (boolean)true)) != null && ContainerUtil.find((Object[])scopeClass.getSuperTypes(), type -> {
            if (place == null) {
                PsiUtil.$$$reportNull$$$0(55);
            }
            if (trait == null) {
                PsiUtil.$$$reportNull$$$0(56);
            }
            return place.getManager().areElementsEquivalent((PsiElement)type.resolve(), (PsiElement)trait);
        }) != null;
    }

    public static boolean isThisOrSuperRef(@Nullable PsiElement qualifier) {
        return qualifier instanceof GrReferenceExpression && (PsiUtil.isThisReference(qualifier) || PsiUtil.isSuperReference(qualifier));
    }

    public static boolean isInstanceThisRef(PsiElement qualifier) {
        if (PsiUtil.isThisReference(qualifier)) {
            GrReferenceExpression ref = (GrReferenceExpression)qualifier;
            PsiElement resolved = ref.resolve();
            if (!(resolved instanceof PsiClass)) {
                return false;
            }
            return PsiUtil.hasEnclosingInstanceInScope((PsiClass)resolved, qualifier, false);
        }
        return false;
    }

    public static boolean isLineFeed(@Nullable PsiElement e) {
        return e != null && PsiImplUtil.isWhiteSpaceOrNls(e) && (e.getText().indexOf(10) >= 0 || e.getText().indexOf(13) >= 0);
    }

    public static boolean isSingleBindingVariant(GroovyResolveResult[] candidates) {
        return candidates.length == 1 && candidates[0].getElement() instanceof GrBindingVariable;
    }

    @Nullable
    public static GrConstructorInvocation getConstructorInvocation(@NotNull GrMethod constructor) {
        if (constructor == null) {
            PsiUtil.$$$reportNull$$$0(51);
        }
        assert (constructor.isConstructor());
        GrOpenBlock body = constructor.getBlock();
        if (body == null) {
            return null;
        }
        GrStatement[] statements = body.getStatements();
        if (statements.length > 0 && statements[0] instanceof GrConstructorInvocation) {
            return (GrConstructorInvocation)statements[0];
        }
        return null;
    }

    public static boolean isDGMMethod(@Nullable PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = element instanceof GrGdkMethod ? ((GrGdkMethod)element).getStaticMethod() : (PsiMethod)element;
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qname = aClass.getQualifiedName();
        return GroovyCommonClassNames.DEFAULT_INSTANCE_EXTENSIONS.contains(qname) || GroovyCommonClassNames.DEFAULT_STATIC_EXTENSIONS.contains(qname);
    }

    public static boolean isVoidMethodCall(@Nullable GrExpression expression) {
        if (expression instanceof GrMethodCall && PsiType.NULL.equals((Object)expression.getType())) {
            GroovyResolveResult resolveResult = ((GrMethodCall)expression).advancedResolve();
            PsiType[] args = PsiUtil.getArgumentTypes(((GrMethodCall)expression).getInvokedExpression(), true);
            return PsiType.VOID.equals((Object)ResolveUtil.extractReturnTypeFromCandidate(resolveResult, expression, args));
        }
        return false;
    }

    public static boolean isVoidMethod(@NotNull PsiMethod method) {
        GrOpenBlock block;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(52);
        }
        if (PsiType.VOID.equals((Object)method.getReturnType())) {
            return true;
        }
        return method instanceof GrMethod && ((GrMethod)method).getReturnTypeElementGroovy() == null && (block = ((GrMethod)method).getBlock()) != null && PsiUtil.isBlockReturnVoid(block);
    }

    public static boolean isBlockReturnVoid(@NotNull GrCodeBlock block) {
        if (block == null) {
            PsiUtil.$$$reportNull$$$0(53);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)block, () -> {
            if (block == null) {
                PsiUtil.$$$reportNull$$$0(54);
            }
            return CachedValueProvider.Result.create((Object)ControlFlowUtils.visitAllExitPoints(block, new ControlFlowUtils.ExitPointVisitor(){

                @Override
                public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
                    return !(returnValue instanceof GrLiteral);
                }
            }), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static boolean checkPsiElementsAreEqual(PsiElement l, PsiElement r) {
        PsiElement[] rChildren;
        if (!l.getText().equals(r.getText())) {
            return false;
        }
        if (l.getNode().getElementType() != r.getNode().getElementType()) {
            return false;
        }
        PsiElement[] lChildren = l.getChildren();
        if (lChildren.length != (rChildren = r.getChildren()).length) {
            return false;
        }
        for (int i = 0; i < rChildren.length; ++i) {
            if (PsiUtil.checkPsiElementsAreEqual(lChildren[i], rChildren[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isCall(GrReferenceExpression referenceExpression) {
        return referenceExpression.getParent() instanceof GrCall;
    }

    public static boolean isLocalVariable(@Nullable PsiElement variable) {
        return variable instanceof GrVariable && !(variable instanceof GrField) && !(variable instanceof GrParameter);
    }

    public static boolean isLocalOrParameter(@Nullable PsiElement variable) {
        return variable instanceof GrVariable && !(variable instanceof GrField);
    }

    @Nullable
    public static PsiElement getPreviousNonWhitespaceToken(PsiElement e) {
        PsiElement next = PsiTreeUtil.prevLeaf((PsiElement)e);
        while (next != null && next.getNode().getElementType() == TokenType.WHITE_SPACE) {
            next = PsiTreeUtil.prevLeaf((PsiElement)next);
        }
        return next;
    }

    @Nullable
    public static Object getLabelValue(@Nullable GrArgumentLabel label) {
        Object value;
        if (label == null) {
            return null;
        }
        PsiElement element = label.getNameElement();
        if (element instanceof GrExpression && (value = JavaPsiFacade.getInstance((Project)label.getProject()).getConstantEvaluationHelper().computeConstantExpression(element)) != null) {
            return value;
        }
        IElementType elemType = element.getNode().getElementType();
        if (GroovyTokenTypes.mIDENT == elemType || TokenSets.KEYWORDS.contains(elemType)) {
            return element.getText();
        }
        return GrLiteralImpl.getLiteralValue(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 20: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedArgs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closures";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 21: 
            case 50: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 14: 
            case 15: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/util/PsiUtil";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classCandidate";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grCall";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 49: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trait";
                break;
            }
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/util/PsiUtil";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaNameIdentifier";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorCandidates";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "skipParenthesesIfSensibly";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalClass";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessObjectClass";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidImportStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLValueOfOperatorAssignment";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableConcrete";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentTypes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidReferenceName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "iterateSupers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isInDummyFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isRawType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPrevNonSpace";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getJavaNameIdentifier";
                break;
            }
            case 14: 
            case 15: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasEnclosingInstanceInScope";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingInstanceClassInScope";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "skipSet";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSmartReturnType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorCandidates";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "skipParenthesesIfSensibly";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalClass";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentIndex";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAllArguments";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFirstMapNamedArguments";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getAnnoAttributeValue";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isReturnStatement";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceWithoutQualifier";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isProperty";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isConstructorHasRequiredParameters";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "scopeClassImplementsTrait";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorInvocation";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isVoidMethod";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isBlockReturnVoid";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isBlockReturnVoid$1";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scopeClassImplementsTrait$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

