/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.utils;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyNamedImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.RegularImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StarImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StaticImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StaticStarImport;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u00a8\u0006\u0003"}, d2={"createImportFromStatement", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyImport;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/toplevel/imports/GrImportStatement;", "intellij.groovy.psi"})
@JvmName(name="PsiImportUtil")
public final class PsiImportUtil {
    @Nullable
    public static final GroovyImport createImportFromStatement(@NotNull GrImportStatement $receiver) {
        GroovyImport groovyImport;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        GrCodeReferenceElement grCodeReferenceElement = $receiver.getImportReference();
        if (grCodeReferenceElement == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)grCodeReferenceElement, (String)"importReference ?: return null");
        GrCodeReferenceElement reference = grCodeReferenceElement;
        boolean bl = $receiver.isStatic();
        boolean star = $receiver.isOnDemand();
        if (bl && star) {
            String string = reference.getQualifiedReferenceName();
            if (string == null) {
                return null;
            }
            groovyImport = new StaticStarImport(string);
        } else if (bl) {
            GroovyNamedImport groovyNamedImport;
            GrCodeReferenceElement qualifier = (GrCodeReferenceElement)reference.getQualifier();
            String string = reference.getReferenceName();
            if (string == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reference.referenceName ?: return null");
            String name = string;
            String string2 = $receiver.getImportedName();
            if (string2 == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"importedName ?: return null");
            String importedName = string2;
            if (qualifier == null) {
                groovyNamedImport = new RegularImport(name, importedName);
            } else {
                String string3 = qualifier.getQualifiedReferenceName();
                if (string3 == null) {
                    return null;
                }
                groovyNamedImport = new StaticImport(string3, name, importedName);
            }
            groovyImport = groovyNamedImport;
        } else if (star) {
            String string = reference.getQualifiedReferenceName();
            if (string == null) {
                return null;
            }
            groovyImport = new StarImport(string);
        } else {
            String string = reference.getQualifiedReferenceName();
            if (string == null) {
                return null;
            }
            String string4 = $receiver.getImportedName();
            if (string4 == null) {
                return null;
            }
            groovyImport = new RegularImport(string, string4);
        }
        return groovyImport;
    }
}

