/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.CodeReferenceKind;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PropertyUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.GrCodeReferenceResolver;

public class GrCodeReferenceElementImpl
extends GrReferenceElementImpl<GrCodeReferenceElement>
implements GrCodeReferenceElement {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.psi.impl.types.GrCodeReferenceElementImpl");

    public GrCodeReferenceElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public PsiReference getReference() {
        return this;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (StringUtil.isJavaIdentifier((String)newElementName)) {
            return super.handleElementRename(newElementName);
        }
        throw new IncorrectOperationException("Cannot rename reference to '" + newElementName + "'");
    }

    protected GrCodeReferenceElement bindWithQualifiedRef(@NotNull String qName) {
        if (qName == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(1);
        }
        GrCodeReferenceElement qualifiedRef = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeOrPackageReference(qName);
        GrTypeArgumentList list = this.getTypeArgumentList();
        if (list != null) {
            qualifiedRef.getNode().addChild(list.copy().getNode());
        }
        this.getNode().getTreeParent().replaceChild(this.getNode(), qualifiedRef.getNode());
        return qualifiedRef;
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(2);
        }
        visitor2.visitCodeReferenceElement(this);
    }

    public String toString() {
        return "Reference element";
    }

    @Override
    public GrCodeReferenceElement getQualifier() {
        return (GrCodeReferenceElement)this.findChildByType(GroovyElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.findChildByType(TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS);
    }

    @NotNull
    public String getCanonicalText() {
        switch (this.getKind()) {
            case PACKAGE_REFERENCE: 
            case IMPORT_REFERENCE: {
                String string = this.getTextSkipWhiteSpaceAndComments();
                if (string == null) {
                    GrCodeReferenceElementImpl.$$$reportNull$$$0(3);
                }
                return string;
            }
            case REFERENCE: {
                PsiElement target = this.resolve();
                if (target instanceof PsiTypeParameter) {
                    String string = StringUtil.notNullize((String)((PsiTypeParameter)target).getName());
                    if (string == null) {
                        GrCodeReferenceElementImpl.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                if (target instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)target;
                    String name = aClass.getQualifiedName();
                    if (name == null) {
                        if ("" == null) {
                            GrCodeReferenceElementImpl.$$$reportNull$$$0(5);
                        }
                        return "";
                    }
                    PsiType[] types = this.getTypeArguments();
                    if (types.length == 0) {
                        String string = name;
                        if (string == null) {
                            GrCodeReferenceElementImpl.$$$reportNull$$$0(6);
                        }
                        return string;
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append(name);
                    buf.append('<');
                    for (int i = 0; i < types.length; ++i) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        buf.append(types[i].getCanonicalText());
                    }
                    buf.append('>');
                    String string = buf.toString();
                    if (string == null) {
                        GrCodeReferenceElementImpl.$$$reportNull$$$0(7);
                    }
                    return string;
                }
                if (target instanceof PsiPackage) {
                    String string = ((PsiPackage)target).getQualifiedName();
                    if (string == null) {
                        GrCodeReferenceElementImpl.$$$reportNull$$$0(8);
                    }
                    return string;
                }
                LOG.assertTrue(target == null);
                String string = this.getTextSkipWhiteSpaceAndComments();
                if (string == null) {
                    GrCodeReferenceElementImpl.$$$reportNull$$$0(9);
                }
                return string;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected boolean bindsCorrectly(PsiElement element) {
        PsiMethod method;
        PsiElement resolved;
        if (super.bindsCorrectly(element)) {
            return true;
        }
        return element instanceof PsiClass && (resolved = this.resolve()) instanceof PsiMethod && (method = (PsiMethod)resolved).isConstructor() && this.getManager().areElementsEquivalent(element, (PsiElement)method.getContainingClass());
    }

    @Override
    public boolean isFullyQualified() {
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiPackage) {
            return true;
        }
        if (resolved instanceof PsiClass) {
            String qualifiedReferenceName = this.getQualifiedReferenceName();
            if (qualifiedReferenceName == null) {
                return false;
            }
            String classFqn = ((PsiClass)resolved).getQualifiedName();
            if (classFqn == null) {
                return false;
            }
            return qualifiedReferenceName.equals(classFqn);
        }
        return false;
    }

    public boolean isReferenceTo(PsiElement element) {
        switch (this.getKind()) {
            case PACKAGE_REFERENCE: {
                return this.referencesPackage(element);
            }
            case REFERENCE: {
                return this.referencesPackage(element) || element instanceof PsiClass && this.resolvesTo(element);
            }
            case IMPORT_REFERENCE: {
                return (element instanceof PsiClass || element instanceof PsiField) && this.checkName((PsiNamedElement)element) && this.resolvesTo(element) || element instanceof PsiMethod && this.checkPropertyName((PsiNamedElement)element) && this.multiResolvesTo(element);
            }
        }
        throw new IllegalStateException();
    }

    private boolean referencesPackage(@NotNull PsiElement element) {
        if (element == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(10);
        }
        return element instanceof PsiPackage && this.checkName((PsiNamedElement)element) && this.resolvesTo(element);
    }

    private boolean checkName(@NotNull PsiNamedElement namedElement) {
        String referenceName;
        if (namedElement == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(11);
        }
        if ((referenceName = this.getReferenceName()) == null) {
            return false;
        }
        String name = namedElement.getName();
        return referenceName.equals(name);
    }

    private boolean checkPropertyName(@NotNull PsiNamedElement namedElement) {
        String referenceName;
        if (namedElement == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(12);
        }
        if ((referenceName = this.getReferenceName()) == null) {
            return false;
        }
        String name = namedElement.getName();
        if (name == null) {
            return false;
        }
        return referenceName.equals(name) || ContainerUtil.or((Object[])PropertyKind.values(), kind -> PropertyUtilKt.getAccessorName(kind, referenceName).equals(name));
    }

    private boolean resolvesTo(@NotNull PsiElement element) {
        if (element == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(13);
        }
        return this.getManager().areElementsEquivalent(element, this.resolve());
    }

    private boolean multiResolvesTo(@NotNull PsiElement element) {
        if (element == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(14);
        }
        PsiManagerEx manager = this.getManager();
        return this.resolve(false).stream().map(it -> it.getElement()).anyMatch(arg_0 -> GrCodeReferenceElementImpl.lambda$multiResolvesTo$2((PsiManager)manager, element, arg_0));
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(15);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public Collection<? extends GroovyResolveResult> resolve(boolean incomplete) {
        Collection<GroovyResolveResult> collection = TypeInferenceHelper.getCurrentContext().resolve(this, incomplete, GrCodeReferenceResolver.INSTANCE);
        if (collection == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        GrTypeArgumentList typeArgumentList = this.getTypeArgumentList();
        if (typeArgumentList != null && typeArgumentList.isDiamond()) {
            PsiType[] psiTypeArray = this.inferDiamondTypeArguments();
            if (psiTypeArray == null) {
                GrCodeReferenceElementImpl.$$$reportNull$$$0(17);
            }
            return psiTypeArray;
        }
        PsiType[] psiTypeArray = super.getTypeArguments();
        if (psiTypeArray == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(18);
        }
        return psiTypeArray;
    }

    private PsiType[] inferDiamondTypeArguments() {
        PsiElement parent = this.getParent();
        if (!(parent instanceof GrNewExpression)) {
            return PsiType.EMPTY_ARRAY;
        }
        PsiType lType = PsiImplUtil.inferExpectedTypeForDiamond((GrNewExpression)parent);
        if (lType instanceof PsiClassType) {
            return ((PsiClassType)lType).getParameters();
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public CodeReferenceKind getKind() {
        CodeReferenceKind codeReferenceKind = PsiImplUtilKt.doGetKind(this);
        if (codeReferenceKind == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(19);
        }
        return codeReferenceKind;
    }

    private static /* synthetic */ boolean lambda$multiResolvesTo$2(PsiManager manager, @NotNull PsiElement element, PsiElement it) {
        if (element == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(20);
        }
        return manager.areElementsEquivalent(it, element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindWithQualifiedRef";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "referencesPackage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertyName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolvesTo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "multiResolvesTo";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$multiResolvesTo$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

