/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GrLiteralEscaper
extends LiteralTextEscaper<GrLiteralContainer> {
    private int[] outSourceOffsets;

    public GrLiteralEscaper(GrLiteralContainer literal) {
        super((PsiLanguageInjectionHost)literal);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            GrLiteralEscaper.$$$reportNull$$$0(0);
        }
        if (outChars == null) {
            GrLiteralEscaper.$$$reportNull$$$0(1);
        }
        String subText = rangeInsideHost.substring(((GrLiteralContainer)this.myHost).getText());
        this.outSourceOffsets = new int[subText.length() + 1];
        IElementType elementType = ((GrLiteralContainer)this.myHost).getFirstChild().getNode().getElementType();
        if (elementType == GroovyTokenTypes.mSTRING_LITERAL || elementType == GroovyTokenTypes.mGSTRING_LITERAL || elementType == GroovyTokenTypes.mGSTRING_CONTENT) {
            return GrStringUtil.parseStringCharacters(subText, outChars, this.outSourceOffsets);
        }
        if (elementType == GroovyTokenTypes.mREGEX_LITERAL || elementType == GroovyTokenTypes.mREGEX_CONTENT) {
            return GrStringUtil.parseRegexCharacters(subText, outChars, this.outSourceOffsets, true);
        }
        if (elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT) {
            return GrStringUtil.parseRegexCharacters(subText, outChars, this.outSourceOffsets, false);
        }
        return false;
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int result2;
        if (rangeInsideHost == null) {
            GrLiteralEscaper.$$$reportNull$$$0(2);
        }
        int n = result2 = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
        if (result2 == -1) {
            return -1;
        }
        return (result2 <= rangeInsideHost.getLength() ? result2 : rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    public boolean isOneLine() {
        Object value = ((GrLiteralContainer)this.myHost).getValue();
        return value instanceof String && ((String)value).indexOf(10) < 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrLiteralEscaper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "decode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOffsetInHost";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

