/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.profiling.ResolveProfiler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReassignedLocalVarsChecker;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyTargetElementEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionReference;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrSuperReferenceResolver;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrThisReferenceResolver;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrReferenceTypeEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.DependentResolver;
import org.jetbrains.plugins.groovy.lang.resolve.GrReferenceResolveRunnerKt;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyResolver;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;

public class GrReferenceExpressionImpl
extends GrReferenceElementImpl<GrExpression>
implements GrReferenceExpression {
    private static final Logger LOG = Logger.getInstance(GrReferenceExpressionImpl.class);
    private final NotNullLazyValue<GrReferenceExpressionReference> myFakeGetterReference;
    private final NotNullLazyValue<GrReferenceExpressionReference> myFakeReference;
    private static final GroovyResolver<GrReferenceExpressionImpl> RESOLVER = new DependentResolver<GrReferenceExpressionImpl>(){

        @Override
        @Nullable
        public Collection<PsiPolyVariantReference> collectDependencies(@NotNull GrReferenceExpressionImpl expression) {
            GrExpression qualifier;
            if (expression == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((qualifier = expression.getQualifier()) == null) {
                return null;
            }
            SmartList result2 = new SmartList();
            qualifier.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((List)result2){
                final /* synthetic */ List val$result;
                {
                    this.val$result = list;
                }

                public void visitElement(PsiElement element) {
                    GrExpression operand;
                    if (element instanceof GrReferenceExpression) {
                        super.visitElement(element);
                    } else if (element instanceof GrMethodCall) {
                        super.visitElement((PsiElement)((GrMethodCall)element).getInvokedExpression());
                    } else if (element instanceof GrParenthesizedExpression && (operand = ((GrParenthesizedExpression)element).getOperand()) != null) {
                        super.visitElement((PsiElement)operand);
                    }
                }

                protected void elementFinished(PsiElement element) {
                    if (element instanceof GrReferenceExpression) {
                        this.val$result.add((GrReferenceExpression)element);
                    }
                }
            });
            return result2;
        }

        @Override
        @NotNull
        public Collection<GroovyResolveResult> doResolve(@NotNull GrReferenceExpressionImpl ref, boolean incomplete) {
            if (ref == null) {
                1.$$$reportNull$$$0(1);
            }
            Collection<? extends GroovyResolveResult> regularResults = ref.multiResolve(incomplete, false);
            if (PsiUtil.isLValueOfOperatorAssignment(ref)) {
                LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
                result2.addAll(ref.multiResolve(incomplete, true));
                result2.addAll(regularResults);
                LinkedHashSet linkedHashSet = result2;
                if (linkedHashSet == null) {
                    1.$$$reportNull$$$0(2);
                }
                return linkedHashSet;
            }
            SmartList smartList = new SmartList(regularResults);
            if (smartList == null) {
                1.$$$reportNull$$$0(3);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl$1";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "collectDependencies";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doResolve";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    public GrReferenceExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
        this.myFakeGetterReference = AtomicNotNullLazyValue.createValue(() -> new GrReferenceExpressionReference(this, true));
        this.myFakeReference = AtomicNotNullLazyValue.createValue(() -> new GrReferenceExpressionReference(this, false));
    }

    @NotNull
    private static List<GroovyResolveResult> filterMembersFromSuperClasses(Collection<GroovyResolveResult> results) {
        ArrayList<GroovyResolveResult> filtered = new ArrayList<GroovyResolveResult>();
        for (GroovyResolveResult result2 : results) {
            String name;
            PsiClass containingClass;
            PsiElement element = result2.getElement();
            if (element instanceof PsiMember && (((PsiMember)element).hasModifierProperty("private") || (containingClass = ((PsiMember)element).getContainingClass()) != null && (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Map") || (name = containingClass.getQualifiedName()) != null && name.startsWith("java.") || containingClass.getLanguage() != GroovyLanguage.INSTANCE && !InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"groovy.lang.GroovyObject")))) continue;
            filtered.add(result2);
        }
        ArrayList<GroovyResolveResult> arrayList = filtered;
        if (arrayList == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(2);
        }
        visitor2.visitReferenceExpression(this);
    }

    @Override
    @Nullable
    public PsiElement getReferenceNameElement() {
        return this.findChildByType(TokenSets.REFERENCE_NAMES);
    }

    @Override
    @Nullable
    public GrExpression getQualifier() {
        return this.getQualifierExpression();
    }

    @Override
    @Nullable
    public String getReferenceName() {
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement != null) {
            Object value;
            IElementType nodeType = nameElement.getNode().getElementType();
            if (TokenSets.STRING_LITERAL_SET.contains(nodeType) && (value = GrLiteralImpl.getLiteralValue(nameElement)) instanceof String) {
                return (String)value;
            }
            return nameElement.getText();
        }
        return null;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String name;
        if (!PsiUtil.isValidReferenceName(newElementName)) {
            PsiElement old = this.getReferenceNameElement();
            if (old == null) {
                throw new IncorrectOperationException("ref has no name element");
            }
            PsiElement element = GroovyPsiElementFactory.getInstance(this.getProject()).createStringLiteralForReference(newElementName);
            old.replace(element);
            return this;
        }
        if (PsiUtil.isThisOrSuperRef(this)) {
            return this;
        }
        GroovyResolveResult result2 = this.advancedResolve();
        if (result2.isInvokedOnProperty() && (name = GroovyPropertyUtils.getPropertyNameByAccessorName(newElementName)) != null) {
            newElementName = name;
        }
        return super.handleElementRename(newElementName);
    }

    protected GrReferenceExpression bindWithQualifiedRef(@NotNull String qName) {
        if (qName == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(3);
        }
        GrReferenceExpression qualifiedRef = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceExpressionFromText(qName);
        GrTypeArgumentList list = this.getTypeArgumentList();
        if (list != null) {
            qualifiedRef.getNode().addChild(list.copy().getNode());
        }
        this.getNode().getTreeParent().replaceChild(this.getNode(), qualifiedRef.getNode());
        return qualifiedRef;
    }

    @Override
    public boolean isFullyQualified() {
        if (!ResolveUtil.canResolveToMethod(this) && this.resolve() instanceof PsiPackage) {
            return true;
        }
        GrExpression qualifier = this.getQualifier();
        if (!(qualifier instanceof GrReferenceExpressionImpl)) {
            return false;
        }
        return ((GrReferenceExpressionImpl)qualifier).isFullyQualified();
    }

    public String toString() {
        return "Reference expression";
    }

    @Override
    @Nullable
    public PsiType getNominalType() {
        return this.getNominalType(false);
    }

    @Nullable
    private PsiType getNominalType(boolean rValue) {
        GroovyResolveResult resolveResult = PsiImplUtil.extractUniqueResult(this.multiResolve(false, rValue));
        PsiElement resolved = resolveResult.getElement();
        for (GrReferenceTypeEnhancer enhancer : (GrReferenceTypeEnhancer[])GrReferenceTypeEnhancer.EP_NAME.getExtensions()) {
            PsiType type = enhancer.getReferenceType(this, resolved);
            if (type == null) continue;
            return type;
        }
        if (ResolveUtil.isDefinitelyKeyOfMap(this)) {
            return GrReferenceExpressionImpl.getTypeFromMapAccess(this);
        }
        PsiType result2 = this.getNominalTypeInner(resolved);
        if (result2 == null) {
            return null;
        }
        result2 = TypesUtil.substituteAndNormalizeType(result2, resolveResult.getSubstitutor(), resolveResult.getSpreadState(), this);
        return result2;
    }

    @Nullable
    private PsiType getNominalTypeInner(@Nullable PsiElement resolved) {
        if (resolved == null && !"class".equals(this.getReferenceName())) {
            resolved = this.resolve();
        }
        if (resolved instanceof PsiClass) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            if (PsiUtil.isInstanceThisRef(this)) {
                PsiClassType categoryType = GdkMethodUtil.getCategoryType((PsiClass)resolved);
                if (categoryType != null) {
                    return categoryType;
                }
                return factory.createType((PsiClass)resolved);
            }
            if (PsiUtil.isSuperReference(this)) {
                PsiClass contextClass = PsiUtil.getContextClass(this);
                if (GrTraitUtil.isTrait(contextClass)) {
                    Object[] extendsTypes = contextClass.getExtendsListTypes();
                    Object[] implementsTypes = contextClass.getImplementsListTypes();
                    Object[] superTypes = (PsiClassType[])ArrayUtil.mergeArrays((Object[])implementsTypes, (Object[])extendsTypes, (ArrayFactory)PsiClassType.ARRAY_FACTORY);
                    if (superTypes.length > 0) {
                        return PsiIntersectionType.createIntersection((PsiType[])((PsiType[])ArrayUtil.reverseArray((Object[])superTypes)));
                    }
                }
                return factory.createType((PsiClass)resolved);
            }
            return TypesUtil.createJavaLangClassType((PsiType)factory.createType((PsiClass)resolved), this.getProject(), this.getResolveScope());
        }
        if (resolved instanceof GrVariable) {
            return ((GrVariable)resolved).getDeclaredType();
        }
        if (resolved instanceof PsiVariable) {
            return ((PsiVariable)resolved).getType();
        }
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) && !method.getName().equals(this.getReferenceName())) {
                return method.getParameterList().getParameters()[0].getType();
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && "getClass".equals(method.getName())) {
                return this.getTypeFromClassRef();
            }
            return PsiUtil.getSmartReturnType(method);
        }
        if (resolved == null) {
            PsiType fromClassRef;
            if ("class".equals(this.getReferenceName()) && (fromClassRef = this.getTypeFromClassRef()) != null) {
                return fromClassRef;
            }
            PsiType fromMapAccess = GrReferenceExpressionImpl.getTypeFromMapAccess(this);
            if (fromMapAccess != null) {
                return fromMapAccess;
            }
            PsiType fromSpreadOperator = GrReferenceExpressionImpl.getTypeFromSpreadOperator(this);
            if (fromSpreadOperator != null) {
                return fromSpreadOperator;
            }
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeFromMapAccess(@NotNull GrReferenceExpressionImpl ref) {
        PsiType substituted;
        PsiSubstitutor substitutor;
        PsiClass mapClass;
        PsiClassType.ClassResolveResult qResult;
        PsiClass clazz;
        PsiType qType;
        GrExpression qualifier;
        if (ref == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(4);
        }
        if ((qualifier = ref.getQualifierExpression()) instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).resolve() instanceof PsiClass) {
            return null;
        }
        if (ref.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
            return null;
        }
        if (qualifier != null && (qType = qualifier.getType()) instanceof PsiClassType && (clazz = (qResult = ((PsiClassType)qType).resolveGenerics()).getElement()) != null && (mapClass = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass("java.util.Map", ref.getResolveScope())) != null && mapClass.getTypeParameters().length == 2 && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)mapClass, (PsiClass)clazz, (PsiSubstitutor)qResult.getSubstitutor())) != null && (substituted = substitutor.substitute(mapClass.getTypeParameters()[1])) != null) {
            return PsiImplUtil.normalizeWildcardTypeByPosition(substituted, ref);
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeFromSpreadOperator(@NotNull GrReferenceExpressionImpl ref) {
        if (ref == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(5);
        }
        if (ref.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
            return TypesUtil.createType("java.util.List", ref);
        }
        return null;
    }

    @Nullable
    private PsiType getTypeFromClassRef() {
        PsiType qualifierType = PsiImplUtil.getQualifierType(this);
        if (qualifierType == null && !PsiUtil.isCompileStatic(this)) {
            return null;
        }
        return TypesUtil.createJavaLangClassType(qualifierType, this.getProject(), this.getResolveScope());
    }

    @Nullable
    private static PsiType calculateType(@NotNull GrReferenceExpressionImpl refExpr) {
        if (refExpr == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(6);
        }
        Collection<? extends GroovyResolveResult> results = refExpr.multiResolve(false, true);
        GroovyResolveResult result2 = PsiImplUtil.extractUniqueResult(results);
        PsiElement resolved = result2.getElement();
        PsiType typeFromCalculators = GrTypeCalculator.getTypeFromCalculators(refExpr);
        if (typeFromCalculators != null) {
            return typeFromCalculators;
        }
        if (ResolveUtil.isClassReference(refExpr)) {
            GrExpression qualifier = refExpr.getQualifier();
            LOG.assertTrue(qualifier != null);
            return qualifier.getType();
        }
        PsiType nominal = refExpr.getNominalType(true);
        Boolean reassigned = GrReassignedLocalVarsChecker.isReassignedVar(refExpr);
        if (reassigned != null && reassigned.booleanValue()) {
            return GrReassignedLocalVarsChecker.getReassignedVarType(refExpr, true);
        }
        PsiType inferred = GrReferenceExpressionImpl.getInferredTypes(refExpr, resolved);
        if (inferred == null) {
            if (nominal != null) {
                return nominal;
            }
            if (resolved instanceof GrVariable) {
                if (PsiUtil.isCompileStatic(refExpr) && resolved instanceof GrField) {
                    return TypesUtil.getJavaLangObject(refExpr);
                }
                LOG.assertTrue(resolved.isValid());
                return ((GrVariable)resolved).getTypeGroovy();
            }
            return null;
        }
        if (nominal == null) {
            return inferred;
        }
        if (!TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)nominal), (PsiType)inferred, (boolean)false) && resolved instanceof GrVariable && ((GrVariable)resolved).getTypeElementGroovy() != null) {
            return nominal;
        }
        return inferred;
    }

    @Nullable
    private static PsiType getInferredTypes(@NotNull GrReferenceExpressionImpl refExpr, @Nullable PsiElement resolved) {
        if (refExpr == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(7);
        }
        GrExpression qualifier = refExpr.getQualifier();
        if (!(resolved instanceof PsiClass) && !(resolved instanceof PsiPackage)) {
            PsiType mapValueType;
            if (qualifier == null) {
                return TypeInferenceHelper.getCurrentContext().getVariableType(refExpr);
            }
            PsiType qType = qualifier.getType();
            if (qType instanceof PsiClassType && !(qType instanceof GrMapType) && (mapValueType = GrReferenceExpressionImpl.getTypeFromMapAccess(refExpr)) != null) {
                return mapValueType;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, e -> GrReferenceExpressionImpl.calculateType(e));
    }

    @Override
    public GrExpression replaceWithExpression(@NotNull GrExpression newExpr, boolean removeUnnecessaryParentheses) {
        if (newExpr == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(8);
        }
        return PsiImplUtil.replaceExpression(this, newExpr, removeUnnecessaryParentheses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    Collection<GroovyResolveResult> doPolyResolve(boolean incompleteCode, boolean forceRValue) {
        GrExpression qualifier;
        Collection<GroovyResolveResult> results;
        PsiElement nameElement = this.getReferenceNameElement();
        String name = this.getReferenceName();
        if (name == null || nameElement == null) {
            List<GroovyResolveResult> list = Collections.emptyList();
            if (list == null) {
                GrReferenceExpressionImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        ResolveProfiler.start();
        IElementType nameType = nameElement.getNode().getElementType();
        if (nameType == GroovyTokenTypes.kTHIS) {
            results = GrThisReferenceResolver.resolveThisExpression(this);
            if (results != null) {
                Collection<GroovyResolveResult> collection = results;
                Collection<GroovyResolveResult> collection2 = collection;
                if (collection2 == null) {
                    GrReferenceExpressionImpl.$$$reportNull$$$0(10);
                }
                return collection2;
            }
        } else if (nameType == GroovyTokenTypes.kSUPER) {
            results = GrSuperReferenceResolver.resolveSuperExpression(this);
            if (results != null) {
                Collection<GroovyResolveResult> collection = results;
                Collection<GroovyResolveResult> collection3 = collection;
                if (collection3 == null) {
                    GrReferenceExpressionImpl.$$$reportNull$$$0(11);
                }
                return collection3;
            }
        } else if (!(nameType != GroovyTokenTypes.kCLASS || PsiUtil.isCompileStatic(this) || (qualifier = this.getQualifier()) != null && qualifier.getType() != null)) {
            List<GroovyResolveResult> list = Collections.emptyList();
            List<GroovyResolveResult> list2 = list;
            if (list2 == null) {
                GrReferenceExpressionImpl.$$$reportNull$$$0(12);
            }
            return list2;
        }
        if ((results = GrReferenceResolveRunnerKt.resolveReferenceExpression(this, forceRValue, incompleteCode)).isEmpty()) {
            List<GroovyResolveResult> list = Collections.emptyList();
            List<GroovyResolveResult> list3 = list;
            if (list3 == null) {
                GrReferenceExpressionImpl.$$$reportNull$$$0(13);
            }
            return list3;
        }
        if (!ResolveUtil.canResolveToMethod(this)) {
            if (!ResolveUtil.mayBeKeyOfMap(this)) {
                Collection<GroovyResolveResult> collection = results;
                Collection<GroovyResolveResult> collection4 = collection;
                if (collection4 == null) {
                    GrReferenceExpressionImpl.$$$reportNull$$$0(14);
                }
                return collection4;
            }
            List<GroovyResolveResult> list = GrReferenceExpressionImpl.filterMembersFromSuperClasses(results);
            List<GroovyResolveResult> list4 = list;
            if (list4 == null) {
                GrReferenceExpressionImpl.$$$reportNull$$$0(15);
            }
            return list4;
        }
        Collection<GroovyResolveResult> collection = results;
        Collection<GroovyResolveResult> collection5 = collection;
        if (collection5 == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(16);
        }
        return collection5;
        finally {
            long time = ResolveProfiler.finish();
            ResolveProfiler.write((String)"ref", (PsiElement)this, (long)time);
        }
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.getElement().getText());
        if (string == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    public boolean hasAt() {
        return this.findChildByType(GroovyTokenTypes.mAT) != null;
    }

    @Override
    public boolean hasMemberPointer() {
        return false;
    }

    public boolean isReferenceTo(PsiElement element) {
        GroovyResolveResult[] results;
        for (GroovyResolveResult result2 : results = this.multiResolve(false)) {
            PsiMethod[] superMethods;
            PsiElement baseTarget = result2.getElement();
            if (baseTarget == null) continue;
            if (this.getManager().areElementsEquivalent(element, baseTarget)) {
                return true;
            }
            PsiElement target = GroovyTargetElementEvaluator.correctSearchTargets(baseTarget);
            if (target != baseTarget && this.getManager().areElementsEquivalent(element, target)) {
                return true;
            }
            if (!(element instanceof PsiMethod) || !(target instanceof PsiMethod) || !Arrays.asList(superMethods = ((PsiMethod)target).findSuperMethods(false)).contains(element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(18);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @Nullable
    public GrExpression getQualifierExpression() {
        return GrReferenceExpressionImpl.findExpressionChild(this);
    }

    @Override
    @Nullable
    public PsiElement getDotToken() {
        return this.findChildByType(GroovyTokenSets.REFERENCE_DOTS);
    }

    @Override
    public void replaceDotToken(PsiElement newDot) {
        if (newDot == null) {
            return;
        }
        if (!TokenSets.DOTS.contains(newDot.getNode().getElementType())) {
            return;
        }
        PsiElement oldDot = this.getDotToken();
        if (oldDot == null) {
            return;
        }
        this.getNode().replaceChild(oldDot.getNode(), newDot.getNode());
    }

    @Override
    @Nullable
    public IElementType getDotTokenType() {
        PsiElement dot = this.getDotToken();
        return dot == null ? null : dot.getNode().getElementType();
    }

    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public Collection<? extends GroovyResolveResult> resolve(boolean incomplete) {
        Collection<GroovyResolveResult> collection = TypeInferenceHelper.getCurrentContext().resolve(this, incomplete, RESOLVER);
        if (collection == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends GroovyResolveResult> multiResolve(boolean incomplete, boolean forceRValue) {
        Collection<GroovyResolveResult> collection = ((GrReferenceExpressionReference)(forceRValue ? this.myFakeGetterReference : this.myFakeReference).getValue()).resolve(incomplete);
        if (collection == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getSameNameVariants() {
        GroovyResolveResult[] groovyResolveResultArray = this.doPolyResolve(true, false).toArray(GroovyResolveResult.EMPTY_ARRAY);
        if (groovyResolveResultArray == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(21);
        }
        return groovyResolveResultArray;
    }

    @Override
    public GrReferenceExpression bindToElementViaStaticImport(@NotNull PsiMember member) {
        if (member == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(22);
        }
        if (this.getQualifier() != null) {
            throw new IncorrectOperationException("Reference has qualifier");
        }
        if (StringUtil.isEmpty((String)this.getReferenceName())) {
            throw new IncorrectOperationException("Reference has empty name");
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            throw new IncorrectOperationException("Member has no containing class");
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFile) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            String text = "import static " + containingClass.getQualifiedName() + "." + member.getName();
            GrImportStatement statement = factory.createImportStatementFromText(text);
            ((GroovyFile)file).addImport(statement);
        }
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpr";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMembersFromSuperClasses";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doPolyResolve";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSameNameVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindWithQualifiedRef";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromMapAccess";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromSpreadOperator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInferredTypes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithExpression";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "bindToElementViaStaticImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

