/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.transformations.immutable.GrImmutableUtils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u001a\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0003H\u0000\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0003*\u00020\u000fH\u0002\u001a\u0014\u0010\u0015\u001a\u00020\r*\u00020\u00012\b\b\u0001\u0010\u0010\u001a\u00020\u0003\u001a\f\u0010\u0016\u001a\u00020\r*\u00020\u000fH\u0002\u001a\u001e\u0010\u0017\u001a\u00020\r*\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002\u001a\f\u0010\u001a\u001a\u00020\r*\u00020\u001bH\u0002\u001a\f\u0010\u001c\u001a\u00020\r*\u00020\u000fH\u0002\u001a\f\u0010\u001d\u001a\u00020\r*\u00020\bH\u0002\u001a\f\u0010\u001e\u001a\u00020\r*\u00020\u000fH\u0002\u001a\f\u0010\u001f\u001a\u00020\r*\u00020\bH\u0002\u001a\u0014\u0010 \u001a\u00020\r*\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\f\u0010!\u001a\u00020\r*\u00020\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"explicitVisibilityModifiersMask", "", "packageScopeAnno", "", "packageScopeTarget", "visibilityModifiers", "", "containingClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariableDeclaration;", "getContainingClass", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariableDeclaration;)Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "hasExplicitModifier", "", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "name", "hasExplicitVisibilityModifiers", "hasImplicitModifier", "hasModifierProperty", "getImplicitVisiblity", "hasMaskModifier", "hasOwnEmptyPackageScopeAnnotation", "hasPackageScope", "clazz", "targetName", "isAbsractMethod", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "isAbstract", "isAbstractClass", "isFinal", "isFinalClass", "isFinalField", "isStatic", "intellij.groovy.psi"})
@JvmName(name="GrModifierListUtil")
public final class GrModifierListUtil {
    private static final Set<String> visibilityModifiers = SetsKt.setOf((Object[])new String[]{"public", "protected", "packageLocal", "private"});
    private static final int explicitVisibilityModifiersMask = 7;
    private static final String packageScopeAnno = "groovy.transform.PackageScope";
    private static final String packageScopeTarget = "groovy.transform.PackageScopeTarget";

    public static final boolean hasMaskModifier(int $receiver, @GrModifier.GrModifierConstant @NonNls @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return ($receiver & GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.get((Object)name)) != 0;
    }

    public static final boolean hasExplicitVisibilityModifiers(@NotNull GrModifierList modifierList) {
        Intrinsics.checkParameterIsNotNull((Object)modifierList, (String)"modifierList");
        return (explicitVisibilityModifiersMask & modifierList.getModifierFlags()) != 0;
    }

    public static final boolean hasExplicitModifier(@NotNull GrModifierList modifierList, @GrModifier.GrModifierConstant @NonNls @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)modifierList, (String)"modifierList");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return GrModifierListUtil.hasMaskModifier(modifierList.getModifierFlags(), name);
    }

    public static final boolean hasModifierProperty(@NotNull GrModifierList modifierList, @GrModifier.GrModifierConstant @NonNls @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)modifierList, (String)"modifierList");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return GrModifierListUtil.hasExplicitModifier(modifierList, name) || GrModifierListUtil.hasImplicitModifier(modifierList, name);
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean hasImplicitModifier(GrModifierList modifierList, @GrModifier.GrModifierConstant @NonNls String name) {
        block6: {
            block5: {
                var2_2 = name;
                switch (var2_2.hashCode()) {
                    case -892481938: {
                        if (!var2_2.equals("static")) ** break;
                        break block5;
                    }
                    case 97436022: {
                        if (!var2_2.equals("final")) ** break;
                        break;
                    }
                    case 1732898850: {
                        if (!var2_2.equals("abstract")) ** break;
                        v0 = GrModifierListUtil.isAbstract(modifierList);
                        break block6;
                    }
                }
                v0 = GrModifierListUtil.isFinal(modifierList);
                break block6;
            }
            v0 = GrModifierListUtil.isStatic(modifierList);
            break block6;
            v0 = GrModifierListUtil.visibilityModifiers.contains(name) != false && Intrinsics.areEqual((Object)name, (Object)GrModifierListUtil.getImplicitVisiblity(modifierList)) != false;
        }
        return v0;
    }

    private static final boolean isAbstract(@NotNull GrModifierList $receiver) {
        PsiElement owner = $receiver.getParent();
        PsiElement psiElement = owner;
        return psiElement instanceof GrMethod ? GrModifierListUtil.isAbsractMethod((GrMethod)owner) : (psiElement instanceof GrTypeDefinition ? GrModifierListUtil.isAbstractClass((GrTypeDefinition)owner) : false);
    }

    private static final boolean isAbsractMethod(@NotNull GrMethod $receiver) {
        PsiClass psiClass = $receiver.getContainingClass();
        return psiClass != null ? psiClass.isInterface() : false;
    }

    private static final boolean isAbstractClass(@NotNull GrTypeDefinition $receiver) {
        if ($receiver.isEnum() && GroovyConfigUtils.getInstance().isVersionAtLeast($receiver, "2.0")) {
            boolean bl;
            block2: {
                GrMethod[] grMethodArray = $receiver.getCodeMethods();
                Intrinsics.checkExpressionValueIsNotNull((Object)grMethodArray, (String)"codeMethods");
                GrMethod[] $receiver$iv = grMethodArray;
                int n = $receiver$iv.length;
                for (int i = 0; i < n; ++i) {
                    GrMethod element$iv;
                    GrMethod it;
                    GrMethod grMethod = it = (element$iv = $receiver$iv[i]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)grMethod, (String)"it");
                    if (!grMethod.getModifierList().hasExplicitModifier("abstract")) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }
        return $receiver.isInterface();
    }

    private static final boolean isFinal(@NotNull GrModifierList $receiver) {
        PsiElement owner = $receiver.getParent();
        PsiElement psiElement = owner;
        return psiElement instanceof GrTypeDefinition ? GrModifierListUtil.isFinalClass((GrTypeDefinition)owner) : (psiElement instanceof GrVariableDeclaration ? GrModifierListUtil.isFinalField((GrVariableDeclaration)owner, $receiver) : psiElement instanceof GrEnumConstant);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isFinalClass(@NotNull GrTypeDefinition $receiver) {
        if (!$receiver.isEnum()) return false;
        GrField[] grFieldArray = $receiver.getCodeFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)grFieldArray, (String)"codeFields");
        GrField[] $receiver$iv = grFieldArray;
        int n = $receiver$iv.length;
        int n2 = 0;
        while (n2 < n) {
            GrField element$iv = $receiver$iv[n2];
            GrField it = element$iv;
            if (it instanceof GrEnumConstant && ((GrEnumConstant)it).getInitializingClass() != null) {
                return false;
            }
            boolean bl = false;
            if (bl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isFinalField(@NotNull GrVariableDeclaration $receiver, GrModifierList modifierList) {
        GrTypeDefinition containingClass = GrModifierListUtil.getContainingClass($receiver);
        if (GrTraitUtil.isInterface(containingClass)) return true;
        if (modifierList.hasExplicitVisibilityModifiers()) return false;
        GrTypeDefinition grTypeDefinition = containingClass;
        if (grTypeDefinition == null) return false;
        GrTypeDefinition grTypeDefinition2 = grTypeDefinition;
        PsiModifierListOwner p1 = (PsiModifierListOwner)grTypeDefinition2;
        boolean bl = GrImmutableUtils.hasImmutableAnnotation(p1);
        if (!bl) return false;
        return true;
    }

    private static final boolean isStatic(@NotNull GrModifierList $receiver) {
        PsiClass psiClass;
        PsiElement owner = $receiver.getParent();
        PsiElement psiElement = owner;
        if (psiElement instanceof GrTypeDefinition) {
            psiClass = ((GrTypeDefinition)owner).getContainingClass();
        } else if (psiElement instanceof GrVariableDeclaration) {
            psiClass = GrModifierListUtil.getContainingClass((GrVariableDeclaration)owner);
        } else {
            if (psiElement instanceof GrEnumConstant) {
                return true;
            }
            psiClass = null;
        }
        PsiClass containingClass = psiClass;
        return containingClass != null && (owner instanceof GrEnumTypeDefinition || GrTraitUtil.isInterface(containingClass));
    }

    private static final String getImplicitVisiblity(@NotNull GrModifierList $receiver) {
        if (GrModifierListUtil.hasExplicitVisibilityModifiers($receiver)) {
            return null;
        }
        PsiElement owner = $receiver.getParent();
        PsiElement psiElement = owner;
        if (psiElement instanceof GrTypeDefinition) {
            return GrModifierListUtil.hasPackageScope($receiver, (GrTypeDefinition)owner, "CLASS") ? "packageLocal" : "public";
        }
        if (psiElement instanceof GrMethod) {
            PsiClass psiClass = ((GrMethod)owner).getContainingClass();
            if (!(psiClass instanceof GrTypeDefinition)) {
                psiClass = null;
            }
            GrTypeDefinition grTypeDefinition = (GrTypeDefinition)psiClass;
            if (grTypeDefinition == null) {
                return null;
            }
            GrTypeDefinition containingClass = grTypeDefinition;
            if (GrTraitUtil.isInterface(containingClass)) {
                return "public";
            }
            String targetName = ((GrMethod)owner).isConstructor() ? "CONSTRUCTORS" : "METHODS";
            return GrModifierListUtil.hasPackageScope($receiver, containingClass, targetName) ? "packageLocal" : "public";
        }
        if (psiElement instanceof GrVariableDeclaration) {
            GrTypeDefinition grTypeDefinition = GrModifierListUtil.getContainingClass((GrVariableDeclaration)owner);
            if (grTypeDefinition == null) {
                return null;
            }
            GrTypeDefinition containingClass = grTypeDefinition;
            if (GrTraitUtil.isInterface(containingClass)) {
                return "public";
            }
            return GrModifierListUtil.hasPackageScope($receiver, containingClass, "FIELDS") ? "packageLocal" : "private";
        }
        if (psiElement instanceof GrEnumConstant) {
            return "public";
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasPackageScope(@NotNull GrModifierList $receiver, GrTypeDefinition clazz, String targetName) {
        PsiElement it;
        Object object;
        PsiAnnotation psiAnnotation;
        if (GrModifierListUtil.hasOwnEmptyPackageScopeAnnotation($receiver)) {
            return true;
        }
        GroovyPsiElement groovyPsiElement = clazz;
        if (!((groovyPsiElement != null && (groovyPsiElement = (GrModifierList)groovyPsiElement.getModifierList()) != null ? groovyPsiElement.findAnnotation(packageScopeAnno) : (psiAnnotation = null)) instanceof GrAnnotation)) {
            psiAnnotation = null;
        }
        GrAnnotation grAnnotation = (GrAnnotation)psiAnnotation;
        if (grAnnotation == null) {
            return false;
        }
        GrAnnotation annotation = grAnnotation;
        PsiAnnotationMemberValue psiAnnotationMemberValue = GrAnnotationUtilKt.findDeclaredDetachedValue(annotation, null);
        if (psiAnnotationMemberValue == null) {
            return false;
        }
        PsiAnnotationMemberValue value = psiAnnotationMemberValue;
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)$receiver.getProject()).findClass(packageScopeTarget, $receiver.getResolveScope());
        if (psiClass == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"JavaPsiFacade.getInstanc\u2026lveScope) ?: return false");
        PsiClass scopeTargetEnum = psiClass;
        PsiField psiField = scopeTargetEnum.findFieldByName(targetName, false);
        if (psiField == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiField, (String)"scopeTargetEnum.findFiel\u2026e, false) ?: return false");
        PsiField scopeTarget = psiField;
        PsiAnnotationMemberValue psiAnnotationMemberValue2 = value;
        if (psiAnnotationMemberValue2 instanceof GrReferenceExpression) {
            PsiElement psiElement;
            object = ((GrReferenceExpression)value).resolve();
            if (object == null || (object = CollectionsKt.listOf((Object)(it = (psiElement = object)))) == null) {
                object = CollectionsKt.emptyList();
            }
        } else if (psiAnnotationMemberValue2 instanceof GrAnnotationArrayInitializer) {
            void $receiver$iv$iv;
            GrAnnotationMemberValue[] grAnnotationMemberValueArray = ((GrAnnotationArrayInitializer)value).getInitializers();
            Intrinsics.checkExpressionValueIsNotNull((Object)grAnnotationMemberValueArray, (String)"value.initializers");
            GrAnnotationMemberValue[] $receiver$iv = grAnnotationMemberValueArray;
            it = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv$iv : $receiver$iv$iv) {
                PsiElement psiElement;
                void element$iv$iv = element$iv$iv$iv;
                void it2 = element$iv$iv;
                Object v8 = it2;
                if (!(v8 instanceof GrReferenceExpression)) {
                    v8 = null;
                }
                GrReferenceExpression grReferenceExpression = v8;
                Object object2 = grReferenceExpression != null ? grReferenceExpression.resolve() : null;
                if (object2 == null) continue;
                PsiElement it$iv$iv = psiElement = object2;
                destination$iv$iv.add(it$iv$iv);
            }
            object = (List)destination$iv$iv;
        } else {
            object = CollectionsKt.emptyList();
        }
        PsiElement resolved = object;
        return resolved.contains(scopeTarget);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasOwnEmptyPackageScopeAnnotation(@NotNull GrModifierList $receiver) {
        PsiAnnotation psiAnnotation = $receiver.findAnnotation(packageScopeAnno);
        if (psiAnnotation == null) return false;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"findAnnotation(packageScopeAnno) ?: return false");
        PsiAnnotation annotation = psiAnnotation;
        PsiAnnotationMemberValue psiAnnotationMemberValue = GrAnnotationUtilKt.findDeclaredDetachedValue(annotation, null);
        if (psiAnnotationMemberValue == null) return true;
        PsiAnnotationMemberValue value = psiAnnotationMemberValue;
        if (!(value instanceof GrAnnotationArrayInitializer)) return false;
        GrAnnotationMemberValue[] grAnnotationMemberValueArray = ((GrAnnotationArrayInitializer)value).getInitializers();
        Intrinsics.checkExpressionValueIsNotNull((Object)grAnnotationMemberValueArray, (String)"value.initializers");
        GrAnnotationMemberValue[] grAnnotationMemberValueArray2 = grAnnotationMemberValueArray;
        if (grAnnotationMemberValueArray2.length != 0) return false;
        return true;
    }

    private static final GrTypeDefinition getContainingClass(@NotNull GrVariableDeclaration $receiver) {
        PsiElement psiElement = $receiver.getParent();
        if (!(psiElement instanceof GrTypeDefinitionBody)) {
            psiElement = null;
        }
        GrTypeDefinitionBody grTypeDefinitionBody = (GrTypeDefinitionBody)psiElement;
        Object object = grTypeDefinitionBody != null ? grTypeDefinitionBody.getParent() : null;
        if (!(object instanceof GrTypeDefinition)) {
            object = null;
        }
        return (GrTypeDefinition)object;
    }

    static {
        explicitVisibilityModifiersMask = 7;
        packageScopeAnno = packageScopeAnno;
        packageScopeTarget = packageScopeTarget;
    }
}

