/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightAnnotation;
import org.jetbrains.plugins.groovy.transformations.immutable.GrImmutableUtils;

public class GrAnnotationCollector {
    @NotNull
    public static GrAnnotation[] getResolvedAnnotations(@NotNull GrModifierList modifierList) {
        GrAnnotation[] rawAnnotations;
        if (modifierList == null) {
            GrAnnotationCollector.$$$reportNull$$$0(0);
        }
        if (!GrAnnotationCollector.hasAliases(rawAnnotations = modifierList.getRawAnnotations())) {
            if (rawAnnotations == null) {
                GrAnnotationCollector.$$$reportNull$$$0(1);
            }
            return rawAnnotations;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (GrAnnotation annotation : rawAnnotations) {
            PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
            if (annotationCollector != null) {
                GrAnnotationCollector.collectAnnotations(result2, annotation, annotationCollector);
                continue;
            }
            result2.add(annotation);
        }
        GrAnnotation[] grAnnotationArray = result2.toArray(GrAnnotation.EMPTY_ARRAY);
        if (grAnnotationArray == null) {
            GrAnnotationCollector.$$$reportNull$$$0(2);
        }
        return grAnnotationArray;
    }

    private static boolean hasAliases(@NotNull GrAnnotation[] rawAnnotations) {
        if (rawAnnotations == null) {
            GrAnnotationCollector.$$$reportNull$$$0(3);
        }
        for (GrAnnotation annotation : rawAnnotations) {
            PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
            if (annotationCollector == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Set<String> collectAnnotations(@NotNull List<GrAnnotation> list, @NotNull GrAnnotation alias, @NotNull PsiAnnotation annotationCollector) {
        if (list == null) {
            GrAnnotationCollector.$$$reportNull$$$0(4);
        }
        if (alias == null) {
            GrAnnotationCollector.$$$reportNull$$$0(5);
        }
        if (annotationCollector == null) {
            GrAnnotationCollector.$$$reportNull$$$0(6);
        }
        PsiModifierList modifierList = (PsiModifierList)annotationCollector.getParent();
        LinkedHashMap annotations2 = ContainerUtil.newLinkedHashMap();
        if ("groovy.transform.Immutable".equals(alias.getQualifiedName())) {
            GrImmutableUtils.collectImmutableAnnotations(alias, list);
        }
        GrAnnotationCollector.collectAliasedAnnotationsFromAnnotationCollectorValueAttribute(annotationCollector, annotations2);
        GrAnnotationCollector.collectAliasedAnnotationsFromAnnotationCollectorAnnotations(modifierList, annotations2);
        PsiManager manager = alias.getManager();
        GrAnnotationNameValuePair[] attributes = alias.getParameterList().getAttributes();
        LinkedHashSet allUsedAttrs = ContainerUtil.newLinkedHashSet();
        for (Map.Entry entry : annotations2.entrySet()) {
            String qname = (String)entry.getKey();
            PsiClass resolved = JavaPsiFacade.getInstance((Project)alias.getProject()).findClass(qname, alias.getResolveScope());
            if (resolved == null) continue;
            GrLightAnnotation annotation = new GrLightAnnotation(manager, alias.getLanguage(), qname, (PsiAnnotationOwner)modifierList);
            LinkedHashSet usedAttrs = ContainerUtil.newLinkedHashSet();
            for (GrAnnotationNameValuePair attr : attributes) {
                String name;
                String string = name = attr.getName() != null ? attr.getName() : "value";
                if (resolved.findMethodsByName(name, false).length <= 0) continue;
                annotation.addAttribute(attr);
                allUsedAttrs.add(name);
                usedAttrs.add(name);
            }
            Map defaults = (Map)entry.getValue();
            for (Map.Entry defa : defaults.entrySet()) {
                if (usedAttrs.contains(defa.getKey())) continue;
                annotation.addAttribute((PsiNameValuePair)defa.getValue());
            }
            list.add(annotation);
        }
        LinkedHashSet linkedHashSet = allUsedAttrs;
        if (linkedHashSet == null) {
            GrAnnotationCollector.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    private static void collectAliasedAnnotationsFromAnnotationCollectorAnnotations(@NotNull PsiModifierList modifierList, @NotNull Map<String, Map<String, PsiNameValuePair>> annotations2) {
        PsiAnnotation[] rawAnnotations;
        PsiElement parent;
        if (modifierList == null) {
            GrAnnotationCollector.$$$reportNull$$$0(8);
        }
        if (annotations2 == null) {
            GrAnnotationCollector.$$$reportNull$$$0(9);
        }
        if ((parent = modifierList.getParent()) instanceof PsiClass && "groovy.transform.CompileDynamic".equals(((PsiClass)parent).getQualifiedName())) {
            LinkedHashMap params = ContainerUtil.newLinkedHashMap();
            annotations2.put("groovy.transform.CompileStatic", params);
            GrAnnotation annotation = GroovyPsiElementFactory.getInstance(modifierList.getProject()).createAnnotationFromText("@CompileStatic(TypeCheckingMode.SKIP)");
            params.put("value", annotation.getParameterList().getAttributes()[0]);
            return;
        }
        for (PsiAnnotation annotation : rawAnnotations = modifierList instanceof GrModifierList ? ((GrModifierList)modifierList).getRawAnnotations() : modifierList.getAnnotations()) {
            PsiNameValuePair[] attributes;
            String qname = annotation.getQualifiedName();
            if (qname == null || qname.equals("groovy.transform.AnnotationCollector")) continue;
            for (PsiNameValuePair pair : attributes = annotation.getParameterList().getAttributes()) {
                LinkedHashMap map2 = annotations2.get(qname);
                if (map2 == null) {
                    map2 = ContainerUtil.newLinkedHashMap();
                    annotations2.put(qname, map2);
                }
                map2.put(pair.getName() != null ? pair.getName() : "value", pair);
            }
            if (attributes.length != 0 || annotations2.containsKey(qname)) continue;
            annotations2.put(qname, ContainerUtil.newLinkedHashMap());
        }
    }

    private static void collectAliasedAnnotationsFromAnnotationCollectorValueAttribute(@NotNull PsiAnnotation annotationCollector, @NotNull Map<String, Map<String, PsiNameValuePair>> annotations2) {
        PsiAnnotationMemberValue annotationsFromValue;
        if (annotationCollector == null) {
            GrAnnotationCollector.$$$reportNull$$$0(10);
        }
        if (annotations2 == null) {
            GrAnnotationCollector.$$$reportNull$$$0(11);
        }
        if ((annotationsFromValue = annotationCollector.findAttributeValue("value")) instanceof GrAnnotationArrayInitializer) {
            for (GrAnnotationMemberValue member : ((GrAnnotationArrayInitializer)annotationsFromValue).getInitializers()) {
                PsiElement resolved;
                if (!(member instanceof GrReferenceExpression) || !((resolved = ((GrReferenceExpression)member).resolve()) instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
                annotations2.put(((PsiClass)resolved).getQualifiedName(), ContainerUtil.newLinkedHashMap());
            }
        }
    }

    @Nullable
    public static PsiAnnotation findAnnotationCollector(@Nullable PsiClass clazz) {
        PsiModifierList modifierList;
        if (clazz != null && (modifierList = clazz.getModifierList()) != null) {
            PsiAnnotation[] annotations2;
            for (PsiAnnotation annotation : annotations2 = modifierList instanceof GrModifierList ? ((GrModifierList)modifierList).getRawAnnotations() : modifierList.getAnnotations()) {
                if (!"groovy.transform.AnnotationCollector".equals(annotation.getQualifiedName())) continue;
                return annotation;
            }
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation findAnnotationCollector(@NotNull GrAnnotation annotation) {
        GrCodeReferenceElement ref;
        PsiElement resolved;
        if (annotation == null) {
            GrAnnotationCollector.$$$reportNull$$$0(12);
        }
        if ((resolved = (ref = annotation.getClassReference()).resolve()) instanceof PsiClass) {
            return GrAnnotationCollector.findAnnotationCollector((PsiClass)resolved);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawAnnotations";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationCollector";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedAnnotations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedAnnotations";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasAliases";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectAnnotations";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectAliasedAnnotationsFromAnnotationCollectorAnnotations";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectAliasedAnnotationsFromAnnotationCollectorValueAttribute";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationCollector";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

