/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrAnnotationStub;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrAnnotationImpl
extends GrStubElementBase<GrAnnotationStub>
implements GrAnnotation,
StubBasedPsiElement<GrAnnotationStub> {
    private static final PairFunction<Project, String, PsiAnnotation> ANNOTATION_CREATOR = (project, text) -> GroovyPsiElementFactory.getInstance(project).createAnnotationFromText((String)text);

    public GrAnnotationImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrAnnotationImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public GrAnnotationImpl(GrAnnotationStub stub) {
        super(stub, GroovyElementTypes.ANNOTATION);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrAnnotationImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitAnnotation(this);
    }

    public String toString() {
        return "Annotation";
    }

    @Override
    @NotNull
    public GrAnnotationArgumentList getParameterList() {
        GrAnnotationArgumentList grAnnotationArgumentList = (GrAnnotationArgumentList)this.getRequiredStubOrPsiChild((IStubElementType)GroovyElementTypes.ANNOTATION_ARGUMENTS);
        if (grAnnotationArgumentList == null) {
            GrAnnotationImpl.$$$reportNull$$$0(2);
        }
        return grAnnotationArgumentList;
    }

    @Nullable
    @NonNls
    public String getQualifiedName() {
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (stub != null) {
            return stub.getPsiElement().getQualifiedName();
        }
        GrCodeReferenceElement nameRef = this.getClassReference();
        PsiElement resolved = nameRef.resolve();
        if (resolved instanceof PsiClass) {
            return ((PsiClass)resolved).getQualifiedName();
        }
        return null;
    }

    @Nullable
    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        GroovyResolveResult resolveResult = this.getClassReference().advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        return new LightClassReference((PsiManager)this.getManager(), this.getClassReference().getText(), (PsiClass)resolved, resolveResult.getSubstitutor());
    }

    @Nullable
    public PsiAnnotationMemberValue findAttributeValue(@Nullable String attributeName) {
        return PsiImplUtil.findAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@Nullable @NonNls String attributeName, T value) {
        return (T)PsiImplUtil.setDeclaredAttributeValue((PsiAnnotation)this, (String)attributeName, value, ANNOTATION_CREATOR);
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return null;
    }

    @Override
    @NotNull
    public GrCodeReferenceElement getClassReference() {
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (stub != null) {
            GrCodeReferenceElement grCodeReferenceElement = stub.getPsiElement().getClassReference();
            if (grCodeReferenceElement == null) {
                GrAnnotationImpl.$$$reportNull$$$0(3);
            }
            return grCodeReferenceElement;
        }
        GrCodeReferenceElement grCodeReferenceElement = (GrCodeReferenceElement)this.findNotNullChildByClass(GrCodeReferenceElement.class);
        if (grCodeReferenceElement == null) {
            GrAnnotationImpl.$$$reportNull$$$0(4);
        }
        return grCodeReferenceElement;
    }

    @Override
    @NotNull
    public String getShortName() {
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (stub != null) {
            String string = stub.getPsiElement().getShortName();
            if (string == null) {
                GrAnnotationImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        String referenceName = this.getClassReference().getReferenceName();
        assert (referenceName != null);
        String string = referenceName;
        if (string == null) {
            GrAnnotationImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public PsiAnnotationOwner getOwner() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiAnnotationOwner ? (PsiAnnotationOwner)parent : null;
    }

    @NotNull
    public static PsiAnnotation.TargetType[] getApplicableElementTypeFields(PsiElement owner) {
        if (owner instanceof PsiClass) {
            PsiClass aClass = (PsiClass)owner;
            if (aClass.isAnnotationType()) {
                PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE};
                if (targetTypeArray == null) {
                    GrAnnotationImpl.$$$reportNull$$$0(7);
                }
                return targetTypeArray;
            }
            if (aClass instanceof GrTypeParameter) {
                PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_PARAMETER};
                if (targetTypeArray == null) {
                    GrAnnotationImpl.$$$reportNull$$$0(8);
                }
                return targetTypeArray;
            }
            PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE};
            if (targetTypeArray == null) {
                GrAnnotationImpl.$$$reportNull$$$0(9);
            }
            return targetTypeArray;
        }
        if (owner instanceof GrMethod) {
            if (((PsiMethod)owner).isConstructor()) {
                PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.CONSTRUCTOR};
                if (targetTypeArray == null) {
                    GrAnnotationImpl.$$$reportNull$$$0(10);
                }
                return targetTypeArray;
            }
            PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD};
            if (targetTypeArray == null) {
                GrAnnotationImpl.$$$reportNull$$$0(11);
            }
            return targetTypeArray;
        }
        if (owner instanceof GrVariableDeclaration) {
            GrVariable[] variables = ((GrVariableDeclaration)owner).getVariables();
            if (variables.length == 0) {
                if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
                    GrAnnotationImpl.$$$reportNull$$$0(12);
                }
                return PsiAnnotation.TargetType.EMPTY_ARRAY;
            }
            if (variables[0] instanceof GrField || ResolveUtil.isScriptField(variables[0])) {
                PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.FIELD};
                if (targetTypeArray == null) {
                    GrAnnotationImpl.$$$reportNull$$$0(13);
                }
                return targetTypeArray;
            }
            PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.LOCAL_VARIABLE};
            if (targetTypeArray == null) {
                GrAnnotationImpl.$$$reportNull$$$0(14);
            }
            return targetTypeArray;
        }
        if (owner instanceof GrParameter) {
            PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER};
            if (targetTypeArray == null) {
                GrAnnotationImpl.$$$reportNull$$$0(15);
            }
            return targetTypeArray;
        }
        if (owner instanceof GrPackageDefinition) {
            PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PACKAGE};
            if (targetTypeArray == null) {
                GrAnnotationImpl.$$$reportNull$$$0(16);
            }
            return targetTypeArray;
        }
        if (owner instanceof GrTypeElement) {
            PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE};
            if (targetTypeArray == null) {
                GrAnnotationImpl.$$$reportNull$$$0(17);
            }
            return targetTypeArray;
        }
        if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
            GrAnnotationImpl.$$$reportNull$$$0(18);
        }
        return PsiAnnotation.TargetType.EMPTY_ARRAY;
    }

    public static boolean isAnnotationApplicableTo(GrAnnotation annotation, PsiAnnotation.TargetType ... elementTypeFields) {
        if (elementTypeFields == null) {
            GrAnnotationImpl.$$$reportNull$$$0(19);
        }
        return elementTypeFields.length == 0 || AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])elementTypeFields) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypeFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableElementTypeFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotationApplicableTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

