/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.types;

import com.intellij.lang.PsiBuilder;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ReferenceElement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeSpec;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class TypeArguments {
    public static boolean parseTypeArguments(PsiBuilder builder, boolean expressionPossible) {
        return TypeArguments.parseTypeArguments(builder, expressionPossible, false);
    }

    public static boolean parseTypeArguments(PsiBuilder builder, boolean expressionPossible, boolean allowDiamond) {
        PsiBuilder.Marker marker = builder.mark();
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mLT)) {
            marker.rollbackTo();
            return false;
        }
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (allowDiamond && ParserUtils.getToken(builder, GroovyTokenTypes.mGT)) {
            marker.done(GroovyElementTypes.TYPE_ARGUMENTS);
            return true;
        }
        if (!TypeArguments.parseArgument(builder)) {
            builder.error(GroovyBundle.message("type.argument.expected", new Object[0]));
            if (ParserUtils.getToken(builder, GroovyTokenTypes.mGT)) {
                marker.done(GroovyElementTypes.TYPE_ARGUMENTS);
                return true;
            }
            marker.rollbackTo();
            return false;
        }
        boolean hasComma = ParserUtils.lookAhead(builder, GroovyTokenTypes.mCOMMA);
        while (ParserUtils.getToken(builder, GroovyTokenTypes.mCOMMA)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            if (TypeArguments.parseArgument(builder)) continue;
            builder.error("type.argument.expected");
        }
        PsiBuilder.Marker rb = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (ParserUtils.getToken(builder, GroovyTokenTypes.mGT)) {
            rb.drop();
        } else if (hasComma) {
            rb.rollbackTo();
            builder.error(GroovyBundle.message("gt.expected", new Object[0]));
        } else {
            rb.drop();
            if (expressionPossible) {
                marker.rollbackTo();
                return false;
            }
            builder.error(GroovyBundle.message("gt.expected", new Object[0]));
        }
        marker.done(GroovyElementTypes.TYPE_ARGUMENTS);
        return true;
    }

    private static boolean parseArgument(PsiBuilder builder) {
        if (builder.getTokenType() == GroovyTokenTypes.mQUESTION) {
            PsiBuilder.Marker taMarker = builder.mark();
            ParserUtils.getToken(builder, GroovyTokenTypes.mQUESTION);
            if (ParserUtils.getToken(builder, GroovyTokenTypes.kSUPER) || ParserUtils.getToken(builder, GroovyTokenTypes.kEXTENDS)) {
                ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
                TypeSpec.parse(builder, false, false);
                ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            }
            taMarker.done(GroovyElementTypes.TYPE_ARGUMENT);
            return true;
        }
        return TypeSpec.parse(builder, false, false) != ReferenceElement.ReferenceElementResult.FAIL;
    }
}

