/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.relational;

import com.intellij.lang.PsiBuilder;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic.ShiftExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ReferenceElement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeSpec;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class RelationalExpression {
    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        if (ShiftExpression.parse(builder, parser)) {
            if (ParserUtils.getToken(builder, TokenSets.RELATIONS) || RelationalExpression.getCompositeSign(builder)) {
                ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
                ShiftExpression.parse(builder, parser);
                marker.done(GroovyElementTypes.RELATIONAL_EXPRESSION);
            } else if (GroovyTokenTypes.kINSTANCEOF.equals(builder.getTokenType())) {
                RelationalExpression.advanceLexerAndParseType(builder);
                marker.done(GroovyElementTypes.INSTANCEOF_EXPRESSION);
            } else if (GroovyTokenTypes.kAS.equals(builder.getTokenType())) {
                RelationalExpression.advanceLexerAndParseType(builder);
                marker.done(GroovyElementTypes.SAFE_CAST_EXPRESSION);
            } else {
                marker.drop();
            }
            return true;
        }
        marker.drop();
        return false;
    }

    private static void advanceLexerAndParseType(PsiBuilder builder) {
        builder.advanceLexer();
        PsiBuilder.Marker rb = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (TypeSpec.parse(builder) == ReferenceElement.ReferenceElementResult.FAIL) {
            rb.rollbackTo();
            builder.error(GroovyBundle.message("type.specification.expected", new Object[0]));
        } else {
            rb.drop();
        }
    }

    private static boolean getCompositeSign(PsiBuilder builder) {
        if (ParserUtils.lookAhead(builder, GroovyTokenTypes.mGT, GroovyTokenTypes.mASSIGN)) {
            PsiBuilder.Marker marker = builder.mark();
            for (int i = 0; i < 2; ++i) {
                builder.advanceLexer();
            }
            marker.done(GroovyElementTypes.MORE_OR_EQUALS_SIGN);
            return true;
        }
        return false;
    }
}

