/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arguments.ArgumentList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.CompoundStringExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.PrimaryExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeArguments;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class PathExpression {
    private static final TokenSet DOTS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSPREAD_DOT, GroovyTokenTypes.mOPTIONAL_DOT, GroovyTokenTypes.mMEMBER_POINTER, GroovyTokenTypes.mDOT});
    private static final TokenSet PATH_ELEMENT_START = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSPREAD_DOT, GroovyTokenTypes.mOPTIONAL_DOT, GroovyTokenTypes.mMEMBER_POINTER, GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mLPAREN, GroovyTokenTypes.mLCURLY, GroovyTokenTypes.mDOT});

    public static boolean parse(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(0);
        }
        if (parser == null) {
            PathExpression.$$$reportNull$$$0(1);
        }
        return PathExpression.parsePathExprQualifierForExprStatement(builder, parser) != Result.WRONG_WAY;
    }

    @NotNull
    public static Result parsePathExprQualifierForExprStatement(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(2);
        }
        if (parser == null) {
            PathExpression.$$$reportNull$$$0(3);
        }
        PsiBuilder.Marker marker = builder.mark();
        IElementType qualifierType = PrimaryExpression.parsePrimaryExpression(builder, parser);
        if (qualifierType != GroovyElementTypes.WRONGWAY) {
            Result result2 = PathExpression.parseAfterQualifier(builder, parser, marker, qualifierType);
            if (result2 == null) {
                PathExpression.$$$reportNull$$$0(4);
            }
            return result2;
        }
        marker.drop();
        Result result3 = Result.WRONG_WAY;
        if (result3 == null) {
            PathExpression.$$$reportNull$$$0(5);
        }
        return result3;
    }

    @NotNull
    private static Result parseAfterQualifier(@NotNull PsiBuilder builder, @NotNull GroovyParser parser, @NotNull PsiBuilder.Marker marker, @NotNull IElementType qualifierType) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(6);
        }
        if (parser == null) {
            PathExpression.$$$reportNull$$$0(7);
        }
        if (marker == null) {
            PathExpression.$$$reportNull$$$0(8);
        }
        if (qualifierType == null) {
            PathExpression.$$$reportNull$$$0(9);
        }
        if (PathExpression.isPathElementStart(builder)) {
            if (PathExpression.isLParenthOrLCurlyAfterLiteral(builder, qualifierType)) {
                marker.rollbackTo();
                PsiBuilder.Marker newMarker = builder.mark();
                IElementType newQualifierType = PrimaryExpression.parsePrimaryExpression(builder, parser, true);
                assert (newQualifierType != GroovyElementTypes.WRONGWAY);
                Result result2 = PathExpression.parseAfterReference(builder, parser, newMarker);
                if (result2 == null) {
                    PathExpression.$$$reportNull$$$0(10);
                }
                return result2;
            }
            Result result3 = PathExpression.parseAfterReference(builder, parser, marker);
            if (result3 == null) {
                PathExpression.$$$reportNull$$$0(11);
            }
            return result3;
        }
        marker.drop();
        if (qualifierType == GroovyElementTypes.LITERAL) {
            Result result4 = Result.LITERAL;
            if (result4 == null) {
                PathExpression.$$$reportNull$$$0(12);
            }
            return result4;
        }
        Result result5 = Result.INVOKED_EXPR;
        if (result5 == null) {
            PathExpression.$$$reportNull$$$0(13);
        }
        return result5;
    }

    private static boolean isLParenthOrLCurlyAfterLiteral(@NotNull PsiBuilder builder, @NotNull IElementType qualifierType) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(14);
        }
        if (qualifierType == null) {
            PathExpression.$$$reportNull$$$0(15);
        }
        return qualifierType == GroovyElementTypes.LITERAL && (PathExpression.checkForLParenth(builder) || PathExpression.checkForLCurly(builder));
    }

    @NotNull
    private static Result pathElementParse(@NotNull PsiBuilder builder, @NotNull PsiBuilder.Marker marker, @NotNull GroovyParser parser, @NotNull Result result2) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(16);
        }
        if (marker == null) {
            PathExpression.$$$reportNull$$$0(17);
        }
        if (parser == null) {
            PathExpression.$$$reportNull$$$0(18);
        }
        if (result2 == null) {
            PathExpression.$$$reportNull$$$0(19);
        }
        if (PathExpression.parseQualificationDot(builder)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            TypeArguments.parseTypeArguments(builder, true);
            IElementType res = PathExpression.namePartParse(builder, parser);
            if (res != GroovyElementTypes.WRONGWAY) {
                PsiBuilder.Marker newMarker = marker.precede();
                marker.done(res);
                Result result3 = PathExpression.parseAfterReference(builder, parser, newMarker);
                if (result3 == null) {
                    PathExpression.$$$reportNull$$$0(20);
                }
                return result3;
            }
            builder.error(GroovyBundle.message("path.selector.expected", new Object[0]));
            marker.drop();
            Result result4 = result2;
            if (result4 == null) {
                PathExpression.$$$reportNull$$$0(21);
            }
            return result4;
        }
        if (PathExpression.checkForLParenth(builder)) {
            PrimaryExpression.methodCallArgsParse(builder, parser);
            Result result5 = PathExpression.parseAfterArguments(builder, marker, parser);
            if (result5 == null) {
                PathExpression.$$$reportNull$$$0(22);
            }
            return result5;
        }
        if (PathExpression.checkForLCurly(builder)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            PathExpression.appendedBlockParse(builder, parser);
            Result result6 = PathExpression.parseAfterArguments(builder, marker, parser);
            if (result6 == null) {
                PathExpression.$$$reportNull$$$0(23);
            }
            return result6;
        }
        if (PathExpression.checkForArrayAccess(builder)) {
            PathExpression.indexPropertyArgsParse(builder, parser);
            PsiBuilder.Marker newMarker = marker.precede();
            marker.done(GroovyElementTypes.PATH_INDEX_PROPERTY);
            Result result7 = PathExpression.parseAfterReference(builder, parser, newMarker);
            if (result7 == null) {
                PathExpression.$$$reportNull$$$0(24);
            }
            return result7;
        }
        marker.drop();
        Result result8 = result2;
        if (result8 == null) {
            PathExpression.$$$reportNull$$$0(25);
        }
        return result8;
    }

    private static boolean parseQualificationDot(@NotNull PsiBuilder builder) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(26);
        }
        return ParserUtils.getToken(builder, DOTS) || ParserUtils.getToken(builder, GroovyTokenTypes.mNLS, DOTS);
    }

    public static boolean isQualificationDotAhead(@NotNull PsiBuilder builder) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(27);
        }
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        boolean result2 = PathExpression.parseQualificationDot(builder);
        mark.rollbackTo();
        return result2;
    }

    public static boolean isQualificationDot(@NotNull PsiBuilder builder) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(28);
        }
        return DOTS.contains(builder.getTokenType()) || ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, DOTS);
    }

    @NotNull
    private static Result parseAfterReference(@NotNull PsiBuilder builder, @NotNull GroovyParser parser, @NotNull PsiBuilder.Marker newMarker) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(29);
        }
        if (parser == null) {
            PathExpression.$$$reportNull$$$0(30);
        }
        if (newMarker == null) {
            PathExpression.$$$reportNull$$$0(31);
        }
        if (PathExpression.checkForLCurly(builder)) {
            PsiBuilder.Marker argsMarker = builder.mark();
            argsMarker.done(GroovyElementTypes.ARGUMENTS);
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            Result result2 = PathExpression.pathElementParse(builder, newMarker, parser, Result.METHOD_CALL);
            if (result2 == null) {
                PathExpression.$$$reportNull$$$0(32);
            }
            return result2;
        }
        Result result3 = PathExpression.pathElementParse(builder, newMarker, parser, Result.INVOKED_EXPR);
        if (result3 == null) {
            PathExpression.$$$reportNull$$$0(33);
        }
        return result3;
    }

    @NotNull
    private static Result parseAfterArguments(@NotNull PsiBuilder builder, @NotNull PsiBuilder.Marker marker, @NotNull GroovyParser parser) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(34);
        }
        if (marker == null) {
            PathExpression.$$$reportNull$$$0(35);
        }
        if (parser == null) {
            PathExpression.$$$reportNull$$$0(36);
        }
        if (PathExpression.checkForLCurly(builder)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            Result result2 = PathExpression.pathElementParse(builder, marker, parser, Result.METHOD_CALL);
            if (result2 == null) {
                PathExpression.$$$reportNull$$$0(37);
            }
            return result2;
        }
        PsiBuilder.Marker newMarker = marker.precede();
        marker.done((IElementType)GroovyElementTypes.PATH_METHOD_CALL);
        Result result3 = PathExpression.pathElementParse(builder, newMarker, parser, Result.METHOD_CALL);
        if (result3 == null) {
            PathExpression.$$$reportNull$$$0(38);
        }
        return result3;
    }

    private static boolean checkForLCurly(@NotNull PsiBuilder builder) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(39);
        }
        return ParserUtils.lookAhead(builder, GroovyTokenTypes.mLCURLY) || ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, GroovyTokenTypes.mLCURLY);
    }

    private static boolean checkForLParenth(@NotNull PsiBuilder builder) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(40);
        }
        return builder.getTokenType() == GroovyTokenTypes.mLPAREN;
    }

    public static boolean checkForArrayAccess(@NotNull PsiBuilder builder) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(41);
        }
        return builder.getTokenType() == GroovyTokenTypes.mLBRACK && !ParserUtils.lookAhead(builder, GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mCOLON) && !ParserUtils.lookAhead(builder, GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mNLS, GroovyTokenTypes.mCOLON);
    }

    @NotNull
    public static IElementType namePartParse(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(42);
        }
        if (parser == null) {
            PathExpression.$$$reportNull$$$0(43);
        }
        ParserUtils.getToken(builder, GroovyTokenTypes.mAT);
        if (ParserUtils.getToken(builder, GroovyTokenTypes.mIDENT) || ParserUtils.getToken(builder, GroovyTokenTypes.mSTRING_LITERAL) || ParserUtils.getToken(builder, GroovyTokenTypes.mGSTRING_LITERAL)) {
            GroovyElementType groovyElementType = GroovyElementTypes.REFERENCE_EXPRESSION;
            if (groovyElementType == null) {
                PathExpression.$$$reportNull$$$0(44);
            }
            return groovyElementType;
        }
        IElementType tokenType = builder.getTokenType();
        if (tokenType == GroovyTokenTypes.mGSTRING_BEGIN) {
            boolean result2 = CompoundStringExpression.parse(builder, parser, true, GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mGSTRING_END, null, GroovyElementTypes.GSTRING, GroovyBundle.message("string.end.expected", new Object[0]));
            Object object = result2 ? GroovyElementTypes.PATH_PROPERTY_REFERENCE : GroovyElementTypes.REFERENCE_EXPRESSION;
            if (object == null) {
                PathExpression.$$$reportNull$$$0(45);
            }
            return object;
        }
        if (tokenType == GroovyTokenTypes.mREGEX_BEGIN) {
            boolean result3 = CompoundStringExpression.parse(builder, parser, true, GroovyTokenTypes.mREGEX_BEGIN, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mREGEX_LITERAL, GroovyElementTypes.REGEX, GroovyBundle.message("regex.end.expected", new Object[0]));
            Object object = result3 ? GroovyElementTypes.PATH_PROPERTY_REFERENCE : GroovyElementTypes.REFERENCE_EXPRESSION;
            if (object == null) {
                PathExpression.$$$reportNull$$$0(46);
            }
            return object;
        }
        if (tokenType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN) {
            boolean result4 = CompoundStringExpression.parse(builder, parser, true, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL, GroovyElementTypes.REGEX, GroovyBundle.message("dollar.slash.end.expected", new Object[0]));
            Object object = result4 ? GroovyElementTypes.PATH_PROPERTY_REFERENCE : GroovyElementTypes.REFERENCE_EXPRESSION;
            if (object == null) {
                PathExpression.$$$reportNull$$$0(47);
            }
            return object;
        }
        if (tokenType == GroovyTokenTypes.mLCURLY) {
            OpenOrClosableBlock.parseOpenBlock(builder, parser);
            IElementType iElementType = GroovyElementTypes.PATH_PROPERTY_REFERENCE;
            if (iElementType == null) {
                PathExpression.$$$reportNull$$$0(48);
            }
            return iElementType;
        }
        if (tokenType == GroovyTokenTypes.mLPAREN) {
            PrimaryExpression.parenthesizedExprParse(builder, parser);
            IElementType iElementType = GroovyElementTypes.PATH_PROPERTY_REFERENCE;
            if (iElementType == null) {
                PathExpression.$$$reportNull$$$0(49);
            }
            return iElementType;
        }
        if (TokenSets.KEYWORDS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            GroovyElementType groovyElementType = GroovyElementTypes.REFERENCE_EXPRESSION;
            if (groovyElementType == null) {
                PathExpression.$$$reportNull$$$0(50);
            }
            return groovyElementType;
        }
        IElementType iElementType = GroovyElementTypes.WRONGWAY;
        if (iElementType == null) {
            PathExpression.$$$reportNull$$$0(51);
        }
        return iElementType;
    }

    @NotNull
    public static IElementType indexPropertyArgsParse(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(52);
        }
        if (parser == null) {
            PathExpression.$$$reportNull$$$0(53);
        }
        assert (builder.getTokenType() == GroovyTokenTypes.mLBRACK);
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.mLBRACK);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        ArgumentList.parseArgumentList(builder, GroovyTokenTypes.mRBRACK, parser);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        ParserUtils.getToken(builder, GroovyTokenTypes.mRBRACK, GroovyBundle.message("rbrack.expected", new Object[0]));
        marker.done(GroovyElementTypes.ARGUMENTS);
        IElementType iElementType = GroovyElementTypes.PATH_INDEX_PROPERTY;
        if (iElementType == null) {
            PathExpression.$$$reportNull$$$0(54);
        }
        return iElementType;
    }

    @NotNull
    private static IElementType appendedBlockParse(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(55);
        }
        if (parser == null) {
            PathExpression.$$$reportNull$$$0(56);
        }
        IElementType iElementType = OpenOrClosableBlock.parseClosableBlock(builder, parser);
        if (iElementType == null) {
            PathExpression.$$$reportNull$$$0(57);
        }
        return iElementType;
    }

    private static boolean isPathElementStart(@NotNull PsiBuilder builder) {
        if (builder == null) {
            PathExpression.$$$reportNull$$$0(58);
        }
        if (PATH_ELEMENT_START.contains(builder.getTokenType())) {
            return true;
        }
        PsiBuilder.Marker marker = builder.mark();
        try {
            boolean bl = ParserUtils.getToken(builder, GroovyTokenTypes.mNLS) && (ParserUtils.getToken(builder, TokenSets.DOTS) || ParserUtils.getToken(builder, GroovyTokenTypes.mLCURLY));
            return bl;
        }
        finally {
            marker.rollbackTo();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 18: 
            case 30: 
            case 36: 
            case 43: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression";
                break;
            }
            case 8: 
            case 17: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePathExprQualifierForExprStatement";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAfterQualifier";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "pathElementParse";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAfterReference";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAfterArguments";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "namePartParse";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "indexPropertyArgsParse";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "appendedBlockParse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parsePathExprQualifierForExprStatement";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseAfterQualifier";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isLParenthOrLCurlyAfterLiteral";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "pathElementParse";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseQualificationDot";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isQualificationDotAhead";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isQualificationDot";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parseAfterReference";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "parseAfterArguments";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkForLCurly";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkForLParenth";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkForArrayAccess";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "namePartParse";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "indexPropertyArgsParse";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "appendedBlockParse";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isPathElementStart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Result {
        INVOKED_EXPR,
        METHOD_CALL,
        WRONG_WAY,
        LITERAL;

    }
}

