/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic.MultiplicativeExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic.UnaryExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.regex.RegexExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.relational.RelationalExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class BinaryExpression {
    private static final BinaryExpression[] ourLogicalExpressions = new BinaryExpression[]{new BinaryExpression(GroovyElementTypes.LOGICAL_OR_EXPRESSION, GroovyTokenTypes.mLOR), new BinaryExpression(GroovyElementTypes.LOGICAL_AND_EXPRESSION, GroovyTokenTypes.mLAND), new BinaryExpression(GroovyElementTypes.INCLUSIVE_OR_EXPRESSION, GroovyTokenTypes.mBOR), new BinaryExpression(GroovyElementTypes.EXCLUSIVE_OR_EXPRESSION, GroovyTokenTypes.mBXOR), new BinaryExpression(GroovyElementTypes.AND_EXPRESSION, new IElementType[]{GroovyTokenTypes.mBAND}){

        @Override
        protected boolean parseNext(PsiBuilder builder, GroovyParser parser, int order) {
            return RegexExpression.parse(builder, parser);
        }
    }};
    public static final BinaryExpression EQUALITY = new BinaryExpression(GroovyElementTypes.EQUALITY_EXPRESSION, new IElementType[]{GroovyTokenTypes.mEQUAL, GroovyTokenTypes.mNOT_EQUAL, GroovyTokenTypes.mCOMPARE_TO}){

        @Override
        protected boolean parseNext(PsiBuilder builder, GroovyParser parser, int order) {
            return RelationalExpression.parse(builder, parser);
        }
    };
    public static final BinaryExpression ADDITIVE = new BinaryExpression(GroovyElementTypes.ADDITIVE_EXPRESSION, new IElementType[]{GroovyTokenTypes.mPLUS, GroovyTokenTypes.mMINUS}){

        @Override
        protected boolean parseNext(PsiBuilder builder, GroovyParser parser, int order) {
            return MultiplicativeExpression.parse(builder, parser);
        }
    };
    public static final BinaryExpression POWER = new BinaryExpression(GroovyElementTypes.POWER_EXPRESSION, new IElementType[]{GroovyTokenTypes.mSTAR_STAR}){

        @Override
        protected boolean parseNext(PsiBuilder builder, GroovyParser parser, int order) {
            return UnaryExpression.parse(builder, parser);
        }
    };
    private final IElementType myCompositeType;
    private final TokenSet myOpTokens;

    public BinaryExpression(IElementType compositeType, IElementType ... opTokens) {
        this.myCompositeType = compositeType;
        this.myOpTokens = TokenSet.create((IElementType[])opTokens);
    }

    public static boolean parseLogicalExpression(PsiBuilder builder, GroovyParser parser) {
        return ourLogicalExpressions[0].parseBinary(builder, parser);
    }

    protected boolean parseNext(PsiBuilder builder, GroovyParser parser, int order) {
        return ourLogicalExpressions[order + 1].parseBinary(builder, parser, order + 1);
    }

    public final boolean parseBinary(PsiBuilder builder, GroovyParser parser) {
        return this.parseBinary(builder, parser, 0);
    }

    private boolean parseBinary(PsiBuilder builder, GroovyParser parser, int order) {
        PsiBuilder.Marker marker = builder.mark();
        if (this.parseNext(builder, parser, order)) {
            if (ParserUtils.getToken(builder, this.myOpTokens)) {
                ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
                if (!this.parseNext(builder, parser, order)) {
                    builder.error(GroovyBundle.message("expression.expected", new Object[0]));
                }
                PsiBuilder.Marker newMarker = marker.precede();
                marker.done(this.myCompositeType);
                if (this.myOpTokens.contains(builder.getTokenType())) {
                    this.subParse(builder, newMarker, parser, order);
                } else {
                    newMarker.drop();
                }
            } else {
                marker.drop();
            }
            return true;
        }
        marker.drop();
        return false;
    }

    private void subParse(PsiBuilder builder, PsiBuilder.Marker marker, GroovyParser parser, int order) {
        builder.advanceLexer();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (!this.parseNext(builder, parser, order)) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        PsiBuilder.Marker newMarker = marker.precede();
        marker.done(this.myCompositeType);
        if (this.myOpTokens.contains(builder.getTokenType())) {
            this.subParse(builder, newMarker, parser, order);
        } else {
            newMarker.drop();
        }
    }
}

