/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions;

import com.intellij.lang.PsiBuilder;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.TupleParse;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.ConditionalExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.ExpressionStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class AssignmentExpression {
    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        return AssignmentExpression.parse(builder, parser, false);
    }

    public static boolean parse(PsiBuilder builder, GroovyParser parser, boolean comExprAllowed) {
        PsiBuilder.Marker marker = builder.mark();
        boolean isTuple = ParserUtils.lookAhead(builder, GroovyTokenTypes.mLPAREN, GroovyTokenTypes.mIDENT, GroovyTokenTypes.mCOMMA);
        if (AssignmentExpression.parseSide(builder, parser, isTuple, comExprAllowed)) {
            if (isTuple) {
                if (ParserUtils.getToken(builder, GroovyTokenTypes.mASSIGN)) {
                    ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
                    if (!AssignmentExpression.parse(builder, parser, comExprAllowed)) {
                        builder.error(GroovyBundle.message("expression.expected", new Object[0]));
                    }
                } else {
                    builder.error(GroovyBundle.message("assign.expected", new Object[0]));
                }
                marker.done(GroovyElementTypes.TUPLE_ASSIGNMENT_EXPRESSION);
            } else if (ParserUtils.getToken(builder, TokenSets.ASSIGNMENTS)) {
                ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
                if (!AssignmentExpression.parse(builder, parser, comExprAllowed)) {
                    builder.error(GroovyBundle.message("expression.expected", new Object[0]));
                }
                marker.done(GroovyElementTypes.ASSIGNMENT_EXPRESSION);
            } else {
                marker.drop();
            }
            return true;
        }
        marker.drop();
        return false;
    }

    private static boolean parseSide(PsiBuilder builder, GroovyParser parser, boolean tuple, boolean comExprAllowed) {
        if (tuple) {
            return TupleParse.parseTupleForAssignment(builder);
        }
        if (comExprAllowed) {
            PsiBuilder.Marker marker = builder.mark();
            ExpressionStatement.Result result2 = ExpressionStatement.parse(builder, parser);
            switch (result2) {
                case EXPR_STATEMENT: {
                    marker.drop();
                    return true;
                }
                case EXPRESSION: {
                    ConditionalExpression.parseAfterCondition(builder, parser, marker);
                    return true;
                }
                case WRONG_WAY: {
                    marker.rollbackTo();
                }
            }
        }
        return ConditionalExpression.parse(builder, parser);
    }
}

