/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.constructor;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.Separators;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arguments.ArgumentList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class ConstructorBody {
    public static void parseConstructorBody(PsiBuilder builder, GroovyParser parser) {
        assert (builder.getTokenType() == GroovyTokenTypes.mLCURLY);
        if (parser.parseDeep()) {
            ConstructorBody.parseConstructorBodyDeep(builder, parser);
        } else {
            OpenOrClosableBlock.parseBlockShallow(builder, (IElementType)GroovyElementTypes.CONSTRUCTOR_BODY);
        }
    }

    public static void parseConstructorBodyDeep(PsiBuilder builder, GroovyParser parser) {
        assert (builder.getTokenType() == GroovyTokenTypes.mLCURLY);
        PsiBuilder.Marker cbMarker = builder.mark();
        builder.advanceLexer();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        PsiBuilder.Marker constructorInvocationMarker = builder.mark();
        if (ConstructorBody.parseExplicitConstructor(builder, parser)) {
            constructorInvocationMarker.done(GroovyElementTypes.EXPLICIT_CONSTRUCTOR);
        } else {
            constructorInvocationMarker.rollbackTo();
        }
        Separators.parse(builder);
        parser.parseBlockBody(builder);
        if (builder.getTokenType() != GroovyTokenTypes.mRCURLY) {
            builder.error(GroovyBundle.message("rcurly.expected", new Object[0]));
        } else {
            builder.advanceLexer();
        }
        cbMarker.done((IElementType)GroovyElementTypes.CONSTRUCTOR_BODY);
    }

    private static boolean parseExplicitConstructor(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker;
        boolean result2 = false;
        if (ParserUtils.lookAhead(builder, GroovyTokenTypes.kTHIS, GroovyTokenTypes.mLPAREN)) {
            marker = builder.mark();
            ParserUtils.getToken(builder, GroovyTokenTypes.kTHIS);
            marker.done((IElementType)GroovyElementTypes.REFERENCE_EXPRESSION);
            result2 = true;
        }
        if (ParserUtils.lookAhead(builder, GroovyTokenTypes.kSUPER, GroovyTokenTypes.mLPAREN)) {
            marker = builder.mark();
            ParserUtils.getToken(builder, GroovyTokenTypes.kSUPER);
            marker.done((IElementType)GroovyElementTypes.REFERENCE_EXPRESSION);
            result2 = true;
        }
        if (result2) {
            marker = builder.mark();
            ParserUtils.getToken(builder, GroovyTokenTypes.mLPAREN);
            ArgumentList.parseArgumentList(builder, GroovyTokenTypes.mRPAREN, parser);
            ParserUtils.getToken(builder, GroovyTokenTypes.mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]));
            marker.done(GroovyElementTypes.ARGUMENTS);
            return true;
        }
        return false;
    }
}

