/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.parameters.ParameterList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class OpenOrClosableBlock {
    public static boolean parseOpenBlock(PsiBuilder builder, GroovyParser parser) {
        if (builder.getTokenType() != GroovyTokenTypes.mLCURLY) {
            return false;
        }
        if (parser.parseDeep()) {
            OpenOrClosableBlock.parseOpenBlockDeep(builder, parser);
        } else {
            OpenOrClosableBlock.parseBlockShallow(builder, (IElementType)GroovyElementTypes.OPEN_BLOCK);
        }
        return true;
    }

    public static void parseOpenBlockDeep(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        parser.parseBlockBody(builder);
        if (!builder.eof() && builder.getTokenType() != GroovyTokenTypes.mRCURLY) {
            builder.error(GroovyBundle.message("statement.expected", new Object[0]));
            ParserUtils.skipCountingBraces(builder, GroovyParser.RCURLY_ONLY);
        }
        ParserUtils.getToken(builder, GroovyTokenTypes.mRCURLY, GroovyBundle.message("rcurly.expected", new Object[0]));
        marker.done((IElementType)GroovyElementTypes.OPEN_BLOCK);
    }

    public static IElementType parseClosableBlock(PsiBuilder builder, GroovyParser parser) {
        assert (builder.getTokenType() == GroovyTokenTypes.mLCURLY) : builder.getTokenType();
        if (parser.parseDeep()) {
            OpenOrClosableBlock.parseClosableBlockDeep(builder, parser);
        } else {
            OpenOrClosableBlock.parseBlockShallow(builder, (IElementType)GroovyElementTypes.CLOSABLE_BLOCK);
        }
        return GroovyElementTypes.CLOSABLE_BLOCK;
    }

    public static void parseBlockShallow(PsiBuilder builder, IElementType blockType) {
        PsiBuilderUtil.parseBlockLazy((PsiBuilder)builder, (IElementType)GroovyTokenTypes.mLCURLY, (IElementType)GroovyTokenTypes.mRCURLY, (IElementType)blockType);
    }

    public static void parseClosableBlockDeep(PsiBuilder builder, GroovyParser parser) {
        assert (builder.getTokenType() == GroovyTokenTypes.mLCURLY) : builder.getTokenType();
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        OpenOrClosableBlock.closableBlockParamsOpt(builder, parser);
        parser.parseBlockBody(builder);
        ParserUtils.getToken(builder, GroovyTokenTypes.mRCURLY, GroovyBundle.message("rcurly.expected", new Object[0]));
        marker.done((IElementType)GroovyElementTypes.CLOSABLE_BLOCK);
    }

    private static void closableBlockParamsOpt(PsiBuilder builder, GroovyParser parser) {
        ParameterList.parse(builder, GroovyTokenTypes.mCLOSABLE_BLOCK_OP, parser);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        ParserUtils.getToken(builder, GroovyTokenTypes.mCLOSABLE_BLOCK_OP);
    }
}

