/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeSpec;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class TupleParse {
    public static boolean parseTupleForAssignment(PsiBuilder builder) {
        PsiBuilder.Marker marker = TupleParse.parseTuple(builder, GroovyElementTypes.REFERENCE_EXPRESSION, false);
        if (marker == null) {
            return false;
        }
        marker.done(GroovyElementTypes.TUPLE);
        return true;
    }

    public static boolean parseTupleForVariableDeclaration(PsiBuilder builder) {
        PsiBuilder.Marker marker = TupleParse.parseTuple(builder, (IElementType)GroovyElementTypes.VARIABLE, true);
        if (marker == null) {
            return false;
        }
        marker.drop();
        return true;
    }

    public static PsiBuilder.Marker parseTuple(PsiBuilder builder, IElementType componentType, boolean acceptType) {
        if (builder.getTokenType() != GroovyTokenTypes.mLPAREN) {
            return null;
        }
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        int count = 0;
        while (true) {
            if (ParserUtils.getToken(builder, GroovyTokenTypes.mCOMMA)) {
                ++count;
                builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
                continue;
            }
            if (acceptType) {
                PsiBuilder.Marker typeMarker = builder.mark();
                TypeSpec.parse(builder);
                if (builder.getTokenType() != GroovyTokenTypes.mIDENT) {
                    typeMarker.rollbackTo();
                } else {
                    typeMarker.drop();
                }
            }
            PsiBuilder.Marker componentMarker = builder.mark();
            if (!ParserUtils.getToken(builder, GroovyTokenTypes.mIDENT)) {
                builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
                componentMarker.drop();
            } else {
                componentMarker.done(componentType);
                ++count;
            }
            if (!ParserUtils.getToken(builder, GroovyTokenTypes.mCOMMA)) break;
        }
        if (ParserUtils.getToken(builder, GroovyTokenTypes.mRPAREN)) {
            return marker;
        }
        if (count > 0) {
            builder.error(GroovyBundle.message("comma.or.rparen.expected", new Object[0]));
            return marker;
        }
        marker.rollbackTo();
        return null;
    }
}

