/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements;

import com.intellij.lang.PsiBuilder;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.parameters.ParameterDeclaration;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class TryCatchStatement {
    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.kTRY);
        PsiBuilder.Marker warn = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (!OpenOrClosableBlock.parseOpenBlock(builder, parser)) {
            warn.rollbackTo();
            builder.error(GroovyBundle.message("lcurly.expected", new Object[0]));
            marker.drop();
            return true;
        }
        warn.drop();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (builder.getTokenType() != GroovyTokenTypes.kCATCH && builder.getTokenType() != GroovyTokenTypes.kFINALLY) {
            builder.error(GroovyBundle.message("catch.or.finally.expected", new Object[0]));
            marker.done(GroovyElementTypes.TRY_BLOCK_STATEMENT);
            return true;
        }
        if (GroovyTokenTypes.kCATCH.equals(builder.getTokenType())) {
            TryCatchStatement.parseHandlers(builder, parser);
        }
        if (GroovyTokenTypes.kFINALLY.equals(builder.getTokenType()) || ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, GroovyTokenTypes.kFINALLY)) {
            TryCatchStatement.parseFinally(builder, parser);
        }
        marker.done(GroovyElementTypes.TRY_BLOCK_STATEMENT);
        return true;
    }

    private static void parseFinally(PsiBuilder builder, GroovyParser parser) {
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        PsiBuilder.Marker finallyMarker = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.kFINALLY);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        PsiBuilder.Marker warn = builder.mark();
        if (GroovyTokenTypes.mLCURLY.equals(builder.getTokenType()) && OpenOrClosableBlock.parseOpenBlock(builder, parser)) {
            warn.drop();
        } else {
            warn.rollbackTo();
            builder.error(GroovyBundle.message("lcurly.expected", new Object[0]));
        }
        finallyMarker.done(GroovyElementTypes.FINALLY_CLAUSE);
    }

    private static void parseHandlers(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker catchMarker = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.kCATCH);
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mLPAREN, GroovyBundle.message("lparen.expected", new Object[0]))) {
            catchMarker.done(GroovyElementTypes.CATCH_CLAUSE);
            return;
        }
        if (!ParameterDeclaration.parseCatchParameter(builder, parser)) {
            builder.error(GroovyBundle.message("param.expected", new Object[0]));
        }
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]))) {
            catchMarker.done(GroovyElementTypes.CATCH_CLAUSE);
            return;
        }
        PsiBuilder.Marker warn = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (!GroovyTokenTypes.mLCURLY.equals(builder.getTokenType()) || !OpenOrClosableBlock.parseOpenBlock(builder, parser)) {
            warn.rollbackTo();
            builder.error(GroovyBundle.message("lcurly.expected", new Object[0]));
        } else {
            warn.drop();
        }
        catchMarker.done(GroovyElementTypes.CATCH_CLAUSE);
        if (builder.getTokenType() == GroovyTokenTypes.kCATCH || ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, GroovyTokenTypes.kCATCH)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            TryCatchStatement.parseHandlers(builder, parser);
        }
    }
}

