/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.AssignmentExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.ConditionalExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class BranchStatement {
    public static final TokenSet BRANCH_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.kRETURN, GroovyTokenTypes.kBREAK, GroovyTokenTypes.kCONTINUE, GroovyTokenTypes.kTHROW, GroovyTokenTypes.kRETURN, GroovyTokenTypes.kASSERT});

    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        if (GroovyTokenTypes.kTHROW.equals(builder.getTokenType())) {
            BranchStatement.throwParse(builder, parser);
            return true;
        }
        if (GroovyTokenTypes.kASSERT.equals(builder.getTokenType())) {
            BranchStatement.assertParse(builder, parser);
            return true;
        }
        if (GroovyTokenTypes.kRETURN.equals(builder.getTokenType())) {
            BranchStatement.returnParse(builder, parser);
            return true;
        }
        if (GroovyTokenTypes.kBREAK.equals(builder.getTokenType()) || GroovyTokenTypes.kCONTINUE.equals(builder.getTokenType())) {
            BranchStatement.breakOrContinueParse(builder);
            return true;
        }
        return false;
    }

    private static void returnParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.kRETURN);
        AssignmentExpression.parse(builder, parser);
        marker.done(GroovyElementTypes.RETURN_STATEMENT);
    }

    private static void throwParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.kTHROW);
        if (!AssignmentExpression.parse(builder, parser)) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        marker.done(GroovyElementTypes.THROW_STATEMENT);
    }

    private static void assertParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.kASSERT);
        if (!ConditionalExpression.parse(builder, parser)) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        if (ParserUtils.lookAhead(builder, GroovyTokenTypes.mCOLON) || GroovyTokenTypes.mCOMMA.equals(builder.getTokenType())) {
            builder.advanceLexer();
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            if (!AssignmentExpression.parse(builder, parser)) {
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            }
        }
        marker.done(GroovyElementTypes.ASSERT_STATEMENT);
    }

    private static void breakOrContinueParse(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        IElementType result2 = GroovyTokenTypes.kBREAK.equals(builder.getTokenType()) ? GroovyElementTypes.BREAK_STATEMENT : GroovyElementTypes.CONTINUE_STATEMENT;
        builder.advanceLexer();
        ParserUtils.getToken(builder, GroovyTokenTypes.mIDENT);
        marker.done(result2);
    }
}

