/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations.Annotation;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.ConditionalExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class AnnotationArguments {
    public static void parse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker annArgs = builder.mark();
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mLPAREN)) {
            annArgs.done((IElementType)GroovyElementTypes.ANNOTATION_ARGUMENTS);
            return;
        }
        if (builder.getTokenType() != GroovyTokenTypes.mRPAREN) {
            AnnotationArguments.parsePairs(builder, parser);
        }
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        ParserUtils.getToken(builder, GroovyTokenTypes.mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]));
        annArgs.done((IElementType)GroovyElementTypes.ANNOTATION_ARGUMENTS);
    }

    private static boolean checkIdentAndAssign(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        boolean result2 = ParserUtils.getToken(builder, TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS) && ParserUtils.getToken(builder, GroovyTokenTypes.mASSIGN);
        marker.rollbackTo();
        return result2;
    }

    public static boolean parseAnnotationMemberValueInitializer(PsiBuilder builder, GroovyParser parser) {
        if (builder.getTokenType() == GroovyTokenTypes.mAT) {
            return Annotation.parse(builder, parser);
        }
        if (builder.getTokenType() == GroovyTokenTypes.mLBRACK) {
            PsiBuilder.Marker marker = builder.mark();
            ParserUtils.getToken(builder, GroovyTokenTypes.mLBRACK);
            while (AnnotationArguments.parseAnnotationMemberValueInitializer(builder, parser) && !builder.eof() && builder.getTokenType() != GroovyTokenTypes.mRBRACK) {
                ParserUtils.getToken(builder, GroovyTokenTypes.mCOMMA, GroovyBundle.message("comma.expected", new Object[0]));
            }
            ParserUtils.getToken(builder, GroovyTokenTypes.mRBRACK, GroovyBundle.message("rbrack.expected", new Object[0]));
            marker.done(GroovyElementTypes.ANNOTATION_ARRAY_INITIALIZER);
            return true;
        }
        return ConditionalExpression.parse(builder, parser) && !ParserUtils.getToken(builder, GroovyTokenTypes.mASSIGN);
    }

    private static boolean parsePairs(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker start = builder.mark();
        if (!AnnotationArguments.parsePair(builder, parser)) {
            start.rollbackTo();
            return false;
        }
        while (ParserUtils.getToken(builder, GroovyTokenTypes.mCOMMA)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            AnnotationArguments.parsePair(builder, parser);
        }
        start.drop();
        return true;
    }

    private static boolean parsePair(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker lfMarker;
        PsiBuilder.Marker marker = builder.mark();
        if (AnnotationArguments.checkIdentAndAssign(builder)) {
            ParserUtils.getToken(builder, TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS);
            ParserUtils.getToken(builder, GroovyTokenTypes.mASSIGN);
            lfMarker = builder.mark();
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        } else {
            lfMarker = null;
        }
        if (!AnnotationArguments.parseAnnotationMemberValueInitializer(builder, parser)) {
            if (lfMarker != null) {
                lfMarker.rollbackTo();
                builder.error(GroovyBundle.message("annotation.member.value.initializer.expected", new Object[0]));
            } else {
                builder.error(GroovyBundle.message("annotation.attribute.expected", new Object[0]));
            }
        } else if (lfMarker != null) {
            lfMarker.drop();
        }
        marker.done((IElementType)GroovyElementTypes.ANNOTATION_MEMBER_VALUE_PAIR);
        return true;
    }
}

