/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.Stack;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;

public abstract class GroovyLexerBase
implements FlexLexer {
    private static final TokenSet DIVISION_IS_EXPECTED_AFTER = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSets.KEYWORDS, TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mINC, GroovyTokenTypes.mDEC, GroovyTokenTypes.mRPAREN, GroovyTokenTypes.mRBRACK, GroovyTokenTypes.mRCURLY, GroovyTokenTypes.mSTRING_LITERAL, GroovyTokenTypes.mGSTRING_LITERAL, GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END, GroovyTokenTypes.mNUM_INT, GroovyTokenTypes.mNUM_FLOAT, GroovyTokenTypes.mNUM_DOUBLE, GroovyTokenTypes.mNUM_BIG_INT, GroovyTokenTypes.mNUM_BIG_DECIMAL, GroovyTokenTypes.mIDENT, GroovyTokenTypes.mDOLLAR})});
    public final Stack<Integer> stateStack = new Stack();
    private final Stack<IElementType> bracesStack = new Stack();

    protected void yybeginstate(int ... states) {
        for (int state : states) {
            this.stateStack.push((Object)state);
            this.yybegin(state);
        }
    }

    protected void yyendstate(int ... states) {
        for (int state : states) {
            int previous;
            int n = previous = this.stateStack.isEmpty() ? this.getInitialState() : ((Integer)this.stateStack.pop()).intValue();
            if (previous == state) continue;
            throw new RuntimeException("States does not match: previous=" + previous + ", expected=" + state);
        }
        this.yybegin(this.stateStack.isEmpty() ? this.getInitialState() : ((Integer)this.stateStack.peek()).intValue());
    }

    protected void resetState() {
        this.stateStack.clear();
        this.bracesStack.clear();
    }

    protected IElementType storeToken(IElementType tokenType) {
        if (TokenSets.LEFT_BRACES.contains(tokenType)) {
            this.bracesStack.push((Object)tokenType);
        } else if (tokenType == GroovyTokenTypes.mRCURLY) {
            IElementType leftType = GroovyTokenTypes.mLCURLY;
            while (!this.bracesStack.isEmpty() && leftType != this.bracesStack.peek()) {
                this.bracesStack.pop();
            }
            if (!this.bracesStack.isEmpty() && leftType == this.bracesStack.peek()) {
                this.bracesStack.pop();
            }
        } else if (!(tokenType != GroovyTokenTypes.mRPAREN && tokenType != GroovyTokenTypes.mRBRACK || this.bracesStack.isEmpty() || this.bracesStack.peek() == GroovyTokenTypes.mLCURLY)) {
            this.bracesStack.pop();
        }
        if (ArrayUtil.indexOf((int[])this.getDivisionStates(), (int)this.yystate()) != -1 && DIVISION_IS_EXPECTED_AFTER.contains(tokenType)) {
            this.yybeginstate(this.getDivisionExpectedState());
        }
        return tokenType;
    }

    protected boolean isWithinBraces() {
        return !this.bracesStack.empty() && this.bracesStack.peek() != GroovyTokenTypes.mLCURLY;
    }

    protected abstract int getInitialState();

    protected abstract int[] getDivisionStates();

    protected abstract int getDivisionExpectedState();
}

