/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer._GroovyDocLexer;

public class GroovyDocLexer
extends MergingLexerAdapter {
    private static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{GroovyDocTokenTypes.mGDOC_COMMENT_DATA, TokenType.WHITE_SPACE});

    public GroovyDocLexer() {
        super((Lexer)new LookAheadLexer((Lexer)new AsteriskStripperLexer(new _GroovyDocLexer())){

            protected void lookAhead(@NotNull Lexer baseLexer) {
                if (baseLexer == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (baseLexer.getTokenType() == GroovyDocTokenTypes.mGDOC_INLINE_TAG_END) {
                    this.advanceAs(baseLexer, GroovyDocTokenTypes.mGDOC_COMMENT_DATA);
                    return;
                }
                if (baseLexer.getTokenType() == GroovyDocTokenTypes.mGDOC_INLINE_TAG_START) {
                    IElementType type;
                    int depth = 0;
                    while ((type = baseLexer.getTokenType()) != null) {
                        if (type == GroovyDocTokenTypes.mGDOC_INLINE_TAG_START) {
                            ++depth;
                        }
                        this.advanceLexer(baseLexer);
                        if (type == GroovyDocTokenTypes.mGDOC_INLINE_TAG_END) {
                            --depth;
                        }
                        if (depth != 0) continue;
                        break;
                    }
                    return;
                }
                super.lookAhead(baseLexer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "org/jetbrains/plugins/groovy/lang/groovydoc/lexer/GroovyDocLexer$1", "lookAhead"));
            }
        }, TOKENS_TO_MERGE);
    }

    private static class AsteriskStripperLexer
    extends LexerBase {
        private final _GroovyDocLexer myFlexLexer;
        private CharSequence myBuffer;
        private int myBufferIndex;
        private int myBufferEndOffset;
        private int myTokenEndOffset;
        private int myState;
        private IElementType myTokenType;
        private boolean myAfterLineBreak;
        private boolean myInLeadingSpace;

        public AsteriskStripperLexer(_GroovyDocLexer lexer) {
            this.myFlexLexer = lexer;
        }

        public final void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            if (buffer == null) {
                AsteriskStripperLexer.$$$reportNull$$$0(0);
            }
            this.myBuffer = buffer;
            this.myBufferIndex = startOffset;
            this.myBufferEndOffset = endOffset;
            this.myTokenType = null;
            this.myTokenEndOffset = startOffset;
            this.myFlexLexer.reset(this.myBuffer, startOffset, endOffset, initialState);
        }

        public int getState() {
            return this.getTokenStart() == 0 ? 0 : this.myState;
        }

        @NotNull
        public CharSequence getBufferSequence() {
            CharSequence charSequence = this.myBuffer;
            if (charSequence == null) {
                AsteriskStripperLexer.$$$reportNull$$$0(1);
            }
            return charSequence;
        }

        public int getBufferEnd() {
            return this.myBufferEndOffset;
        }

        public final IElementType getTokenType() {
            this.locateToken();
            return this.myTokenType;
        }

        public final int getTokenStart() {
            this.locateToken();
            return this.myBufferIndex;
        }

        public final int getTokenEnd() {
            this.locateToken();
            return this.myTokenEndOffset;
        }

        public final void advance() {
            this.locateToken();
            this.myTokenType = null;
        }

        protected final void locateToken() {
            if (this.myTokenType != null) {
                return;
            }
            this._locateToken();
            if (this.myTokenType == TokenType.WHITE_SPACE) {
                this.myAfterLineBreak = CharArrayUtil.containLineBreaks((CharSequence)this.myBuffer, (int)this.getTokenStart(), (int)this.getTokenEnd());
            }
        }

        private void _locateToken() {
            if (this.myTokenEndOffset == this.myBufferEndOffset) {
                this.myTokenType = null;
                this.myBufferIndex = this.myBufferEndOffset;
                return;
            }
            this.myBufferIndex = this.myTokenEndOffset;
            if (this.myAfterLineBreak) {
                this.myAfterLineBreak = false;
                while (this.myTokenEndOffset < this.myBufferEndOffset && this.myBuffer.charAt(this.myTokenEndOffset) == '*' && (this.myTokenEndOffset + 1 >= this.myBufferEndOffset || this.myBuffer.charAt(this.myTokenEndOffset + 1) != '/')) {
                    ++this.myTokenEndOffset;
                }
                this.myInLeadingSpace = true;
                if (this.myBufferIndex < this.myTokenEndOffset) {
                    this.myTokenType = GroovyDocTokenTypes.mGDOC_ASTERISKS;
                    return;
                }
            }
            if (this.myInLeadingSpace) {
                this.myInLeadingSpace = false;
                boolean lf = false;
                while (this.myTokenEndOffset < this.myBufferEndOffset && Character.isWhitespace(this.myBuffer.charAt(this.myTokenEndOffset))) {
                    if (this.myBuffer.charAt(this.myTokenEndOffset) == '\n') {
                        lf = true;
                    }
                    ++this.myTokenEndOffset;
                }
                int state = this.myFlexLexer.yystate();
                if (state == 4 || this.myTokenEndOffset < this.myBufferEndOffset && (this.myBuffer.charAt(this.myTokenEndOffset) == '@' || this.myBuffer.charAt(this.myTokenEndOffset) == '{' || this.myBuffer.charAt(this.myTokenEndOffset) == '\"' || this.myBuffer.charAt(this.myTokenEndOffset) == '<')) {
                    this.myFlexLexer.yybegin(2);
                }
                if (this.myBufferIndex < this.myTokenEndOffset) {
                    this.myTokenType = lf || state == 8 || state == 6 || state == 16 || state == 12 ? TokenType.WHITE_SPACE : GroovyDocTokenTypes.mGDOC_COMMENT_DATA;
                    return;
                }
            }
            this.flexLocateToken();
        }

        private void flexLocateToken() {
            try {
                this.myState = this.myFlexLexer.yystate();
                this.myFlexLexer.goTo(this.myBufferIndex);
                this.myTokenType = this.myFlexLexer.advance();
                this.myTokenEndOffset = this.myFlexLexer.getTokenEnd();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/groovydoc/lexer/GroovyDocLexer$AsteriskStripperLexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/groovydoc/lexer/GroovyDocLexer$AsteriskStripperLexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBufferSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

